/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import mondrian.test.loader.CsvLoader;
import mondrian.test.loader.DBLoader;

public class CsvDBLoader
extends DBLoader {
    public static final String ACTION_BEFORE_TAG = "ActionBefore:";
    public static final String ACTION_AFTER_TAG = "ActionAfter:";
    public static final String DROP_INDEX_TAG = "DropIndex";
    public static final String CREATE_INDEX_TAG = "CreateIndex";
    public static final String TABLE_NAME_TAG = "TableName:";
    public static final String COLUMN_NAMES_TAG = "ColumnNames:";
    public static final String COLUMN_TYPES_TAG = "ColumnTypes:";
    public static final String FILE_NAME_TAG = "FileName:";
    public static final String NOS_OF_ROWS_TAG = "NosOfRows:";
    private File inputDirectory;
    private String inputDirectoryRegex;
    private File[] inputFiles;
    private File inputFile;

    public void setInputDirectory(File inputDirectory) {
        this.inputDirectory = inputDirectory;
    }

    public File getInputDirectory() {
        return this.inputDirectory;
    }

    public void setInputDirectoryRegex(String inputDirectoryRegex) {
        this.inputDirectoryRegex = inputDirectoryRegex;
    }

    public String getInputDirectoryRegex() {
        return this.inputDirectoryRegex;
    }

    public void setInputFiles(File[] inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File[] getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    @Override
    public DBLoader.Table[] getTables() throws Exception {
        this.initialize();
        if (this.inputDirectory != null) {
            return this.getTablesFromDirectory();
        }
        if (this.inputFiles != null) {
            return this.getTablesFromFiles();
        }
        if (this.inputFile != null) {
            return this.getTablesFromFile();
        }
        return new DBLoader.Table[0];
    }

    public DBLoader.Table[] getTablesFromDirectory() throws Exception {
        File[] files;
        if (this.inputDirectoryRegex == null) {
            files = this.inputDirectory.listFiles();
        } else {
            final Pattern pat = Pattern.compile(this.inputDirectoryRegex);
            files = this.inputDirectory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return pat.matcher(name).matches();
                }
            });
            if (files == null) {
                files = new File[]{};
            }
        }
        return this.getTables(files);
    }

    public DBLoader.Table[] getTablesFromFiles() throws Exception {
        return this.getTables(this.inputFiles);
    }

    public DBLoader.Table[] getTablesFromFile() throws Exception {
        ArrayList<DBLoader.Table> list = new ArrayList<DBLoader.Table>();
        this.loadTables(this.inputFile, list);
        return list.toArray(new DBLoader.Table[list.size()]);
    }

    public DBLoader.Table[] getTables(File[] files) throws Exception {
        ArrayList<DBLoader.Table> list = new ArrayList<DBLoader.Table>();
        for (File file : files) {
            this.loadTables(file, list);
        }
        return list.toArray(new DBLoader.Table[list.size()]);
    }

    public DBLoader.Table[] getTables(Reader reader) throws Exception {
        ArrayList<DBLoader.Table> list = new ArrayList<DBLoader.Table>();
        this.loadTables(reader, list);
        return list.toArray(new DBLoader.Table[list.size()]);
    }

    private static File resolveFile(File file) {
        if (file.isAbsolute()) {
            return file;
        }
        for (File base = new File(System.getProperty("user.dir")); base != null; base = base.getParentFile()) {
            File file2 = new File(base, file.getPath());
            if (!file2.exists()) continue;
            return file2;
        }
        return file;
    }

    public void loadTables(File file, List<DBLoader.Table> tableList) throws Exception {
        FileReader reader = new FileReader(CsvDBLoader.resolveFile(file));
        this.loadTables(reader, tableList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTables(Reader reader, List<DBLoader.Table> tableList) throws Exception {
        CsvLoader csvloader = null;
        try {
            DBLoader.Table table = null;
            ArrayList<String> beforeActionList = new ArrayList<String>();
            ArrayList<String> afterActionList = new ArrayList<String>();
            String tableName = null;
            Object[] columnNames = null;
            Object[] columnTypes = null;
            String fileName = null;
            int nosOfRowsStr = -1;
            boolean ok = false;
            csvloader = new CsvLoader(reader);
            int lineNos = 0;
            while (csvloader.hasNextLine()) {
                CsvLoaderRowStream rowStream;
                Object[] values = csvloader.nextLine();
                ++lineNos;
                if (values.length == 0) continue;
                Object value0 = values[0];
                if (((String)value0).startsWith("##") && fileName == null) {
                    String s;
                    int index;
                    if (table != null) {
                        table = null;
                        beforeActionList.clear();
                        afterActionList.clear();
                        tableName = null;
                        columnNames = null;
                        columnTypes = null;
                        fileName = null;
                        nosOfRowsStr = -1;
                    }
                    if ((index = ((String)value0).indexOf(ACTION_BEFORE_TAG)) != -1) {
                        s = ((String)value0).substring(index + ACTION_BEFORE_TAG.length());
                        if (s.length() == 0) {
                            throw new IOException("CSV File parse Error:  no action before sql, linenos " + lineNos);
                        }
                        if (!(s = s.trim()).startsWith(DROP_INDEX_TAG)) {
                            throw new IOException("CSV File parse Error:  unknown before action" + s + ", linenos " + lineNos);
                        }
                        index = s.indexOf(32);
                        if (index < 0) {
                            throw new IOException("CSV File parse Error:  no index name in before action" + s + ", linenos " + lineNos);
                        }
                        s = s.substring(index + 1);
                        s = s.trim();
                        beforeActionList.add(s);
                        continue;
                    }
                    index = ((String)value0).indexOf(ACTION_AFTER_TAG);
                    if (index != -1) {
                        s = ((String)value0).substring(index + ACTION_AFTER_TAG.length());
                        if (s.length() == 0) {
                            throw new IOException("CSV File parse Error:  no action after sql, linenos " + lineNos);
                        }
                        if (!(s = s.trim()).startsWith(CREATE_INDEX_TAG)) {
                            throw new IOException("CSV File parse Error:  unknown before action" + s + ", linenos " + lineNos);
                        }
                        index = s.indexOf(32);
                        if (index < 0) {
                            throw new IOException("CSV File parse Error:  no index_name/column_name in after action" + s + ", linenos " + lineNos);
                        }
                        s = s.substring(index + 1);
                        index = (s = s.trim()).indexOf(32);
                        if (index < 0) {
                            throw new IOException("CSV File parse Error:  no column_name after index_name in after action" + s + ", linenos " + lineNos);
                        }
                        afterActionList.add(s);
                        continue;
                    }
                    index = ((String)value0).indexOf(TABLE_NAME_TAG);
                    if (index != -1) {
                        s = ((String)value0).substring(index + TABLE_NAME_TAG.length());
                        if (s.length() == 0) {
                            throw new IOException("CSV File parse Error:  no table name, linenos " + lineNos);
                        }
                        s = s.trim();
                        if (tableName != null) {
                            throw new IOException("CSV File parse Error:  new table name \"" + s + "\" while processing table name \"" + tableName + "\", linenos " + lineNos);
                        }
                        tableName = s;
                        continue;
                    }
                    index = ((String)value0).indexOf(COLUMN_NAMES_TAG);
                    if (index != -1) {
                        s = ((String)value0).substring(index + COLUMN_NAMES_TAG.length());
                        if (s.length() == 0) {
                            throw new IOException("CSV File parse Error:  no column names, linenos " + lineNos);
                        }
                        if (tableName == null) {
                            throw new IOException("CSV File parse Error:  no table name for columns , linenos " + lineNos);
                        }
                        values[0] = s.trim();
                        columnNames = values;
                        continue;
                    }
                    index = ((String)value0).indexOf(COLUMN_TYPES_TAG);
                    if (index != -1) {
                        s = ((String)value0).substring(index + COLUMN_TYPES_TAG.length());
                        if (s.length() == 0) {
                            throw new IOException("CSV File parse Error:  no column types, linenos " + lineNos);
                        }
                        if (columnNames == null) {
                            throw new IOException("CSV File parse Error:  no column names for columns types, linenos " + lineNos);
                        }
                        values[0] = s.trim();
                        columnTypes = values;
                        if (columnNames.length == columnTypes.length) continue;
                        throw new IOException("CSV File parse Error:  number of column names \"" + columnNames.length + "\" does not equal " + " number of column types \"" + columnTypes.length + "\", linenos " + lineNos);
                    }
                    ok = true;
                    index = ((String)value0).indexOf(FILE_NAME_TAG);
                    if (index != -1) {
                        s = ((String)value0).substring(index + FILE_NAME_TAG.length());
                        if (s.length() == 0) {
                            throw new IOException("CSV File parse Error:  no file name , linenos " + lineNos);
                        }
                        if (columnTypes == null) {
                            throw new IOException("CSV File parse Error:  no column types for file name, linenos " + lineNos);
                        }
                        fileName = s.trim();
                        continue;
                    }
                    index = ((String)value0).indexOf(NOS_OF_ROWS_TAG);
                    if (index == -1) continue;
                    s = ((String)value0).substring(index + NOS_OF_ROWS_TAG.length());
                    if (s.length() == 0) {
                        throw new IOException("CSV File parse Error:  no number of rows, linenos " + lineNos);
                    }
                    if (columnTypes == null) {
                        throw new IOException("CSV File parse Error:  no column types for file name, linenos " + lineNos);
                    }
                    nosOfRowsStr = Integer.parseInt(s.trim());
                    continue;
                }
                if (((String)value0).startsWith("# ")) continue;
                if (!ok) {
                    if (tableName == null) {
                        throw new IOException("CSV File parse Error:  no table name before rows, linenos " + lineNos);
                    }
                    if (columnNames == null) {
                        throw new IOException("CSV File parse Error:  no column names before rows, linenos " + lineNos);
                    }
                    if (columnTypes == null) {
                        throw new IOException("CSV File parse Error:  no column types before rows, linenos " + lineNos);
                    }
                }
                DBLoader.Column[] columns = this.loadColumns((String[])columnNames, (String[])columnTypes, lineNos);
                table = new DBLoader.Table(this, tableName, columns);
                table.setBeforeActions(beforeActionList);
                table.setAfterActions(afterActionList);
                tableList.add(table);
                DBLoader.Table.Controller controller = table.getController();
                if (fileName != null) {
                    rowStream = new CsvLoaderRowStream(new CsvLoader(fileName));
                    controller.setRowStream(rowStream);
                    csvloader.nextSet();
                    csvloader.putBack((String[])values);
                    --lineNos;
                    fileName = null;
                    continue;
                }
                if (nosOfRowsStr != -1) {
                    ArrayList<DBLoader.Row> list = new ArrayList<DBLoader.Row>();
                    list.add(new DBLoader.RowDefault(values));
                    while (true) {
                        int n = --nosOfRowsStr;
                        --nosOfRowsStr;
                        if (n <= 0) break;
                        if (!csvloader.hasNextLine()) {
                            throw new Exception("CSV File parse Error:  not enough lines in file " + lineNos);
                        }
                        values = csvloader.nextLine();
                        value0 = values[0];
                        if (((String)value0).startsWith("# ")) {
                            ++nosOfRowsStr;
                            continue;
                        }
                        list.add(new DBLoader.RowDefault(values));
                        ++lineNos;
                    }
                    ListRowStream rowStream2 = new ListRowStream(list);
                    controller.setRowStream(rowStream2);
                    csvloader.nextSet();
                    continue;
                }
                csvloader.putBack((String[])values);
                rowStream = new CsvLoaderRowStream(csvloader);
                controller.setRowStream(rowStream);
                csvloader = null;
                break;
            }
        }
        finally {
            if (csvloader != null) {
                csvloader.close();
            }
        }
    }

    protected DBLoader.Column[] loadColumns(String[] columnNames, String[] columnTypes, int lineNos) throws Exception {
        ArrayList<DBLoader.Column> list = new ArrayList<DBLoader.Column>();
        for (int i = 0; i < columnNames.length; ++i) {
            DBLoader.Type type;
            String columnName = columnNames[i];
            String columnType = columnTypes[i];
            int index = columnType.indexOf(58);
            boolean nullsAllowed = false;
            if (index != -1) {
                String nullString = columnType.substring(index + 1).trim();
                if (!nullString.equalsIgnoreCase("NULL")) {
                    throw new IOException("CSV File parse Error:  for type name \"" + columnType + "\" expecting \"null\" not \"" + nullString + "\", linenos " + lineNos);
                }
                nullsAllowed = true;
                columnType = columnType.substring(0, index).trim();
                type = DBLoader.Type.getType(columnType);
            } else {
                type = DBLoader.Type.getType(columnType);
            }
            if (type == null) {
                type = DBLoader.Type.makeType(columnType);
            }
            if (type == null) {
                throw new IOException("CSV File parse Error:  no type found for type name \"" + columnType + "\", linenos " + lineNos);
            }
            DBLoader.Column column = new DBLoader.Column(columnName, type, nullsAllowed);
            list.add(column);
        }
        return list.toArray(new DBLoader.Column[list.size()]);
    }

    @Override
    protected void check() throws Exception {
        super.check();
        if (this.inputDirectory != null) {
            if (this.inputFiles != null) {
                throw new Exception("Both input Directory and input files can not be set");
            }
            if (this.inputFile != null) {
                throw new Exception("Both input Directory and input file can not be set");
            }
        }
        if (this.inputFiles != null && this.inputFile != null) {
            throw new Exception("Both input input files and input file can not be set");
        }
    }

    protected static File checkDirectory(String dirName) throws Exception {
        File dir = new File(dirName);
        if (!dir.exists()) {
            throw new Exception("The directory \"" + dirName + "\" does not exist");
        }
        if (!dir.isDirectory()) {
            throw new Exception("The file \"" + dirName + "\" is not a directory");
        }
        return dir;
    }

    protected static void usage(String msg) {
        StringBuilder buf = new StringBuilder(500);
        if (msg != null) {
            buf.append(msg);
            buf.append(nl);
        }
        buf.append("Usage: CsvDBLoader ");
        buf.append(" [-h or -help]");
        buf.append(" (-p <propertyFile>");
        buf.append(" or -p=<propertyFile>)");
        buf.append(" (-jdbcDrivers <jdbcDriver>");
        buf.append(" or -jdbcDrivers=<jdbcDriver>)");
        buf.append(" (-jdbcURL <jdbcURL>");
        buf.append(" or -jdbcURL=<jdbcURL>)");
        buf.append(" [-user username");
        buf.append(" or -user=username]");
        buf.append(" [-password password");
        buf.append(" or -password=password]");
        buf.append(" [-BatchSize <batch size>");
        buf.append(" or -BatchSize=<batch size>]");
        buf.append(" [-outputDirectory <directory name>");
        buf.append(" or -outputDirectory <directory name>]");
        buf.append(" [-f or -force]");
        buf.append(" [-inputDirectory <directory name>");
        buf.append(" or -inputDirectory <directory name>]");
        buf.append(" [-regex <regular expression>");
        buf.append(" or -regex <regular expression>]");
        buf.append(" (inputFiles)+");
        buf.append(nl);
        buf.append("Options:");
        buf.append(nl);
        buf.append("  <propertyFile>        A property file which can be used to");
        buf.append(nl);
        buf.append("                        to set some of the options.");
        buf.append(nl);
        buf.append("  <jdbcDrivers>         Comma-separated list of JDBC drivers;");
        buf.append(nl);
        buf.append("  <jdbcURL>             JDBC connect string for DB.");
        buf.append(nl);
        buf.append("  [username]            JDBC user name for DB.");
        buf.append(nl);
        buf.append("  [password]            JDBC password for user for DB.");
        buf.append(nl);
        buf.append("  <batch size>          Size of JDBC batch updates - default to 50 inserts.");
        buf.append(nl);
        buf.append("  [outputDirectory]     Directory where per-table sql should be put");
        buf.append(nl);
        buf.append("                        rather than loading the database.");
        buf.append(nl);
        buf.append("  [force]               If output files already exist, delete them");
        buf.append(nl);
        buf.append("  [inputDirectory]     Directory containing input files");
        buf.append(nl);
        buf.append("  [regular expression] A regular expression used to determine");
        buf.append(nl);
        buf.append("                       which files in the input directory to use.");
        buf.append(nl);
        buf.append("The values in the property file are overridden by");
        buf.append(nl);
        buf.append("  the explicit command line options");
        System.out.println(buf.toString());
        System.exit(msg == null ? 0 : 1);
    }

    public static void main(String[] args) throws Exception {
        File dir;
        String propFile = null;
        String jdbcDrivers = null;
        String jdbcURL = null;
        String user = null;
        String password = null;
        String batchSizeStr = null;
        String outputDirectory = null;
        boolean force = false;
        ArrayList<File> files = new ArrayList<File>();
        String inputDirectory = null;
        String regex = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h") || arg.equals("-help")) {
                CsvDBLoader.usage(null);
                continue;
            }
            if (arg.equals("-f") || arg.equals("-force")) {
                force = true;
                continue;
            }
            if (arg.startsWith("-p=")) {
                propFile = args[i].substring("-p=".length());
                continue;
            }
            if (arg.equals("-p")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -p");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -p: " + arg);
                }
                propFile = arg;
                continue;
            }
            if (arg.startsWith("-jdbcDrivers=")) {
                jdbcDrivers = args[i].substring("-jdbcDrivers=".length());
                continue;
            }
            if (arg.equals("-jdbcDrivers")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -jdbcDrivers");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -jdbcDrivers: " + arg);
                }
                jdbcDrivers = arg;
                continue;
            }
            if (arg.startsWith("-jdbcURL=")) {
                jdbcURL = args[i].substring("-jdbcURL=".length());
                continue;
            }
            if (arg.equals("-jdbcURL")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -jdbcURL");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -jdbcURL: " + arg);
                }
                jdbcURL = arg;
                continue;
            }
            if (arg.startsWith("-user=")) {
                user = args[i].substring("-user=".length());
                continue;
            }
            if (arg.equals("-user")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -user");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -user: " + arg);
                }
                user = arg;
                continue;
            }
            if (arg.startsWith("-password=")) {
                password = args[i].substring("-password=".length());
                continue;
            }
            if (arg.equals("-password")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -password");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -password: " + arg);
                }
                password = arg;
                continue;
            }
            if (arg.startsWith("-batchSize=")) {
                batchSizeStr = args[i].substring("-batchSize=".length());
                continue;
            }
            if (arg.equals("-batchSize")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -batchSize");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -batchSize: " + arg);
                }
                batchSizeStr = arg;
                continue;
            }
            if (arg.startsWith("-outputDirectory=")) {
                outputDirectory = args[i].substring("-outputDirectory=".length());
                continue;
            }
            if (arg.equals("-outputDirectory")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -outputDirectory");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -outputDirectory: " + arg);
                }
                outputDirectory = arg;
                continue;
            }
            if (arg.startsWith("-inputDirectory=")) {
                inputDirectory = args[i].substring("-inputDirectory=".length());
                continue;
            }
            if (arg.equals("-inputDirectory")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -inputDirectory");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -inputDirectory: " + arg);
                }
                inputDirectory = arg;
                continue;
            }
            if (arg.startsWith("-regex=")) {
                regex = args[i].substring("-regex=".length());
                continue;
            }
            if (arg.equals("-regex")) {
                if (++i == args.length) {
                    CsvDBLoader.usage("Missing argument for -regex");
                }
                if ((arg = args[i]).startsWith("-")) {
                    CsvDBLoader.usage("Bad argument for -regex: " + arg);
                }
                regex = arg;
                continue;
            }
            if (arg.startsWith("-")) {
                CsvDBLoader.usage("Bad option : " + arg);
                continue;
            }
            File file = new File(arg);
            if (!file.exists()) {
                String msg = "The file \"" + arg + "\" does not exist";
                throw new Exception(msg);
            }
            files.add(file);
        }
        CsvDBLoader loader = new CsvDBLoader();
        if (propFile != null) {
            Properties props = new Properties();
            props.load(new FileInputStream(propFile));
            String v = props.getProperty("mondrian.test.loader.batch.size");
            if (v != null) {
                loader.setBatchSize(Integer.parseInt(v));
            }
            if ((v = props.getProperty("mondrian.test.loader.jdbc.driver")) != null) {
                loader.setJdbcDriver(v);
            }
            if ((v = props.getProperty("mondrian.test.loader.jdbc.url")) != null) {
                loader.setJdbcURL(v);
            }
            if ((v = props.getProperty("mondrian.test.loader.jdbc.user")) != null) {
                loader.setUserName(v);
            }
            if ((v = props.getProperty("mondrian.test.loader.jdbc.password")) != null) {
                loader.setPassword(v);
            }
            if ((v = props.getProperty("mondrian.test.loader.output.directory")) != null) {
                File dir2 = CsvDBLoader.checkDirectory(v);
                loader.setOutputDirectory(dir2);
            }
            if ((v = props.getProperty("mondrian.test.loader.force")) != null) {
                force = Boolean.valueOf(v);
            }
        }
        if (batchSizeStr != null) {
            loader.setBatchSize(Integer.parseInt(batchSizeStr));
        }
        if (jdbcDrivers != null) {
            loader.setJdbcDriver(jdbcDrivers);
        }
        if (jdbcURL != null) {
            loader.setJdbcURL(jdbcURL);
        }
        if (user != null) {
            loader.setUserName(user);
        }
        if (password != null) {
            loader.setPassword(password);
        }
        if (outputDirectory != null) {
            dir = CsvDBLoader.checkDirectory(outputDirectory);
            loader.setOutputDirectory(dir);
        }
        loader.setForce(force);
        if (files.size() == 1) {
            loader.setInputFile((File)files.get(0));
        } else if (files.size() > 1) {
            loader.setInputFiles(files.toArray(new File[files.size()]));
        }
        if (inputDirectory != null) {
            dir = CsvDBLoader.checkDirectory(inputDirectory);
            loader.setInputDirectory(dir);
        }
        if (regex != null) {
            loader.setInputDirectoryRegex(regex);
        }
        loader.initialize();
        DBLoader.Table[] tables = loader.getTables();
        loader.generateStatements(tables);
        loader.executeStatements(tables);
    }

    public static class CsvLoaderRowStream
    implements DBLoader.RowStream {
        private final CsvLoader csvloader;

        CsvLoaderRowStream(CsvLoader csvloader) {
            this.csvloader = csvloader;
        }

        @Override
        public Iterator<DBLoader.Row> iterator() {
            return new Iterator<DBLoader.Row>(){
                String[] line;

                @Override
                public boolean hasNext() {
                    try {
                        boolean hasNext = CsvLoaderRowStream.this.csvloader.hasNextLine();
                        if (!hasNext) {
                            CsvLoaderRowStream.this.csvloader.close();
                        } else {
                            this.line = CsvLoaderRowStream.this.csvloader.nextLine();
                            if (this.line.length > 0 && this.line[0].length() > 0 && this.line[0].startsWith("#")) {
                                return this.hasNext();
                            }
                        }
                        return hasNext;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }

                @Override
                public DBLoader.Row next() {
                    return new DBLoader.RowDefault(this.line);
                }

                @Override
                public void remove() {
                }
            };
        }
    }

    public static class ListRowStream
    implements DBLoader.RowStream {
        private List<DBLoader.Row> list;

        ListRowStream() {
            this(new ArrayList<DBLoader.Row>());
        }

        ListRowStream(List<DBLoader.Row> list) {
            this.list = list;
        }

        void add(DBLoader.Row row) {
            this.list.add(row);
        }

        @Override
        public Iterator<DBLoader.Row> iterator() {
            return this.list.iterator();
        }
    }
}

