/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;

public class MaskDatasource
extends JPanel {
    private JTextField txtName;
    private JTextField txtUrl;
    private JTextField txtUid;
    private JPasswordField txtPwd;
    private JCheckBox cbxRemember;
    private JCheckBox cbxAutoconnect;

    MaskDatasource() {
        this.setBorder(LineBorder.createGrayLineBorder());
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.txtName = new JTextField();
        this.addField(gbl, "name:", this.txtName, 0);
        this.txtUrl = new JTextField();
        this.addField(gbl, "url:", this.txtUrl, 25);
        this.txtUid = new JTextField();
        this.addField(gbl, "user:", this.txtUid, 5);
        this.txtPwd = new JPasswordField();
        this.addField(gbl, "password:", this.txtPwd, 5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(8, 5, 0, 0);
        this.cbxRemember = new JCheckBox("remember password");
        gbl.setConstraints(this.cbxRemember, gbc);
        this.add(this.cbxRemember);
        gbc.insets = new Insets(1, 5, 0, 0);
        this.cbxAutoconnect = new JCheckBox("auto-connect on startup");
        gbl.setConstraints(this.cbxAutoconnect, gbc);
        this.add(this.cbxAutoconnect);
    }

    private void addField(GridBagLayout gbl, String text, JComponent txt, int top) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(top, 8, 1, 8);
        JLabel lbl = new JLabel(text);
        gbl.setConstraints(lbl, gbc);
        this.add(lbl);
        gbc.fill = 2;
        gbc.insets = new Insets(0, 8, 0, 8);
        gbc.weightx = 1.0;
        gbl.setConstraints(txt, gbc);
        this.add(txt);
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setEnabled(b);
        }
    }

    void load(UoDatasource info) {
        this.txtName.setText(info.name);
        this.txtUrl.setText(info.url);
        this.txtUid.setText(info.uid);
        this.txtPwd.setText(info.remember ? info.pwd : null);
        this.cbxRemember.setSelected(info.remember);
        this.cbxAutoconnect.setSelected(info.auto_connect);
    }

    boolean unload(UoDatasource info) {
        if (Text.isEmpty(this.txtName.getText()) || Text.isEmpty(this.txtUrl.getText())) {
            Application.alert("SQLeonardo", "please, enter a valid name.");
            return false;
        }
        if (this.txtName.getText().indexOf(46) != -1 || this.txtName.getText().indexOf(44) != -1 || this.txtName.getText().indexOf(59) != -1 || this.txtName.getText().indexOf(58) != -1 || this.txtName.getText().indexOf(124) != -1 || this.txtName.getText().indexOf(47) != -1 || this.txtName.getText().indexOf(60) != -1 || this.txtName.getText().indexOf(62) != -1 || this.txtName.getText().indexOf(64) != -1 || this.txtName.getText().indexOf(92) != -1) {
            Application.alert("SQLeonardo", "characters \\.|,/;<:>@ aren't allowed!\nplease, enter a valid name.");
            return false;
        }
        info.name = this.txtName.getText().trim();
        info.url = this.txtUrl.getText().trim();
        info.uid = this.txtUid.getText().trim();
        info.pwd = String.valueOf(this.txtPwd.getPassword());
        info.remember = this.cbxRemember.isSelected();
        info.auto_connect = this.cbxAutoconnect.isSelected();
        return true;
    }
}

