/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.openide.ErrorManager;

public abstract class SyntaxUpdateTokens {
    public static List getTokenInfoList(DocumentEvent documentEvent) {
        if (!(documentEvent instanceof BaseDocumentEvent)) {
            return Collections.EMPTY_LIST;
        }
        return ((BaseDocumentEvent)documentEvent).getSyntaxUpdateTokenList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTokenInfoList(Document document) {
        List list;
        SyntaxUpdateTokens syntaxUpdateTokens = (SyntaxUpdateTokens)document.getProperty(SyntaxUpdateTokens.class);
        if (syntaxUpdateTokens == null || !(document instanceof BaseDocument)) {
            return Collections.EMPTY_LIST;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        baseDocument.readLock();
        try {
            syntaxUpdateTokens.syntaxUpdateStart();
            try {
                baseDocument.getSyntaxSupport().tokenizeText(new AllTokensProcessor(syntaxUpdateTokens), 0, baseDocument.getLength(), true);
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(1, (Throwable)badLocationException);
            }
            finally {
                list = syntaxUpdateTokens.syntaxUpdateEnd();
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return list;
    }

    public abstract void syntaxUpdateStart();

    public abstract List syntaxUpdateEnd();

    public abstract void syntaxUpdateToken(TokenID var1, TokenContextPath var2, int var3, int var4);

    static final class AllTokensProcessor
    implements TokenProcessor {
        private SyntaxUpdateTokens suTokens;
        private int bufferStartOffset;

        AllTokensProcessor(SyntaxUpdateTokens syntaxUpdateTokens) {
            this.suTokens = syntaxUpdateTokens;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.bufferStartOffset = n3 - n;
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            this.suTokens.syntaxUpdateToken(tokenID, tokenContextPath, n, n2);
            return true;
        }

        public int eot(int n) {
            return 0;
        }
    }

    public class TokenInfo {
        private final TokenID id;
        private final TokenContextPath contextPath;
        private final int offset;
        private final int length;

        public TokenInfo(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            this.id = tokenID;
            this.contextPath = tokenContextPath;
            this.offset = n;
            this.length = n2;
        }

        public final TokenID getID() {
            return this.id;
        }

        public final TokenContextPath getContextPath() {
            return this.contextPath;
        }

        public final int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return "id=" + this.id + ", ctx=" + this.contextPath + ", off=" + this.offset + ", len=" + this.length;
        }
    }
}

