/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.search.RegexpMaker;
import org.netbeans.modules.search.TextDetail;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openidex.search.SearchPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BasicSearchCriteria {
    private static final int MAX_UNRECOGNIZED_FILE_SIZE = 0x500000;
    private static int instanceCounter;
    private final int instanceId = instanceCounter++;
    private static final Logger LOG;
    private static final Collection<String> searchableXMimeTypes;
    private String textPatternExpr;
    private String fileNamePatternExpr;
    private String replaceExpr;
    private boolean wholeWords;
    private boolean caseSensitive;
    private boolean regexp;
    private boolean textPatternSpecified = false;
    private boolean fileNamePatternSpecified = false;
    private boolean textPatternValid = false;
    private boolean fileNamePatternValid = false;
    private Pattern textPattern;
    private Pattern fileNamePattern;
    private boolean criteriaUsable = false;
    private ChangeListener usabilityChangeListener;
    private Charset lastCharset = null;
    private Map<DataObject, List<TextDetail>> detailsMap;

    BasicSearchCriteria() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": <init>()");
        }
    }

    BasicSearchCriteria(BasicSearchCriteria basicSearchCriteria) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": <init>(template)");
        }
        this.setCaseSensitive(basicSearchCriteria.caseSensitive);
        this.setWholeWords(basicSearchCriteria.wholeWords);
        this.setRegexp(basicSearchCriteria.regexp);
        this.setTextPattern(basicSearchCriteria.textPatternExpr);
        this.setFileNamePattern(basicSearchCriteria.fileNamePatternExpr);
        this.setReplaceString(basicSearchCriteria.replaceExpr);
    }

    Pattern getTextPattern() {
        if (!this.textPatternValid) {
            return null;
        }
        if (this.textPattern != null) {
            return this.textPattern;
        }
        if (this.regexp) {
            assert (false);
            this.textPatternValid = this.compileRegexpPattern();
        } else {
            this.compileSimpleTextPattern();
            boolean bl = this.textPatternValid = this.textPattern != null;
        }
        assert (this.textPattern != null);
        return this.textPattern;
    }

    String getTextPatternExpr() {
        return this.textPatternExpr != null ? this.textPatternExpr : "";
    }

    void setTextPattern(String string) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setTextPattern(" + string + ')');
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null && this.textPatternExpr == null || string != null && string.equals(this.textPatternExpr)) {
            LOG.finest(" - no change");
            return;
        }
        if (string == null) {
            this.textPatternExpr = null;
            this.textPattern = null;
            this.textPatternSpecified = false;
            this.textPatternValid = false;
        } else {
            this.textPatternExpr = string;
            this.textPatternSpecified = true;
            if (!this.regexp) {
                this.textPattern = null;
                this.textPatternValid = true;
            } else {
                this.textPatternValid = this.compileRegexpPattern();
                assert (this.textPattern != null || !this.textPatternValid);
            }
        }
        this.updateUsability();
    }

    private boolean compileRegexpPattern() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": compileRegexpPattern()");
        }
        assert (this.regexp);
        assert (this.textPatternExpr != null);
        try {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - textPatternExpr = \"" + this.textPatternExpr + '\"');
            }
            this.textPattern = Pattern.compile(this.textPatternExpr);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LOG.finest(" - invalid regexp - setting 'textPattern' to <null>");
            this.textPattern = null;
            return false;
        }
    }

    private void compileSimpleTextPattern() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("#" + this.instanceId + ": compileRegexpPattern()");
        }
        assert (!this.regexp);
        assert (this.textPatternExpr != null);
        try {
            int n = 0;
            if (!this.caseSensitive) {
                n |= 2;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - textPatternExpr = \"" + this.textPatternExpr + '\"');
            }
            String string = RegexpMaker.makeRegexp(this.textPatternExpr, this.wholeWords);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(" - regexp = \"" + string + '\"');
            }
            this.textPattern = Pattern.compile(string, n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            LOG.finest(" - invalid regexp");
            assert (false);
            this.textPattern = null;
        }
    }

    boolean isRegexp() {
        return this.regexp;
    }

    void setRegexp(boolean bl) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setRegexp(" + bl + ')');
        }
        if (bl == this.regexp) {
            LOG.finest(" - no change");
            return;
        }
        this.regexp = bl;
        if (this.textPatternExpr != null) {
            if (bl) {
                this.textPatternValid = this.compileRegexpPattern();
            } else {
                this.textPatternValid = true;
                this.textPattern = null;
            }
        }
        this.updateUsability();
    }

    boolean isWholeWords() {
        return this.wholeWords;
    }

    void setWholeWords(boolean bl) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setWholeWords(" + bl + ')');
        }
        if (bl == this.wholeWords) {
            LOG.finest(" - no change");
            return;
        }
        this.wholeWords = bl;
        if (!this.regexp) {
            this.textPattern = null;
        }
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setCaseSensitive(boolean bl) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("setCaseSensitive(" + bl + ')');
        }
        if (bl == this.caseSensitive) {
            LOG.finest(" - no change");
            return;
        }
        this.caseSensitive = bl;
        if (!this.regexp) {
            this.textPattern = null;
        }
    }

    boolean isFullText() {
        return this.textPatternValid;
    }

    Pattern getFileNamePattern() {
        if (!this.fileNamePatternValid) {
            return null;
        }
        assert (this.fileNamePatternExpr != null && this.fileNamePatternExpr.length() != 0);
        if (this.fileNamePattern != null) {
            return this.fileNamePattern;
        }
        this.compileSimpleFileNamePattern();
        assert (this.fileNamePattern != null);
        return this.fileNamePattern;
    }

    String getFileNamePatternExpr() {
        return this.fileNamePatternExpr != null ? this.fileNamePatternExpr : "";
    }

    void setFileNamePattern(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string == null && this.fileNamePatternExpr == null || string != null && string.equals(this.fileNamePatternExpr)) {
            return;
        }
        if (string == null) {
            this.fileNamePatternExpr = null;
            this.fileNamePattern = null;
            this.fileNamePatternSpecified = false;
            this.fileNamePatternValid = false;
        } else {
            this.fileNamePatternExpr = string;
            this.fileNamePattern = null;
            this.fileNamePatternValid = this.fileNamePatternSpecified = BasicSearchCriteria.checkFileNamePattern(this.fileNamePatternExpr);
        }
        this.updateUsability();
    }

    private void compileSimpleFileNamePattern() {
        assert (this.fileNamePatternExpr != null);
        try {
            this.fileNamePattern = Pattern.compile(RegexpMaker.makeMultiRegexp(this.fileNamePatternExpr), 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            assert (false);
            this.fileNamePattern = null;
        }
    }

    private static boolean checkFileNamePattern(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (c == ',' || c == ' ') continue;
            return true;
        }
        return false;
    }

    boolean isSearchAndReplace() {
        return this.replaceExpr != null;
    }

    String getReplaceExpr() {
        return this.replaceExpr;
    }

    void setReplaceString(String string) {
        this.replaceExpr = string;
    }

    private void updateUsability() {
        boolean bl = this.criteriaUsable;
        this.criteriaUsable = this.isUsable();
        if (this.criteriaUsable != bl) {
            this.fireUsabilityChanged();
        }
    }

    boolean isUsable() {
        return (this.textPatternSpecified || !this.isSearchAndReplace() && this.fileNamePatternSpecified) && !this.isInvalid();
    }

    private boolean isInvalid() {
        return this.isTextPatternInvalid() || this.isFileNamePatternInvalid();
    }

    void setUsabilityChangeListener(ChangeListener changeListener) {
        this.usabilityChangeListener = changeListener;
    }

    private void fireUsabilityChanged() {
        if (this.usabilityChangeListener != null) {
            this.usabilityChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    boolean isTextPatternUsable() {
        return this.textPatternSpecified && this.textPatternValid;
    }

    boolean isTextPatternInvalid() {
        return this.textPatternSpecified && !this.textPatternValid;
    }

    boolean isFileNamePatternUsable() {
        return this.fileNamePatternSpecified && this.fileNamePatternValid;
    }

    boolean isFileNamePatternInvalid() {
        return this.fileNamePatternSpecified && !this.fileNamePatternValid;
    }

    void onOk() {
        LOG.finer("onOk()");
        if (this.textPatternValid && this.textPattern == null) {
            assert (!this.regexp);
            this.compileSimpleTextPattern();
        }
        if (this.fileNamePatternValid && this.fileNamePattern == null) {
            this.compileSimpleFileNamePattern();
        }
        assert (!this.textPatternValid || this.textPattern != null);
        assert (!this.fileNamePatternValid || this.fileNamePattern != null);
    }

    boolean matches(DataObject dataObject) {
        this.lastCharset = null;
        if (!dataObject.isValid()) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject.isFolder() || !fileObject.isValid() || this.isFullText() && !BasicSearchCriteria.isTextFile(fileObject)) {
            return false;
        }
        if (this.fileNamePatternValid && !this.fileNamePattern.matcher(fileObject.getNameExt()).matches()) {
            return false;
        }
        return !this.textPatternValid || this.checkFileContent(fileObject, dataObject);
    }

    Charset getLastUsedCharset() {
        return this.lastCharset;
    }

    private static boolean isTextFile(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        if (string.equals("content/unknown")) {
            return fileObject.getSize() <= 0x500000L;
        }
        if (string.startsWith("text/")) {
            return true;
        }
        if (string.startsWith("application/")) {
            String string2 = string.substring(12);
            return string2.equals("rtf") || string2.equals("sgml") || string2.startsWith("xml-") || string2.endsWith("+xml") || string2.startsWith("x-") && searchableXMimeTypes.contains(string2.substring(2));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFileContent(FileObject fileObject, DataObject dataObject) {
        boolean bl = true;
        SearchPattern searchPattern = null;
        ArrayList<TextDetail> arrayList = null;
        LineNumberReader lineNumberReader = null;
        try {
            String string;
            lineNumberReader = this.getFileObjectReader(fileObject);
            while ((string = lineNumberReader.readLine()) != null) {
                Matcher matcher = this.textPattern.matcher(string);
                while (matcher.find()) {
                    if (bl) {
                        searchPattern = this.createSearchPattern();
                        arrayList = new ArrayList<TextDetail>(5);
                        bl = false;
                    }
                    TextDetail textDetail = new TextDetail(dataObject, searchPattern);
                    textDetail.setLine(lineNumberReader.getLineNumber());
                    textDetail.setLineText(string);
                    int n = matcher.start();
                    int n2 = matcher.end() - n;
                    textDetail.setColumn(n + 1);
                    textDetail.setMarkLength(n2);
                    arrayList.add(textDetail);
                }
            }
            if (arrayList != null) {
                arrayList.trimToSize();
                this.getDetailsMap().put(dataObject, (List<TextDetail>)arrayList);
                boolean bl2 = true;
                return bl2;
            }
            boolean bl3 = false;
            return bl3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            boolean bl4 = false;
            return bl4;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            boolean bl5 = false;
            return bl5;
        }
        finally {
            if (lineNumberReader != null) {
                try {
                    lineNumberReader.close();
                    lineNumberReader = null;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }

    private LineNumberReader getFileObjectReader(FileObject fileObject) throws FileNotFoundException {
        InputStream inputStream = fileObject.getInputStream();
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, charset));
        this.lastCharset = charset;
        return lineNumberReader;
    }

    public Node[] getDetails(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        if (list == null) {
            return null;
        }
        ArrayList<TextDetail.DetailNode> arrayList = new ArrayList<TextDetail.DetailNode>(list.size());
        for (TextDetail textDetail : list) {
            arrayList.add(new TextDetail.DetailNode(textDetail));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<DataObject, List<TextDetail>> getDetailsMap() {
        if (this.detailsMap != null) {
            return this.detailsMap;
        }
        BasicSearchCriteria basicSearchCriteria = this;
        synchronized (basicSearchCriteria) {
            if (this.detailsMap == null) {
                this.detailsMap = new HashMap<DataObject, List<TextDetail>>(20);
            }
        }
        return this.detailsMap;
    }

    public Node[] getDetails(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        return this.getDetails(dataObject);
    }

    public int getDetailsCount(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        return list != null ? list.size() : 0;
    }

    public List<TextDetail> getTextDetails(Object object) {
        List<TextDetail> list = this.getDetailsMap().get(object);
        return list != null ? new ArrayList<TextDetail>(list) : null;
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.create((String)this.textPatternExpr, (boolean)this.wholeWords, (boolean)this.caseSensitive, (boolean)this.regexp);
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.search.BasicSearchCriteria");
        searchableXMimeTypes = new HashSet<String>(17);
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-eruby");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
    }
}

