/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.PackageScope;
import groovyjarjarasm.asm.Opcodes;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class PackageScopeASTTransformation
implements ASTTransformation,
Opcodes {
    private static final Class MY_CLASS = PackageScope.class;
    private static final ClassNode MY_TYPE = new ClassNode(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();

    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (!(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            this.visitClassNode((ClassNode)parent);
        } else if (parent instanceof FieldNode) {
            this.visitFieldNode((FieldNode)parent);
        }
    }

    private void visitClassNode(ClassNode cNode) {
        String cName = cNode.getName();
        if (cNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cName + "'. " + MY_TYPE_NAME + " not allowed for interfaces.");
        }
        List<PropertyNode> pList = cNode.getProperties();
        ArrayList<PropertyNode> foundProps = new ArrayList<PropertyNode>();
        ArrayList<String> foundNames = new ArrayList<String>();
        for (PropertyNode pNode : pList) {
            foundProps.add(pNode);
            foundNames.add(pNode.getName());
        }
        for (PropertyNode pNode : foundProps) {
            pList.remove(pNode);
        }
        List<FieldNode> fList = cNode.getFields();
        for (FieldNode fNode : fList) {
            if (!foundNames.contains(fNode.getName())) continue;
            this.revertVisibility(fNode);
        }
    }

    private void visitFieldNode(FieldNode fNode) {
        ClassNode cNode = fNode.getDeclaringClass();
        List<PropertyNode> pList = cNode.getProperties();
        PropertyNode foundProp = null;
        for (PropertyNode pNode : pList) {
            if (!pNode.getName().equals(fNode.getName())) continue;
            foundProp = pNode;
            break;
        }
        if (foundProp != null) {
            this.revertVisibility(fNode);
            pList.remove(foundProp);
        }
    }

    private void revertVisibility(FieldNode fNode) {
        fNode.setModifiers(fNode.getModifiers() & 0xFFFFFFFD);
    }
}

