/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.test.TestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialectTest
extends TestCase {
    private Connection connection;
    private Dialect dialect;
    private static final String INFOBRIGHT_UNSUPPORTED = "The query includes syntax that is not supported by the Infobright Optimizer. Either restructure the query with supported syntax, or enable the MySQL Query Path in the brighthouse.ini file to execute the query with reduced performance.";

    public DialectTest(String name) {
        super(name);
    }

    protected DataSource getDataSource() {
        TestContext.instance().clearConnection();
        return TestContext.instance().getConnection().getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.connection = null;
            }
        }
        super.tearDown();
    }

    protected Dialect getDialect() {
        if (this.dialect == null) {
            this.dialect = DialectManager.createDialect(this.getDataSource(), null);
        }
        return this.dialect;
    }

    protected Connection getConnection() {
        if (this.connection == null) {
            try {
                this.connection = this.getDataSource().getConnection();
            }
            catch (SQLException e) {
                throw Util.newInternal(e, "while creating connection");
            }
        }
        return this.connection;
    }

    public void testAllowsCompoundCountDistinct() {
        String sql = this.dialectize("select count(distinct [customer_id], [product_id])\nfrom [sales_fact_1997]");
        if (this.getDialect().allowsCompoundCountDistinct()) {
            this.assertQuerySucceeds(sql);
        } else {
            String[] errs = new String[]{"(?s)ORA-00909: invalid number of arguments.*", "Syntax error: Encountered \",\" at line 1, column 36.", "\\[Microsoft\\]\\[ODBC Microsoft Access Driver\\] Syntax error \\(missing operator\\) in query expression '.*'.", INFOBRIGHT_UNSUPPORTED, "ERROR: function count\\(integer, integer\\) does not exist", ".*Invalid number of arguments to function 'COUNT'. Was expecting 1 arguments", ".*Syntax error: expected something between the word 'customer_id' and ','\\..*", "(?s).*ERROR:  Function 'COUNT', number of parameters greater than the maximum \\(1\\).*"};
            this.assertQueryFails(sql, errs);
        }
    }

    public void testAllowsCountDistinct() {
        String sql1 = this.dialectize("select count(distinct [customer_id]) from [sales_fact_1997]");
        String sql2 = this.dialectize("select count(distinct [customer_id]),\n sum([time_id])\nfrom [sales_fact_1997]");
        if (this.getDialect().allowsCountDistinct()) {
            this.assertQuerySucceeds(sql1);
            this.assertQuerySucceeds(sql2);
        } else {
            String[] errs = new String[]{"\\[Microsoft\\]\\[ODBC Microsoft Access Driver\\] Syntax error \\(missing operator\\) in query expression '.*'."};
            this.assertQueryFails(sql1, errs);
            this.assertQueryFails(sql2, errs);
        }
    }

    public void testAllowsMultipleCountDistinct() {
        String sql1 = this.dialectize("select count(distinct [customer_id]),\n count(distinct [time_id])\nfrom [sales_fact_1997]");
        String sql3 = this.dialectize("select [unit_sales],\n count(distinct [customer_id]),\n count(distinct [product_id])\nfrom [sales_fact_1997]\nwhere [time_id] in (371, 372)\ngroup by [unit_sales]");
        if (this.getDialect().allowsMultipleCountDistinct()) {
            this.assertQuerySucceeds(sql1);
            this.assertQuerySucceeds(sql3);
            DialectTest.assertTrue((boolean)this.getDialect().allowsCountDistinct());
        } else {
            String[] errs = new String[]{"Multiple DISTINCT aggregates are not supported at this time.", "\\[Microsoft\\]\\[ODBC Microsoft Access Driver\\] Syntax error \\(missing operator\\) in query expression '.*'."};
            this.assertQueryFails(sql1, errs);
            this.assertQueryFails(sql3, errs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAllowsDdl() {
        int phase = 0;
        SQLException e = null;
        Statement stmt = null;
        try {
            String dropSql = this.dialectize("drop table [foo]");
            String createSql = this.dialectize("create table [foo] ([i] integer)");
            stmt = this.getConnection().createStatement();
            try {
                stmt.execute(dropSql);
            }
            catch (SQLException e3) {
                // empty catch block
            }
            phase = 1;
            DialectTest.assertFalse((boolean)stmt.execute(createSql));
            phase = 2;
            DialectTest.assertFalse((boolean)stmt.execute(dropSql));
            phase = 3;
        }
        catch (SQLException e2) {
            e = e2;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e1) {}
            }
        }
        if (this.getDialect().allowsDdl()) {
            DialectTest.assertNull((String)(e == null ? null : e.getMessage()), (Object)e);
            DialectTest.assertEquals((int)3, (int)phase);
        } else {
            DialectTest.assertEquals((int)1, (int)phase);
            DialectTest.assertNotNull((Object)e);
        }
    }

    public void testAllowsFromQuery() {
        String sql = this.dialectize("select * from (select * from [sales_fact_1997]) as [x]");
        if (this.getDialect().allowsFromQuery()) {
            this.assertQuerySucceeds(sql);
        } else {
            this.assertQueryFails(sql, new String[0]);
        }
    }

    public void testRequiresFromQueryAlias() {
        if (this.getDialect().requiresAliasForFromQuery()) {
            DialectTest.assertTrue((boolean)this.getDialect().allowsFromQuery());
        }
        if (!this.getDialect().allowsFromQuery()) {
            return;
        }
        String sql = this.dialectize("select * from (select * from [sales_fact_1997])");
        if (this.getDialect().requiresAliasForFromQuery()) {
            String[] errs = new String[]{"Every derived table must have its own alias", "Syntax error: Encountered \"<EOF>\" at line 1, column 47.", "ERROR: subquery in FROM must have an alias", ".*Syntax error, expected something like a name or a Unicode delimited identifier or an 'UDFCALLNAME' keyword between '\\)' and ';'\\.", "(?s).*ERROR:  sub-SELECT in FROM must have an alias.*"};
            this.assertQueryFails(sql, errs);
        } else {
            this.assertQuerySucceeds(sql);
        }
    }

    public void testRequiresOrderByAlias() {
        String sql = this.dialectize("SELECT [unit_sales]\nFROM [sales_fact_1997]\nORDER BY [unit_sales] + [store_id]");
        if (this.getDialect().requiresOrderByAlias()) {
            String[] errs = new String[]{INFOBRIGHT_UNSUPPORTED};
            this.assertQueryFails(sql, errs);
        } else {
            this.assertQuerySucceeds(sql);
        }
    }

    public void testAllowsOrderByAlias() {
        String sql = this.dialectize("SELECT [unit_sales] as [x],\n [unit_sales] + [store_id] as [y]\nFROM [sales_fact_1997]\nORDER BY [y]");
        if (this.getDialect().allowsOrderByAlias()) {
            this.assertQuerySucceeds(sql);
        } else {
            String[] errs = new String[]{"(?s)ORA-03001: unimplemented feature.*", "\\[Microsoft\\]\\[ODBC Microsoft Access Driver\\] Too few parameters. Expected 1.", INFOBRIGHT_UNSUPPORTED};
            this.assertQueryFails(sql, errs);
        }
    }

    public void testSupportsGroupByExpressions() {
        String sql = this.dialectize("SELECT sum([unit_sales] + 3) + 8\nFROM [sales_fact_1997]\nGROUP BY [unit_sales] + [store_id]");
        if (this.getDialect().supportsGroupByExpressions()) {
            this.assertQuerySucceeds(sql);
        } else {
            this.assertQueryFails(sql, new String[]{"'sum\\(`unit_sales` \\+ 3\\) \\+ 8' isn't in GROUP BY"});
        }
    }

    public void testAllowsGroupingSets() {
        String sql = this.dialectize("SELECT [customer_id],\n SUM([store_sales]),\n GROUPING([unit_sales]),\n GROUPING([customer_id])\nFROM [sales_fact_1997]\nGROUP BY GROUPING SETS(\n ([customer_id], [unit_sales]),\n [customer_id],\n ())");
        if (this.getDialect().supportsGroupingSets()) {
            this.assertQuerySucceeds(sql);
        } else {
            String[] errs = new String[]{"Syntax error: Encountered \"SETS\" at line 6, column 19.", "(?s)You have an error in your SQL syntax; check .*", "(?s)\\[Microsoft\\]\\[ODBC Microsoft Access Driver\\] Syntax error \\(missing operator\\) in query expression 'GROUPING SETS.*", "ERROR: syntax error at or near \"SETS\"", "(?s).*found \"SETS\" \\(at char 135\\) expecting `EXCEPT' or `FOR' or `INTERSECT' or `ORDER' or `UNION'.*"};
            this.assertQueryFails(sql, errs);
        }
    }

    public void testSupportsMultiValueInExpr() {
        String sql = this.dialectize("SELECT [unit_sales]\nFROM [sales_fact_1997]\nWHERE ([unit_sales], [time_id]) IN ((1, 371), (2, 394))");
        if (this.getDialect().supportsMultiValueInExpr()) {
            this.assertQuerySucceeds(sql);
        } else {
            String[] errs = new String[]{"Syntax error: Encountered \",\" at line 3, column 20.", "\\[Microsoft\\]\\[ODBC Microsoft Access Driver\\] Syntax error \\(comma\\) in query expression '.*'.", INFOBRIGHT_UNSUPPORTED, ".*Syntax error, expected something like a 'SELECT' keyword or '\\(' between '\\(' and the integer '1'\\.", "(?s).*found \"1\" \\(at char 81\\) expecting `SELECT' or `'\\(''.*"};
            this.assertQueryFails(sql, errs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testResultSetConcurrency() {
        int[] Types = new int[]{1003, 1004, 1005};
        int[] Concurs = new int[]{1007, 1008};
        String sql = this.dialectize("SELECT [unit_sales] FROM [sales_fact_1997]");
        for (int type : Types) {
            for (int concur : Concurs) {
                boolean b = this.getDialect().supportsResultSetConcurrency(type, concur);
                Statement stmt = null;
                try {
                    stmt = this.getConnection().createStatement(type, concur);
                    ResultSet resultSet = stmt.executeQuery(sql);
                    DialectTest.assertTrue((boolean)resultSet.next());
                    Object col1 = resultSet.getObject(1);
                    Util.discard((Object)col1);
                    if (b) continue;
                    Util.discard((Object)("expected to fail for type=" + type + ", concur=" + concur));
                }
                catch (SQLException e) {
                    if (!b) continue;
                    DialectTest.fail((String)("expected to succeed for type=" + type + ", concur=" + concur));
                    throw Util.newInternal(e, "query [" + sql + "] failed");
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {}
                    }
                }
            }
        }
    }

    public void testGenerateInline() throws SQLException {
        List<String> typeList = Arrays.asList("String", "Numeric");
        List<String> nameList = Arrays.asList("x", "y");
        this.assertInline(nameList, typeList, new String[][]{{"a", "1"}});
        this.assertInline(nameList, typeList, {"a", "1"}, {"bb", "2"});
        List<String> typeList2 = Arrays.asList("String", "Date");
        this.assertInline(nameList, typeList2, {"a", "2008-04-29"}, {"b", "2007-01-02"});
    }

    public void testNullCollation() throws SQLException {
        Dialect dialect = this.getDialect();
        String ascQuery = "select " + dialect.quoteIdentifier("grocery_sqft") + " from " + dialect.quoteIdentifier("store") + " order by " + dialect.quoteIdentifier("grocery_sqft");
        String descQuery = ascQuery + " DESC";
        Dialect.NullCollation nullCollation = this.getDialect().getNullCollation();
        switch (nullCollation) {
            case NEGINF: {
                this.assertFirstLast(ascQuery, null, 30351);
                this.assertFirstLast(descQuery, 30351, null);
                break;
            }
            case POSINF: {
                this.assertFirstLast(ascQuery, 13305, null);
                this.assertFirstLast(descQuery, null, 13305);
                break;
            }
            default: {
                DialectTest.fail((String)("unexpected value " + (Object)((Object)nullCollation)));
            }
        }
    }

    private void assertFirstLast(String query, Integer expectedFirst, Integer expectedLast) throws SQLException {
        ResultSet resultSet = this.getConnection().createStatement().executeQuery(query);
        ArrayList<Integer> values = new ArrayList<Integer>();
        while (resultSet.next()) {
            values.add(resultSet.getInt(1));
            if (!resultSet.wasNull()) continue;
            values.set(values.size() - 1, null);
        }
        resultSet.close();
        Integer actualFirst = (Integer)values.get(0);
        Integer actualLast = (Integer)values.get(values.size() - 1);
        DialectTest.assertEquals((Object)expectedFirst, (Object)actualFirst);
        DialectTest.assertEquals((Object)expectedLast, (Object)actualLast);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInline(List<String> nameList, List<String> typeList, String[] ... valueList) throws SQLException {
        String sql = this.getDialect().generateInline(nameList, typeList, Arrays.asList(valueList));
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            HashSet actualValues = new HashSet();
            while (resultSet.next()) {
                ArrayList<String> row = new ArrayList<String>();
                for (int i = 0; i < typeList.size(); ++i) {
                    String s;
                    String type = typeList.get(i);
                    if (type.equals("String")) {
                        s = resultSet.getString(i + 1);
                    } else if (type.equals("Date")) {
                        s = String.valueOf(resultSet.getDate(i + 1));
                    } else if (type.equals("Numeric")) {
                        s = String.valueOf(resultSet.getInt(i + 1));
                    } else {
                        throw new RuntimeException("unknown type " + type);
                    }
                    row.add(s);
                }
                actualValues.add(row);
            }
            HashSet<List<String>> expectedRows = new HashSet<List<String>>();
            for (String[] strings : valueList) {
                expectedRows.add(Arrays.asList(strings));
            }
            DialectTest.assertEquals(expectedRows, actualValues);
            stmt.close();
            stmt = null;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private String dialectize(String s) {
        Dialect.DatabaseProduct databaseProduct = this.getDialect().getDatabaseProduct();
        switch (databaseProduct) {
            case ACCESS: {
                break;
            }
            case MYSQL: 
            case INFOBRIGHT: {
                s = s.replace('[', '`');
                s = s.replace(']', '`');
                break;
            }
            case ORACLE: {
                s = s.replace('[', '\"');
                s = s.replace(']', '\"');
                s = s.replaceAll(" as ", "");
                break;
            }
            default: {
                s = s.replace('[', '\"');
                s = s.replace(']', '\"');
            }
        }
        return s;
    }

    protected void assertQuerySucceeds(String sql) {
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            DialectTest.assertTrue((boolean)resultSet.next());
            Object col1 = resultSet.getObject(1);
            Util.discard((Object)col1);
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "query [" + sql + "] failed");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    protected void assertQueryFails(String sql, String[] patterns) {
        ResultSet resultSet;
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            try {
                resultSet = stmt.executeQuery(sql);
            }
            catch (SQLException e2) {
                String message = e2.getMessage();
                for (String pattern : patterns) {
                    if (!message.matches(pattern)) continue;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                throw new AssertionFailedError("error [" + message + "] did not match any of the supplied patterns");
            }
            DialectTest.assertTrue((boolean)resultSet.next());
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "failed in wrong place");
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
        Object col1 = resultSet.getObject(1);
        Util.discard((Object)col1);
    }
}

