/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(AccessDialect.class, Dialect.DatabaseProduct.ACCESS);

    public AccessDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public String toUpper(String expr) {
        return "UCASE(" + expr + ")";
    }

    @Override
    public String caseWhenElse(String cond, String thenExpr, String elseExpr) {
        return "IIF(" + cond + "," + thenExpr + "," + elseExpr + ")";
    }

    @Override
    protected void quoteDateLiteral(StringBuilder buf, String value, Date date) {
        buf.append("#");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        buf.append(calendar.get(2) + 1);
        buf.append("/");
        buf.append(calendar.get(5));
        buf.append("/");
        buf.append(calendar.get(1));
        buf.append("#");
    }

    @Override
    public boolean allowsCountDistinct() {
        return false;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, " from `days` where `day` = 1", false);
    }
}

