/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import junit.framework.TestCase;
import mondrian.olap.fun.VisualTotalsFunDef;

public class VisualTotalsTest
extends TestCase {
    public void testSubstituteEmpty() {
        String actual = VisualTotalsFunDef.substitute("", "anything");
        String expected = "";
        VisualTotalsTest.assertEquals((String)"", (String)actual);
    }

    public void testSubstituteOneStarOnly() {
        String actual = VisualTotalsFunDef.substitute("*", "anything");
        String expected = "anything";
        VisualTotalsTest.assertEquals((String)"anything", (String)actual);
    }

    public void testSubstituteOneStarBegin() {
        String actual = VisualTotalsFunDef.substitute("* is the word.", "Grease");
        String expected = "Grease is the word.";
        VisualTotalsTest.assertEquals((String)"Grease is the word.", (String)actual);
    }

    public void testSubstituteOneStarEnd() {
        String actual = VisualTotalsFunDef.substitute("Lies, damned lies, and *!", "statistics");
        String expected = "Lies, damned lies, and statistics!";
        VisualTotalsTest.assertEquals((String)"Lies, damned lies, and statistics!", (String)actual);
    }

    public void testSubstituteTwoStars() {
        String actual = VisualTotalsFunDef.substitute("**", "anything");
        String expected = "*";
        VisualTotalsTest.assertEquals((String)"*", (String)actual);
    }

    public void testSubstituteCombined() {
        String actual = VisualTotalsFunDef.substitute("*: see small print**** for *", "disclaimer");
        String expected = "disclaimer: see small print** for disclaimer";
        VisualTotalsTest.assertEquals((String)"disclaimer: see small print** for disclaimer", (String)actual);
    }
}

