/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.wizards;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriterHelper;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryJrxmlFile;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardPanel1;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardPanel2;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardPanel3;
import com.jaspersoft.ireport.jasperserver.validation.JrxmlValidationDialog;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;

public class ReportUnitWizardDescriptor
extends WizardDescriptor {
    private JServer server = null;
    private String parentFolder = null;
    private ResourceDescriptor newResourceDescriptor = null;
    private WizardDescriptor.Panel[] panels;
    private List datasources = new ArrayList();

    public ReportUnitWizardDescriptor() {
        this.setTitleFormat(new MessageFormat("{0}"));
        this.setTitle("ReportUnit Wizard");
    }

    public boolean runWizard() {
        boolean cancelled;
        this.setPanelsAndSettings((WizardDescriptor.Iterator)new WizardDescriptor.ArrayIterator(this.getPanels()), (Object)this);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = this.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            return this.createTheReportUnit();
        }
        return false;
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
    }

    public void setDatasources(List datasources) {
        this.datasources = datasources;
    }

    public ResourceDescriptor getNewResourceDescriptor() {
        return this.newResourceDescriptor;
    }

    public void setNewResourceDescriptor(ResourceDescriptor newResourceDescriptor) {
        this.newResourceDescriptor = newResourceDescriptor;
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new ReportUnitWizardPanel1(this), new ReportUnitWizardPanel2(this), new ReportUnitWizardPanel3(this)};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public List getDatasources() {
        return this.datasources;
    }

    public boolean createTheReportUnit() {
        File resourceFile = null;
        ResourceDescriptor rd = new ResourceDescriptor();
        Iterator namesProps = this.getProperties().keySet().iterator();
        while (namesProps.hasNext()) {
            String name = "" + namesProps.next();
            System.out.println(name + " " + this.getProperty(name));
            System.out.flush();
        }
        try {
            rd.setWsType("reportUnit");
            rd.setDescription(((String)this.getProperty("description")).trim());
            rd.setName((String)this.getProperty("name"));
            String uri = this.getParentFolder();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + this.getProperty("name");
            rd.setUriString(uri);
            rd.setLabel(((String)this.getProperty("label")).trim());
            rd.setParentFolder(this.getParentFolder());
            rd.setIsNew(true);
            rd.setResourceProperty("PROP_RU_ALWAYS_PROPMT_CONTROLS", true);
            if (JasperServerManager.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                ResourceDescriptor tmpDataSourceDescriptor = null;
                if (this.getProperty("datasource_present") != null && this.getProperty("datasource_present").equals("true")) {
                    if (((String)this.getProperty("datasource_is_local")).equals("false")) {
                        tmpDataSourceDescriptor = new ResourceDescriptor();
                        tmpDataSourceDescriptor.setWsType("datasource");
                        tmpDataSourceDescriptor.setReferenceUri((String)this.getProperty("datasource_uri"));
                        tmpDataSourceDescriptor.setIsReference(true);
                    } else {
                        tmpDataSourceDescriptor = (ResourceDescriptor)this.getProperty("datasource_descriptor");
                        tmpDataSourceDescriptor.setIsReference(false);
                    }
                    rd.getChildren().add(tmpDataSourceDescriptor);
                }
            }
            ResourceDescriptor jrxmlDescriptor = new ResourceDescriptor();
            jrxmlDescriptor.setWsType("jrxml");
            if (((String)this.getProperty("jrxml_is_local")).equals("false")) {
                jrxmlDescriptor.setIsNew(true);
                jrxmlDescriptor.setMainReport(true);
                jrxmlDescriptor.setIsReference(true);
                jrxmlDescriptor.setReferenceUri((String)this.getProperty("jrxml_file"));
            } else {
                jrxmlDescriptor.setName(this.getProperty("name") + "_jrxml");
                jrxmlDescriptor.setLabel("Main jrxml");
                jrxmlDescriptor.setDescription("Main jrxml");
                jrxmlDescriptor.setIsNew(true);
                jrxmlDescriptor.setHasData(true);
                jrxmlDescriptor.setMainReport(true);
                resourceFile = new File((String)this.getProperty("jrxml_file"));
            }
            rd.getChildren().add(jrxmlDescriptor);
            System.out.println("Resource descriptor uri: " + rd.getUriString());
            System.out.flush();
            this.newResourceDescriptor = this.getServer().getWSClient().addOrModifyResource(rd, resourceFile);
            System.out.println("resourceFile = " + resourceFile);
            System.out.flush();
            JasperServerManager.getJrxmlNotifier().resourceWillBeUpdated(null, null, resourceFile);
            if (resourceFile != null) {
                this.addRequiredResources(resourceFile, this.newResourceDescriptor);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{ex.getMessage()}));
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private void addRequiredResources(File resourceFile, ResourceDescriptor rd) throws Exception {
        ReportUnitWizardDescriptor.addRequiredResources(this.getServer(), resourceFile, rd);
    }

    public static void addRequiredResources(JServer server, File resourceFile, ResourceDescriptor reportUnitDescriptor) throws Exception {
        ReportUnitWizardDescriptor.addRequiredResources(server, resourceFile, null, reportUnitDescriptor, null);
    }

    public static void addRequiredResources(JServer server, File resourceFile, JasperDesign report, ResourceDescriptor reportUnitDescriptor, ResourceDescriptor jrxmlDescriptor) throws Exception {
        List children;
        boolean useTemporaryFile = false;
        Thread.currentThread().setContextClassLoader(IReportManager.getReportClassLoader());
        if (report == null) {
            report = JRXmlLoader.load((File)resourceFile);
        }
        if ((children = RepositoryJrxmlFile.identifyElementValidationItems(report, reportUnitDescriptor, resourceFile.getParent())).size() > 0) {
            JrxmlVisualView view = null;
            if (useTemporaryFile) {
                String tmpFileName = JasperServerManager.createTmpFileName("newfile", ".jrxml");
                JRXmlWriter.writeReport((JRReport)report, (OutputStream)new FileOutputStream(tmpFileName), (String)"UTF-8");
                resourceFile = new File(tmpFileName);
            } else {
                view = Misc.getViewForFile((File)resourceFile);
            }
            long modified = resourceFile.lastModified();
            if (reportUnitDescriptor != null) {
                report.setProperty("ireport.jasperserver.reportUnit", reportUnitDescriptor.getUriString());
            }
            report.setProperty("ireport.jasperserver.url", server.getUrl());
            JrxmlValidationDialog jvd = new JrxmlValidationDialog(Misc.getMainFrame(), true);
            jvd.setElementVelidationItems(children);
            jvd.setServer(server);
            jvd.setVisualView(view);
            jvd.setFileName(resourceFile.getPath());
            jvd.setReportUnit(new RepositoryReportUnit(server, reportUnitDescriptor));
            jvd.setReport(report);
            jvd.setVisible(true);
            if (view != null) {
                view.getEditorSupport().saveDocument();
            } else {
                ReportUnitWizardDescriptor.writeReport(report, resourceFile);
            }
            jvd.getDialogResult();
            if (modified != resourceFile.lastModified()) {
                for (int i = 0; i < reportUnitDescriptor.getChildren().size(); ++i) {
                    ResourceDescriptor rdJrxml = (ResourceDescriptor)reportUnitDescriptor.getChildren().get(i);
                    if (jrxmlDescriptor == null || !rdJrxml.getUriString().equals(jrxmlDescriptor.getUriString())) {
                        if (jrxmlDescriptor != null) continue;
                        if (!rdJrxml.getWsType().equals("jrxml") || !rdJrxml.isMainReport()) continue;
                    }
                    rdJrxml.setIsNew(false);
                    rdJrxml.setHasData(true);
                    rdJrxml = server.getWSClient().modifyReportUnitResource(reportUnitDescriptor.getUriString(), rdJrxml, resourceFile);
                    reportUnitDescriptor.getChildren().set(i, rdJrxml);
                    break;
                }
            } else {
                System.out.println("Not modified...." + modified + " != " + resourceFile.lastModified());
                System.out.flush();
            }
        }
    }

    public static void writeReport(JasperDesign jd, File outputFile) throws Exception {
        String compatibility = IReportManager.getPreferences().get("compatibility", "");
        String content = "";
        content = compatibility.length() == 0 ? JRXmlWriter.writeReport((JRReport)jd, (String)"UTF-8") : JRXmlWriterHelper.writeReport((JRReport)jd, (String)"UTF-8", (String)compatibility);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
        out.write(content);
        ((Writer)out).close();
    }
}

