/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryBundleFile;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryJrtxFile;
import com.jaspersoft.ireport.jasperserver.RepositoryJrxmlFile;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openide.util.Mutex;

public class RepositoryFolder {
    private ResourceDescriptor descriptor;
    private JServer server = null;
    private boolean root = false;
    private List children = null;
    private boolean loaded = false;

    public RepositoryFolder(JServer server, ResourceDescriptor descriptor, boolean root) {
        this.descriptor = descriptor;
        this.server = server;
        this.root = root;
    }

    public RepositoryFolder(JServer server, ResourceDescriptor descriptor) {
        this(server, descriptor, false);
    }

    public String toString() {
        if (this.getDescriptor() != null) {
            return "" + this.getDescriptor().getLabel();
        }
        return "???";
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public ResourceDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ResourceDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public List getChildren() {
        return this.getChildren(false);
    }

    public List getChildren(boolean refresh) {
        if (this.children == null || refresh || !this.isLoaded()) {
            this.children = null;
        }
        if (this.children == null) {
            try {
                List descriptors = this.getServer().getWSClient().list(this.getDescriptor());
                this.children = this.parseDescriptors(descriptors);
                this.loaded = true;
            }
            catch (Exception ex) {
                final String msg = ex.getMessage();
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{msg}));
                    }
                });
                ex.printStackTrace();
            }
        }
        return this.children;
    }

    public List parseDescriptors(List descriptors) {
        ArrayList<RepositoryFolder> list = new ArrayList<RepositoryFolder>();
        if (descriptors != null) {
            for (int i = 0; i < descriptors.size(); ++i) {
                ResourceDescriptor rd = (ResourceDescriptor)descriptors.get(i);
                list.add(RepositoryFolder.createRepositoryObject(this.getServer(), rd));
            }
        }
        return list;
    }

    public static RepositoryFolder createRepositoryObject(JServer srv, ResourceDescriptor rd) {
        RepositoryFolder rf = null;
        if (rd.getWsType() == null) {
            rd.setWsType("unknow");
        }
        rf = rd.getWsType().equals("reportUnit") ? new RepositoryReportUnit(srv, rd) : (rd.getWsType().equals("folder") ? new RepositoryFolder(srv, rd) : (rd.getWsType().equals("jrxml") ? new RepositoryJrxmlFile(srv, rd) : (rd.getWsType().equals("jrtx") ? new RepositoryJrtxFile(srv, rd) : (rd.getWsType().equals("prop") ? new RepositoryBundleFile(srv, rd) : new RepositoryFile(srv, rd)))));
        return rf;
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    public boolean isDataSource() {
        return RepositoryFolder.isDataSource(this.getDescriptor());
    }

    public static boolean isDataSource(ResourceDescriptor rd) {
        block6: {
            block5: {
                if (rd == null) {
                    return false;
                }
                if (rd.getWsType() == null) {
                    return false;
                }
                if (rd.getWsType().equals("datasource")) break block5;
                if (rd.getWsType().equals("jdbc")) break block5;
                if (rd.getWsType().equals("jndi")) break block5;
                if (!rd.getWsType().equals("bean") && !rd.getWsType().equals("Domain")) break block6;
            }
            return true;
        }
        return false;
    }
}

