/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.AddTableColumnDialog;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class AddColumnAction
extends DatabaseAction {
    static final long serialVersionUID = 5894518352294344657L;

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        Node node = nodeArray[0];
        DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        final TableNodeInfo tableNodeInfo = (TableNodeInfo)databaseNodeInfo.getParent(this.nodename);
        try {
            AddTableColumnDialog addTableColumnDialog = new AddTableColumnDialog((Specification)tableNodeInfo.getSpecification(), tableNodeInfo);
            if (addTableColumnDialog.run()) {
                tableNodeInfo.addColumn(addTableColumnDialog.getColumnName());
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            tableNodeInfo.refreshChildren();
                        }
                        catch (DatabaseException databaseException) {
                            Logger.getLogger("global").log(Level.INFO, null, databaseException);
                            DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToAddColumn"), databaseException.getMessage());
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
            DbUtilities.reportError(AddColumnAction.bundle().getString("ERR_UnableToAddColumn"), exception.getMessage());
        }
    }
}

