/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.AxisOrdinal;
import mondrian.olap.Connection;
import mondrian.olap.Hierarchy;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.test.FoodMartTestCase;

public class HierarchyBugTest
extends FoodMartTestCase {
    public HierarchyBugTest(String name) {
        super(name);
    }

    public HierarchyBugTest() {
    }

    public void testNoHierarchy() {
        String queryString = "select NON EMPTY Crossjoin(Hierarchize(Union({[Time].LastSibling}, [Time].LastSibling.Children)), {[Measures].[Unit Sales],      [Measures].[Store Cost]}) ON columns, NON EMPTY Hierarchize(Union({[Store].[All Stores]}, [Store].[All Stores].Children)) ON rows from [Sales]";
        Connection conn = this.getConnection();
        Query query = conn.parseQuery(queryString);
        Result result = conn.execute(query);
        String failStr = null;
        int len = query.axes.length;
        for (int i = 0; i < len; ++i) {
            Hierarchy[] hs = query.getMdxHierarchiesOnAxis(AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(i));
            if (hs == null) continue;
            for (Hierarchy h : hs) {
                if (h != null) continue;
                failStr = "Got a null Hierarchy, Should be Time Hierarchy";
            }
        }
        if (failStr != null) {
            HierarchyBugTest.fail(failStr);
        }
    }
}

