/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.io.File;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class OpenFile {
    private OpenFile() {
    }

    public static String open(FileObject fileObject, int n) {
        for (OpenFileImpl openFileImpl : Lookup.getDefault().lookupAll(OpenFileImpl.class)) {
            if (!openFileImpl.open(fileObject, n)) continue;
            return null;
        }
        return NbBundle.getMessage(OpenFile.class, (String)"MSG_FileIsNotPlainFile", (Object)fileObject);
    }

    static String openFile(File file, int n) {
        String string = OpenFile.checkFileExists(file);
        if (string != null) {
            return string;
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject != null) {
            return OpenFile.open(fileObject, n);
        }
        return NbBundle.getMessage(OpenFile.class, (String)"MSG_FileDoesNotExist", (Object)file);
    }

    private static String checkFileExists(File file) {
        if (!file.exists() || !file.isFile() && !file.isDirectory()) {
            return NbBundle.getMessage(OpenFile.class, (String)"MSG_fileNotFound", (Object)file.toString());
        }
        return null;
    }
}

