/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.CrosstabParameterNode;
import com.jaspersoft.ireport.designer.outline.nodes.CrosstabParametersNode;
import com.jaspersoft.ireport.designer.outline.nodes.SortableParametersNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public class CrosstabParametersChildren
extends Index.KeysChildren
implements PropertyChangeListener,
PreferenceChangeListener {
    JasperDesign jd = null;
    private JRDesignCrosstab crosstab = null;
    private Lookup doLkp = null;

    public CrosstabParametersChildren(JasperDesign jd, JRDesignCrosstab crosstab, Lookup doLkp) {
        super(new ArrayList());
        this.jd = jd;
        this.doLkp = doLkp;
        this.crosstab = crosstab;
        this.crosstab.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        IReportManager.getPreferences().addPreferenceChangeListener(this);
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals("filter_parameters")) {
            this.recalculateKeys();
        }
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{new CrosstabParameterNode(this.jd, this.crosstab, (JRDesignCrosstabParameter)key, this.doLkp)};
    }

    protected void addNotify() {
        super.addNotify();
        this.recalculateKeys();
    }

    public void recalculateKeys() {
        List l = (List)this.lock();
        l.clear();
        if (IReportManager.getPreferences().getBoolean("filter_parameters", false)) {
            List paramsAll = this.crosstab.getParametersList();
            for (int i = 0; i < paramsAll.size(); ++i) {
                JRCrosstabParameter p = (JRCrosstabParameter)paramsAll.get(i);
                if (p.isSystemDefined()) continue;
                l.add(p);
            }
        } else {
            l.addAll(this.crosstab.getParametersList());
        }
        if (this.getNode() != null && this.getNode() instanceof CrosstabParametersNode && ((SortableParametersNode)this.getNode()).isSort()) {
            Object[] parameters = l.toArray();
            Arrays.sort(parameters, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((JRDesignCrosstabParameter)o1).getName().compareToIgnoreCase(((JRDesignCrosstabParameter)o2).getName());
                }
            });
            l.clear();
            l.addAll(Arrays.asList(parameters));
        }
        this.update();
    }

    protected void forceReorder(int[] ints) {
        super.reorder(ints);
        this.update();
    }

    public void reorder() {
        Mutex.Action action = new Mutex.Action(){

            public Object run() {
                Index.Support.showIndexedCustomizer((Index)CrosstabParametersChildren.this.getIndex());
                return null;
            }
        };
        MUTEX.writeAccess(action);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("parameters")) {
            this.recalculateKeys();
        }
    }
}

