/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import net.sf.jasperreports.engine.design.JRDesignSortField;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;

public class SortFieldCellRenderer
extends DefaultListCellRenderer {
    static ImageIcon ascIcon;
    static ImageIcon descIcon;

    public SortFieldCellRenderer() {
        if (ascIcon == null) {
            ascIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/arrow_up.png"));
        }
        if (descIcon == null) {
            descIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/data/arrow_down.png"));
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component retValue = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof JRDesignSortField && retValue instanceof JLabel) {
            JRDesignSortField sf = (JRDesignSortField)value;
            JLabel label = (JLabel)retValue;
            String t = sf.getType() == SortFieldTypeEnum.FIELD ? "Field" : "Variable";
            Color cf = Color.green.darker().darker();
            Color cv = Color.BLUE;
            String c = sf.getType() == SortFieldTypeEnum.FIELD ? SortFieldCellRenderer.getEncodedColor(cf) : SortFieldCellRenderer.getEncodedColor(cv);
            String text = "<html>" + sf.getName() + " " + (isSelected ? t : "<font color=\"" + c + "\">" + t + "</font>");
            label.setText(text);
            label.setIcon(sf.getOrder() == 1 ? descIcon : ascIcon);
        }
        return retValue;
    }

    public static String getEncodedColor(Color c) {
        String nums = "0123456789ABCDEF";
        String s = "#";
        s = s + nums.charAt(c.getRed() / 16);
        s = s + nums.charAt(c.getRed() % 16);
        s = s + nums.charAt(c.getGreen() / 16);
        s = s + nums.charAt(c.getGreen() % 16);
        s = s + nums.charAt(c.getBlue() / 16);
        s = s + nums.charAt(c.getBlue() % 16);
        return s;
    }
}

