/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.gui.XlsDataSourceConnectionEditor;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.File;
import java.sql.Connection;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.data.JRXlsDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRXlsDataSourceConnection
extends IReportConnection
implements WizardFieldsProvider {
    private String name;
    private boolean useFirstRowAsHeader = false;
    private String customDateFormat = null;
    private String customNumberFormat = null;
    private String filename;
    private List<String> columnNames = new ArrayList<String>();
    private List<Integer> columnIndexes = new ArrayList<Integer>();

    @Override
    public Connection getConnection() {
        return null;
    }

    @Override
    public boolean isJDBCConnection() {
        return false;
    }

    @Override
    public HashMap getProperties() {
        int i;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Filename", Misc.nvl(this.getFilename(), ""));
        map.put("useFirstRowAsHeader", Misc.nvl("" + this.isUseFirstRowAsHeader(), ""));
        map.put("customDateFormat", Misc.nvl(this.getCustomDateFormat(), ""));
        map.put("customNumberFormat", Misc.nvl(this.getCustomNumberFormat(), ""));
        for (i = 0; i < this.getColumnNames().size(); ++i) {
            map.put("COLUMN_" + i, this.getColumnNames().get(i));
        }
        for (i = 0; i < this.getColumnIndexes().size(); ++i) {
            map.put("INDEX_" + i, this.getColumnIndexes().get(i) + "");
        }
        return map;
    }

    @Override
    public void loadProperties(HashMap map) {
        this.setFilename((String)map.get("Filename"));
        this.setUseFirstRowAsHeader(((String)map.get("useFirstRowAsHeader")).equals("true"));
        this.setCustomDateFormat((String)map.get("customDateFormat"));
        this.setCustomNumberFormat((String)map.get("customNumberFormat"));
        int i = 0;
        while (map.containsKey("COLUMN_" + i)) {
            this.getColumnNames().add((String)map.get("COLUMN_" + i));
            ++i;
        }
        i = 0;
        while (map.containsKey("INDEX_" + i)) {
            this.getColumnIndexes().add(new Integer(map.get("INDEX_" + i) + ""));
            ++i;
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public JRDataSource getJRDataSource() {
        try {
            JRXlsDataSource ds = new JRXlsDataSource(new File(this.getFilename()));
            if (this.getCustomDateFormat() != null && this.getCustomDateFormat().length() > 0) {
                ds.setDateFormat((DateFormat)new SimpleDateFormat(this.getCustomDateFormat()));
            }
            if (this.getCustomNumberFormat() != null && this.getCustomNumberFormat().length() > 0) {
                ds.setNumberFormat((NumberFormat)new DecimalFormat(this.getCustomNumberFormat()));
            }
            ds.setUseFirstRowAsHeader(this.isUseFirstRowAsHeader());
            if (!this.isUseFirstRowAsHeader()) {
                String[] names = new String[this.getColumnNames().size()];
                int[] indexes = new int[this.getColumnNames().size()];
                for (int i = 0; i < names.length; ++i) {
                    names[i] = "" + this.getColumnNames().get(i);
                    indexes[i] = this.getColumnIndexes().size() > i ? this.getColumnIndexes().get(i) : i;
                }
                ds.setColumnNames(names, indexes);
            }
            return ds;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return super.getJRDataSource();
        }
    }

    public boolean isUseFirstRowAsHeader() {
        return this.useFirstRowAsHeader;
    }

    public void setUseFirstRowAsHeader(boolean useFirstRowAsHeader) {
        this.useFirstRowAsHeader = useFirstRowAsHeader;
    }

    public String getCustomDateFormat() {
        return this.customDateFormat;
    }

    public void setCustomDateFormat(String customDateFormat) {
        this.customDateFormat = customDateFormat;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
    }

    @Override
    public String getDescription() {
        return I18n.getString("connectionType.xls");
    }

    @Override
    public IReportConnectionEditor getIReportConnectionEditor() {
        return new XlsDataSourceConnectionEditor();
    }

    @Override
    public void test() throws Exception {
        String csv_file = this.getFilename();
        try {
            JRXlsDataSourceConnection con = new JRXlsDataSourceConnection();
            File f = new File(csv_file);
            if (!f.exists()) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("File {0} not found", new Object[]{csv_file}), "Error", 0);
                return;
            }
            con.setFilename(csv_file);
            if (con.getJRDataSource() != null) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
                return;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), ex.getMessage(), "Error", 0);
            ex.printStackTrace();
            return;
        }
    }

    public String getCustomNumberFormat() {
        return this.customNumberFormat;
    }

    public void setCustomNumberFormat(String customNumberFormat) {
        this.customNumberFormat = customNumberFormat;
    }

    public List<Integer> getColumnIndexes() {
        return this.columnIndexes;
    }

    public void setColumnIndexes(List<Integer> columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    @Override
    public String getQueryLanguage() {
        return null;
    }

    @Override
    public List<JRDesignField> readFields(String query) throws Exception {
        ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>();
        List<String> names = this.getColumnNames();
        for (int nd = 0; nd < names.size(); ++nd) {
            String fieldName = "" + names.get(nd);
            JRDesignField field = new JRDesignField();
            field.setName(fieldName);
            field.setValueClassName("java.lang.String");
            fields.add(field);
        }
        return fields;
    }

    @Override
    public boolean supportsDesign() {
        return false;
    }

    @Override
    public String designQuery(String query) {
        return query;
    }
}

