/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder.syntax;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ListIterator;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.syntax.QueryExpression;
import nickyb.sqleonardo.querybuilder.syntax.QuerySpecification;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;
import nickyb.sqleonardo.querybuilder.syntax.SubQuery;

public class SQLParser {
    public static QueryModel toQueryModel(String sql) throws IOException {
        return SQLParser.toQueryModel(new StringReader(sql));
    }

    private static QueryModel toQueryModel(Reader r) throws IOException {
        QueryModel qm = new QueryModel();
        ArrayList al = SQLParser.doTokenize(r);
        SQLParser.doAdjustSequence(al);
        ListIterator li = al.listIterator();
        SQLParser.doParseQuery(li, qm.getQueryExpression());
        if (li.hasNext() && li.next().toString().toUpperCase().equalsIgnoreCase("ORDER BY")) {
            SQLParser.doParseOrderBy(li, qm);
        }
        return qm;
    }

    private static void doParseQuery(ListIterator li, QueryExpression qe) throws IOException {
        while (li.hasNext()) {
            int i;
            QueryTokens.Condition[] tokens;
            Object next = li.next();
            if (next.toString().equalsIgnoreCase("SELECT")) {
                SQLParser.doParseSelect(li, qe.getQuerySpecification());
                continue;
            }
            if (next.toString().equalsIgnoreCase("FROM")) {
                SQLParser.doParseFrom(li, qe.getQuerySpecification());
                SQLParser.doConvertColumns(qe.getQuerySpecification());
                continue;
            }
            if (next.toString().equalsIgnoreCase("WHERE")) {
                tokens = SQLParser.doParseConditions(li);
                for (i = 0; i < tokens.length; ++i) {
                    qe.getQuerySpecification().addWhereClause(tokens[i]);
                }
                continue;
            }
            if (next.toString().equalsIgnoreCase("GROUP BY")) {
                SQLParser.doParseGroupBy(li, qe.getQuerySpecification());
                continue;
            }
            if (next.toString().equalsIgnoreCase("HAVING")) {
                tokens = SQLParser.doParseConditions(li);
                for (i = 0; i < tokens.length; ++i) {
                    qe.getQuerySpecification().addHavingClause(tokens[i]);
                }
                continue;
            }
            if (next.toString().equalsIgnoreCase("UNION")) {
                QueryExpression union = new QueryExpression();
                SQLParser.doParseQuery(li, union);
                qe.setUnion(union);
                continue;
            }
            if (next.toString().equalsIgnoreCase("ORDER BY")) {
                li.previous();
                break;
            }
            if (!next.toString().equals(")")) continue;
            break;
        }
    }

    private static void doParseSelect(ListIterator li, QuerySpecification qs) throws IOException {
        int surrounds = 0;
        String alias = null;
        String value = new String();
        while (li.hasNext()) {
            char last;
            Object next = li.next();
            if (next.toString().equalsIgnoreCase("DISTINCT")) {
                qs.setQuantifier((short)2);
                continue;
            }
            if (next.toString().equals(",") && surrounds == 0) {
                qs.addSelectList(new QueryTokens.DefaultExpression(value.trim(), alias));
                value = new String();
                continue;
            }
            if (SQLParser.isClauseWord(next.toString())) {
                li.previous();
                if (next.toString().equalsIgnoreCase("SELECT")) {
                    SubQuery sub = new SubQuery();
                    SQLParser.doParseQuery(li, sub);
                    qs.addSelectList(sub);
                    value = new String();
                    continue;
                }
                if (value.trim().equals("")) break;
                qs.addSelectList(new QueryTokens.DefaultExpression(value.trim(), alias));
                break;
            }
            if (next.toString().equalsIgnoreCase("AS") && li.hasNext()) {
                alias = li.next().toString().trim();
                continue;
            }
            if (next.toString().equals("(")) {
                ++surrounds;
            }
            if (next.toString().equals(")")) {
                --surrounds;
            }
            if (value.length() > 0 && next instanceof String && (Character.isLetter(last = value.charAt(value.length() - 1)) || String.valueOf(last).equals(QueryBuilder.identifierQuoteString))) {
                value = value + ' ';
            }
            if (!(value = value + next.toString().trim()).endsWith(",") || surrounds != 0) continue;
            qs.addSelectList(new QueryTokens.DefaultExpression(value.substring(0, value.length() - 1)));
            value = new String();
        }
    }

    private static void doParseFrom(ListIterator li, QuerySpecification qs) {
        int joinType = -1;
        QueryTokens.AbstractDatabaseObject t = null;
        Hashtable<String, QueryTokens.AbstractDatabaseObject> tables = new Hashtable<String, QueryTokens.AbstractDatabaseObject>();
        int surrounds = 0;
        while (li.hasNext()) {
            String next = li.next().toString();
            if (SQLParser.isClauseWord(next) || next.equals(";")) {
                if (t != null) {
                    qs.addFromClause((QueryTokens._TableReference)((Object)t));
                }
                li.previous();
                break;
            }
            if (next.equals(",")) {
                if (t != null) {
                    qs.addFromClause((QueryTokens._TableReference)((Object)t));
                }
                t = null;
                continue;
            }
            if (SQLParser.isJoinWord(next)) {
                if (t != null) {
                    tables.put(SQLFormatter.stripQuote(t.getReference()), t);
                }
                t = null;
                joinType = QueryTokens.Join.getTypeInt(next);
                continue;
            }
            if (next.toString().equalsIgnoreCase("ON") || next.toString().equalsIgnoreCase("AND") || next.toString().equalsIgnoreCase("OR")) {
                QueryTokens._TableReference[] ref;
                if (t != null) {
                    tables.put(SQLFormatter.stripQuote(t.getReference()), t);
                }
                t = null;
                if (joinType == -1 && (ref = qs.getFromClause()).length > 0 && ref[ref.length - 1] instanceof QueryTokens.Join) {
                    joinType = ((QueryTokens.Join)ref[ref.length - 1]).getType();
                }
                String left = li.next().toString();
                while (left.equals("(")) {
                    ++surrounds;
                    left = li.next().toString();
                }
                String op = li.next().toString();
                String right = li.next().toString();
                QueryTokens.Column tcl = null;
                QueryTokens.Column tcr = null;
                for (int side = 0; side < 2; ++side) {
                    String e = side == 0 ? left : right;
                    e = SQLFormatter.stripQuote(e);
                    int dot = e.lastIndexOf(46);
                    String ref2 = dot == -1 ? new String() : e.substring(0, dot);
                    QueryTokens.Table tr = new QueryTokens.Table(null, ref2);
                    if (tables.containsKey(ref2)) {
                        tr = (QueryTokens.Table)tables.get(ref2);
                    } else {
                        tables.put(SQLFormatter.stripQuote(tr.getReference()), tr);
                    }
                    if (side == 0) {
                        tcl = new QueryTokens.Column(tr, e.substring(dot + 1));
                        continue;
                    }
                    tcr = new QueryTokens.Column(tr, e.substring(dot + 1));
                }
                qs.addFromClause(new QueryTokens.Join(joinType, tcl, op, tcr));
                joinType = -1;
                continue;
            }
            if (next.toString().equals("(")) {
                ++surrounds;
                continue;
            }
            if (next.toString().equals(")")) {
                if (t != null) {
                    qs.addFromClause((QueryTokens._TableReference)((Object)t));
                }
                t = null;
                if (--surrounds >= 0) continue;
                li.previous();
                break;
            }
            if (next.toString().equalsIgnoreCase("AS")) continue;
            String schema = null;
            String name = SQLFormatter.stripQuote(next.toString());
            int i = name.lastIndexOf(46);
            if (i > 0) {
                schema = name.substring(0, i);
                name = name.substring(i + 1);
            }
            if (t == null) {
                t = new QueryTokens.Table(schema, name);
                continue;
            }
            t.setAlias(next.toString());
        }
    }

    private static void doParseGroupBy(ListIterator li, QuerySpecification qs) {
        while (li.hasNext()) {
            Object next = li.next();
            if (SQLParser.isReservedWord(next.toString()) || next.toString().equals(";")) {
                li.previous();
                break;
            }
            if (!(next instanceof String)) continue;
            qs.addGroupByClause(new QueryTokens.Group(next.toString()));
        }
    }

    private static void doParseOrderBy(ListIterator li, QueryModel qm) {
        QueryTokens.Sort token = null;
        while (li.hasNext()) {
            Object next = li.next();
            if (next.toString().equals(",") || next.toString().equals(";")) {
                qm.addOrderByClause(token);
                token = null;
                continue;
            }
            if (token == null) {
                token = new QueryTokens.Sort(new QueryTokens.DefaultExpression(next.toString()));
                continue;
            }
            if (next.toString().equalsIgnoreCase("ASC")) {
                token.setType((short)0);
                continue;
            }
            if (!next.toString().equalsIgnoreCase("DESC")) continue;
            token.setType((short)1);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static QueryTokens.Condition[] doParseConditions(ListIterator li) throws IOException {
        boolean between = false;
        ArrayList<QueryTokens.Condition> tokens = new ArrayList<QueryTokens.Condition>();
        QueryTokens.Condition token = null;
        Object var4_4 = null;
        int surrounds = 0;
        do {
            char last;
            String value;
            void var4_5;
            if (!li.hasNext()) return tokens.toArray(new QueryTokens.Condition[tokens.size()]);
            Object next = li.next();
            if (next.toString().equals("(")) {
                ++surrounds;
            }
            if (next.toString().equals(")")) {
                --surrounds;
            }
            if (next.toString().equalsIgnoreCase("EXISTS") || next.toString().equalsIgnoreCase("NOT EXISTS")) {
                SubQuery sub = new SubQuery();
                SQLParser.doParseQuery(li, sub);
                token.setLeft(null);
                token.setOperator(next.toString());
                token.setRight(sub);
                tokens.add(token);
                token = null;
                Object var4_6 = null;
                continue;
            }
            if (SQLParser.isClauseWord(next.toString())) {
                li.previous();
                if (!next.toString().equalsIgnoreCase("SELECT")) {
                    if (token == null) return tokens.toArray(new QueryTokens.Condition[tokens.size()]);
                    token.setRight((QueryTokens._Expression)var4_5);
                    tokens.add(token);
                    return tokens.toArray(new QueryTokens.Condition[tokens.size()]);
                }
                SubQuery subQuery = new SubQuery();
                SQLParser.doParseQuery(li, subQuery);
                continue;
            }
            if (SQLParser.isOperator(next.toString())) {
                if (token == null) {
                    token = new QueryTokens.Condition();
                }
                token.setLeft((QueryTokens._Expression)var4_5);
                token.setOperator(next.toString().toUpperCase());
                between = token.getOperator().indexOf("BETWEEN") != -1;
                Object var4_8 = null;
                continue;
            }
            if (next.toString().equalsIgnoreCase("AND") && !between || next.toString().equalsIgnoreCase("OR") || next.toString().equals(";") || surrounds < 0) {
                if (token != null) {
                    token.setRight((QueryTokens._Expression)var4_5);
                    tokens.add(token);
                }
                token = new QueryTokens.Condition();
                token.setAppend(next.toString());
                Object var4_9 = null;
                continue;
            }
            String string = value = var4_5 == null ? new String() : var4_5.toString();
            if (value.length() > 0 && (next instanceof String || next instanceof Number) && Character.isLetterOrDigit(last = value.charAt(value.length() - 1))) {
                value = value + ' ';
            }
            value = value + next.toString();
            QueryTokens.DefaultExpression defaultExpression = new QueryTokens.DefaultExpression(value);
            if (!between || !next.toString().equalsIgnoreCase("AND")) continue;
            between = false;
        } while (surrounds >= 0);
        li.previous();
        return tokens.toArray(new QueryTokens.Condition[tokens.size()]);
    }

    public static void doConvertColumns(QuerySpecification qs) throws IOException {
        Hashtable<String, QueryTokens._TableReference> tables = new Hashtable<String, QueryTokens._TableReference>();
        QueryTokens._TableReference[] fromClause = qs.getFromClause();
        for (int i = 0; i < fromClause.length; ++i) {
            QueryTokens._TableReference token = fromClause[i];
            if (token instanceof QueryTokens.Join) {
                tables.put(SQLFormatter.stripQuote(((QueryTokens.Join)token).getPrimary().getTable().getReference()), ((QueryTokens.Join)token).getPrimary().getTable());
                tables.put(SQLFormatter.stripQuote(((QueryTokens.Join)token).getForeign().getTable().getReference()), ((QueryTokens.Join)token).getForeign().getTable());
                continue;
            }
            tables.put(SQLFormatter.stripQuote(((QueryTokens.Table)token).getReference()), token);
        }
        QueryTokens._Expression[] selectList = qs.getSelectList();
        for (int i = 0; i < selectList.length; ++i) {
            QueryTokens.Column c = SQLParser.doConvertColumn(tables, selectList[i]);
            if (c == null) continue;
            qs.removeSelectList(selectList[i]);
            qs.addSelectList(c);
        }
    }

    public static QueryTokens.Column doConvertColumn(Hashtable tables, QueryTokens._Expression e) throws IOException {
        QueryTokens.Column c = null;
        StreamTokenizer stream = SQLParser.createTokenizer(new StringReader(e.toString()));
        ArrayList<String> al = new ArrayList<String>();
        while (true) {
            stream.nextToken();
            if (stream.ttype == -1) {
                ListIterator li = al.listIterator();
                String ref = li.next().toString();
                String alias = null;
                while (li.hasNext()) {
                    String next = li.next().toString();
                    if (next.toString().equals(String.valueOf('.')) || ref.endsWith(String.valueOf('.'))) {
                        ref = ref + next;
                        continue;
                    }
                    alias = next;
                }
                int dot = (ref = SQLFormatter.stripQuote(ref)).lastIndexOf(46);
                if (dot == -1) break;
                String owner = ref.substring(0, dot);
                String cname = ref.substring(dot + 1);
                if (!tables.containsKey(owner)) break;
                c = new QueryTokens.Column((QueryTokens.Table)tables.get(owner), cname);
                if (alias == null) break;
                c.setAlias(alias);
                break;
            }
            if (stream.sval == null && (char)stream.ttype != '.') break;
            al.add(stream.sval == null ? String.valueOf('.') : stream.sval);
        }
        return c;
    }

    public static boolean isOperator(String s) {
        return SQLParser.isOperatorSimbol(s) || s.equalsIgnoreCase("IS") || s.equalsIgnoreCase("IS NOT") || s.equalsIgnoreCase("IN") || s.equalsIgnoreCase("NOT IN") || s.equalsIgnoreCase("LIKE") || s.equalsIgnoreCase("NOT LIKE") || s.equalsIgnoreCase("EXISTS") || s.equalsIgnoreCase("NOT EXISTS") || s.equalsIgnoreCase("BETWEEN") || s.equalsIgnoreCase("NOT BETWEEN");
    }

    public static boolean isOperatorSimbol(String s) {
        return s.equals("<") || s.equals(">") || s.equals("=") || s.equals("<=") || s.equals(">=") || s.equals("<>");
    }

    public static boolean isReservedWord(String s) {
        return SQLParser.isClauseWord(s) || SQLParser.isJoinWord(s) || s.equals("ON") || s.equals("AND") || s.equals("OR");
    }

    public static boolean isJoinWord(String s) {
        return s.equalsIgnoreCase("INNER JOIN") || s.equalsIgnoreCase("FULL OUTER JOIN") || s.equalsIgnoreCase("LEFT OUTER JOIN") || s.equalsIgnoreCase("RIGHT OUTER JOIN");
    }

    public static boolean isClauseWord(String s) {
        return s.equalsIgnoreCase("SELECT") || s.equalsIgnoreCase("FROM") || s.equalsIgnoreCase("WHERE") || s.equalsIgnoreCase("GROUP BY") || s.equalsIgnoreCase("HAVING") || s.equalsIgnoreCase("UNION") || s.equalsIgnoreCase("ORDER BY");
    }

    private static void doAdjustSequence(ArrayList al) {
        for (int i = 0; i < al.size(); ++i) {
            if (al.get(i).toString().equalsIgnoreCase("SELECT") || al.get(i).toString().equalsIgnoreCase("FROM") || al.get(i).toString().equalsIgnoreCase("HAVING")) {
                al.set(i, al.get(i).toString().toUpperCase());
                continue;
            }
            if (al.get(i).toString().equalsIgnoreCase("BY")) {
                al.set(i - 1, al.get(i - 1).toString().toUpperCase() + ' ' + "BY");
                al.remove(i--);
                continue;
            }
            if (al.get(i).toString().equalsIgnoreCase("JOIN")) {
                if (al.get(i - 1).toString().equalsIgnoreCase("INNER")) {
                    al.set(i - 1, al.get(i - 1).toString().toUpperCase() + ' ' + "JOIN");
                    al.remove(i--);
                    continue;
                }
                if (!al.get(i - 1).toString().equalsIgnoreCase("OUTER")) continue;
                al.set(i - 2, al.get(i - 2).toString().toUpperCase() + ' ' + "OUTER" + ' ' + "JOIN");
                al.remove(i--);
                al.remove(i--);
                continue;
            }
            if (al.get(i).toString().equalsIgnoreCase("NOT")) {
                if (al.get(i - 1).toString().equalsIgnoreCase("IS")) {
                    al.set(i - 1, "IS NOT");
                    al.remove(i--);
                    continue;
                }
                if (!al.get(i + 1).toString().equalsIgnoreCase("IN") && !al.get(i + 1).toString().equalsIgnoreCase("LIKE") && !al.get(i + 1).toString().equalsIgnoreCase("EXISTS") && !al.get(i + 1).toString().equalsIgnoreCase("BETWEEN")) continue;
                al.set(i, "NOT " + al.get(i + 1).toString().toUpperCase());
                al.remove(i + 1);
                continue;
            }
            if (al.get(i).toString().equals("=")) {
                if (!al.get(i - 1).toString().equals("<") && !al.get(i - 1).toString().equals(">")) continue;
                al.set(i - 1, al.get(i - 1).toString() + "=");
                al.remove(i--);
                continue;
            }
            if (al.get(i).toString().equals(">") && al.get(i - 1).toString().equals("<")) {
                al.set(i - 1, "<>");
                al.remove(i--);
                continue;
            }
            if (!al.get(i).toString().equals(".")) continue;
            al.set(i, al.get(i - 1).toString() + '.' + al.get(i + 1).toString());
            al.remove(i - 1);
            al.remove(i--);
        }
    }

    private static ArrayList doTokenize(Reader r) throws IOException {
        ArrayList<Object> al = new ArrayList<Object>();
        StreamTokenizer stream = SQLParser.createTokenizer(r);
        while (stream.ttype != -1) {
            stream.nextToken();
            if (stream.ttype == -3) {
                al.add(stream.sval);
                continue;
            }
            if (stream.ttype == -2) {
                Double dval = new Double(stream.nval);
                al.add(dval == (double)dval.intValue() ? (Number)new Integer((int)stream.nval) : (Number)dval);
                continue;
            }
            if (stream.ttype == -1) continue;
            if (stream.sval == null) {
                al.add(new Character((char)stream.ttype));
                continue;
            }
            al.add((char)stream.ttype + stream.sval + (char)stream.ttype);
        }
        if (al.size() > 0 && !al.get(al.size() - 1).toString().equals(";")) {
            al.add(new Character(';'));
        }
        return al;
    }

    private static StreamTokenizer createTokenizer(Reader r) {
        StreamTokenizer stream = new StreamTokenizer(r);
        stream.ordinaryChar(46);
        stream.wordChars(95, 95);
        if (!QueryBuilder.identifierQuoteString.equals("\"")) {
            stream.quoteChar(QueryBuilder.identifierQuoteString.charAt(0));
        }
        stream.slashSlashComments(true);
        stream.slashStarComments(true);
        return stream;
    }

    public static void main(String[] args) {
        QueryBuilder.useAlwaysQuote = false;
        try {
            String fname = "E:/SQLeonardo/tmp/test.sql";
            QueryModel qm = SQLParser.toQueryModel(new FileReader(fname));
            System.out.println(qm.toString(true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

