/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.comparer;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.common.gui.CommandButton;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.comparer._Analyzer;
import nickyb.sqleonardo.environment.ctrl.comparer._Starter;
import nickyb.sqleonardo.environment.mdi._ConnectionListener;

public class CriteriaPane
extends JPanel
implements _Starter,
_ConnectionListener,
ItemListener,
ActionListener {
    private _Analyzer analyzer;
    private CommandButton cb;
    private JComboBox cbxConnection1;
    private JComboBox cbxSchema1;
    private JComboBox cbxConnection2;
    private JComboBox cbxSchema2;
    private JTextField txtTables;
    private JComboBox cbxPattern;
    private JCheckBox chxViceVersa;
    private JCheckBox chxColumns;
    private JCheckBox chxIndeces;
    private JCheckBox chxPrimaryKeys;
    private JCheckBox chxExportedKeys;
    private JCheckBox chxImportedKeys;

    public CriteriaPane(_Analyzer analyzer) {
        Application.window.addListener(this);
        this.analyzer = analyzer;
        this.setBackground(Color.white);
        this.setBorder(LineBorder.createGrayLineBorder());
        this.initComponents();
    }

    private void initComponents() {
        JPanel pnlMaster = new JPanel(new GridLayout(4, 1, 0, 0));
        pnlMaster.setOpaque(false);
        pnlMaster.add(new JLabel("1) use connection:"));
        this.cbxConnection1 = new JComboBox<Object>(ConnectionAssistant.getHandlers().toArray());
        pnlMaster.add(this.cbxConnection1);
        pnlMaster.add(new JLabel("1) schema:"));
        this.cbxSchema1 = new JComboBox();
        pnlMaster.add(this.cbxSchema1);
        this.cbxConnection1.setSelectedItem(null);
        this.cbxSchema1.setEnabled(false);
        JPanel pnlSlave = new JPanel(new GridLayout(4, 1, 0, 0));
        pnlSlave.setOpaque(false);
        pnlSlave.add(new JLabel("2) use connection:"));
        this.cbxConnection2 = new JComboBox<Object>(ConnectionAssistant.getHandlers().toArray());
        pnlSlave.add(this.cbxConnection2);
        pnlSlave.add(new JLabel("2) schema:"));
        this.cbxSchema2 = new JComboBox();
        pnlSlave.add(this.cbxSchema2);
        this.cbxConnection2.setSelectedItem(null);
        this.cbxSchema2.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = new Insets(10, 5, 0, 5);
        gbl.setConstraints(pnlMaster, gbc);
        this.add(pnlMaster);
        gbl.setConstraints(pnlSlave, gbc);
        this.add(pnlSlave);
        this.chxViceVersa = new JCheckBox("vice versa");
        this.chxViceVersa.setOpaque(false);
        gbc.insets = new Insets(10, 5, 0, 5);
        gbl.setConstraints(this.chxViceVersa, gbc);
        this.add(this.chxViceVersa);
        gbc.gridwidth = -1;
        gbc.insets = new Insets(20, 5, 0, 5);
        gbc.weightx = 0.0;
        JLabel lbl = new JLabel("table:");
        gbl.setConstraints(lbl, gbc);
        this.add(lbl);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.cbxPattern = new JComboBox<String>(new String[]{"equals", "contains", "starts with", "ends with"});
        gbl.setConstraints(this.cbxPattern, gbc);
        this.add(this.cbxPattern);
        gbc.insets = new Insets(0, 5, 0, 5);
        this.txtTables = new JTextField();
        gbl.setConstraints(this.txtTables, gbc);
        this.add(this.txtTables);
        this.cbxPattern.setPreferredSize(this.txtTables.getPreferredSize());
        this.chxColumns = new JCheckBox("columns");
        this.chxColumns.setOpaque(false);
        gbc.insets = new Insets(10, 5, 0, 5);
        gbl.setConstraints(this.chxColumns, gbc);
        this.add(this.chxColumns);
        this.chxPrimaryKeys = new JCheckBox("primary keys");
        this.chxPrimaryKeys.setOpaque(false);
        gbc.insets = new Insets(0, 5, 0, 5);
        gbl.setConstraints(this.chxPrimaryKeys, gbc);
        this.add(this.chxPrimaryKeys);
        this.chxIndeces = new JCheckBox("indices");
        this.chxIndeces.setOpaque(false);
        gbc.insets = new Insets(0, 5, 0, 5);
        gbl.setConstraints(this.chxIndeces, gbc);
        this.add(this.chxIndeces);
        this.chxExportedKeys = new JCheckBox("exported keys");
        this.chxExportedKeys.setOpaque(false);
        gbc.insets = new Insets(0, 5, 0, 5);
        gbl.setConstraints(this.chxExportedKeys, gbc);
        this.add(this.chxExportedKeys);
        this.chxImportedKeys = new JCheckBox("imported keys");
        this.chxImportedKeys.setOpaque(false);
        gbc.insets = new Insets(0, 5, 0, 5);
        gbl.setConstraints(this.chxImportedKeys, gbc);
        this.add(this.chxImportedKeys);
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(25, 2, 0, 2);
        this.cb = new CommandButton("start", this);
        gbl.setConstraints(this.cb, gbc);
        this.add(this.cb);
        gbc = new GridBagConstraints();
        gbc.weighty = 1.0;
        JPanel pnl = new JPanel();
        pnl.setOpaque(false);
        gbl.setConstraints(pnl, gbc);
        this.add(pnl);
        this.cbxConnection1.addItemListener(this);
        this.cbxConnection2.addItemListener(this);
    }

    public void onConnectionClosed(String keycah) {
        this.cbxConnection1.removeItem(keycah);
        this.cbxConnection2.removeItem(keycah);
    }

    public void onConnectionOpened(String keycah) {
        this.cbxConnection1.addItem(keycah);
        this.cbxConnection2.addItem(keycah);
    }

    public void actionPerformed(ActionEvent ae) {
        boolean stop = this.cb.getText().equals("stop");
        if (!stop && this.cbxConnection1.getSelectedIndex() == -1) {
            return;
        }
        if (!stop && this.cbxSchema1.getItemCount() > 0 && this.cbxSchema1.getSelectedIndex() == -1) {
            return;
        }
        if (!stop && this.cbxConnection2.getSelectedIndex() == -1) {
            return;
        }
        if (!stop && this.cbxSchema2.getItemCount() > 0 && this.cbxSchema2.getSelectedIndex() == -1) {
            return;
        }
        if (stop) {
            this.analyzer.onStopped();
            this.onFinished();
        } else {
            this.setEnabled(false);
            this.cb.setText("stop");
            this.analyzer.perform(this);
        }
    }

    public void setEnabled(boolean b) {
        this.cbxConnection1.setEnabled(b);
        this.cbxSchema1.setEnabled(b && this.cbxSchema1.getItemCount() > 0);
        this.cbxConnection2.setEnabled(b);
        this.cbxSchema2.setEnabled(b && this.cbxSchema2.getItemCount() > 0);
        this.txtTables.setEnabled(b);
        this.cbxPattern.setEnabled(b);
        this.chxColumns.setEnabled(b);
        this.chxIndeces.setEnabled(b);
        this.chxPrimaryKeys.setEnabled(b);
        this.chxExportedKeys.setEnabled(b);
        this.chxImportedKeys.setEnabled(b);
        this.chxViceVersa.setEnabled(b);
    }

    public void onFinished() {
        this.setEnabled(true);
        this.cb.setText("start");
    }

    public boolean isViceVersa() {
        return this.chxViceVersa.isSelected();
    }

    public void itemStateChanged(ItemEvent ie) {
        JComboBox cbxSchema = ie.getSource() == this.cbxConnection1 ? this.cbxSchema1 : this.cbxSchema2;
        ConnectionHandler ch = ConnectionAssistant.getHandler(ie.getItem().toString());
        if (ch == null) {
            cbxSchema.setModel(new DefaultComboBoxModel());
        } else {
            ArrayList schemas = (ArrayList)ch.getObject("$schema_names");
            cbxSchema.setModel(new DefaultComboBoxModel<Object>(schemas.toArray()));
        }
        cbxSchema.setEnabled(cbxSchema.getItemCount() > 0);
    }

    public String getKeyHandler1() {
        return this.cbxConnection1.getSelectedItem().toString();
    }

    public String getSchema1() {
        return this.cbxSchema1.getSelectedIndex() != -1 ? this.cbxSchema1.getSelectedItem().toString() : null;
    }

    public String getKeyHandler2() {
        return this.cbxConnection2.getSelectedItem().toString();
    }

    public String getSchema2() {
        return this.cbxSchema2.getSelectedIndex() != -1 ? this.cbxSchema2.getSelectedItem().toString() : null;
    }

    public String getTablePattern() {
        String operator = this.cbxPattern.getSelectedItem().toString();
        String value = this.txtTables.getText();
        if (value == null || value.length() == 0) {
            return null;
        }
        if (operator.equals("contains")) {
            if (!value.toString().startsWith("%")) {
                value = "%" + value.toString();
            }
            if (!value.toString().endsWith("%")) {
                value = value.toString() + "%";
            }
        } else if (operator.equals("starts with")) {
            if (!value.toString().endsWith("%")) {
                value = value.toString() + "%";
            }
        } else if (operator.equals("ends with") && !value.toString().startsWith("%")) {
            value = "%" + value.toString();
        }
        return value.toUpperCase();
    }

    public boolean checkColumns() {
        return this.chxColumns.isSelected();
    }

    public boolean checkIndeces() {
        return this.chxIndeces.isSelected();
    }

    public boolean checkPrimaryKeys() {
        return this.chxPrimaryKeys.isSelected();
    }

    public boolean checkExportedKeys() {
        return this.chxExportedKeys.isSelected();
    }

    public boolean checkImportedKeys() {
        return this.chxImportedKeys.isSelected();
    }
}

