/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi;

import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.AnyAttributeProxy;
import org.netbeans.modules.xml.axi.impl.AnyElementProxy;
import org.netbeans.modules.xml.axi.impl.AttributeImpl;
import org.netbeans.modules.xml.axi.impl.AttributeProxy;
import org.netbeans.modules.xml.axi.impl.AttributeRef;
import org.netbeans.modules.xml.axi.impl.CompositorProxy;
import org.netbeans.modules.xml.axi.impl.ElementImpl;
import org.netbeans.modules.xml.axi.impl.ElementProxy;
import org.netbeans.modules.xml.axi.impl.ElementRef;
import org.netbeans.modules.xml.axi.visitor.DefaultVisitor;
import org.netbeans.modules.xml.schema.model.SchemaComponent;

public class AXIComponentFactory {
    private AXIModel model;
    private long elementCount;
    private long attributeCount;
    private long compositorCount;
    private long contentModelCount;
    private long proxyComponentCount;

    AXIComponentFactory(AXIModel aXIModel) {
        this.model = aXIModel;
    }

    public long getComponentCount() {
        return this.elementCount + this.attributeCount + this.compositorCount + this.contentModelCount + this.proxyComponentCount + 1L;
    }

    public AXIComponent copy(AXIComponent aXIComponent) {
        AXICopier aXICopier = new AXICopier(this.model);
        return aXICopier.copy(aXIComponent);
    }

    public Element createElement() {
        ++this.elementCount;
        return new ElementImpl(this.model);
    }

    public Element createElement(SchemaComponent schemaComponent) {
        ++this.elementCount;
        return new ElementImpl(this.model, schemaComponent);
    }

    public Element createElementReference(Element element) {
        ++this.elementCount;
        return new ElementRef(this.model, element);
    }

    public Element createElementReference(SchemaComponent schemaComponent, Element element) {
        ++this.elementCount;
        return new ElementRef(this.model, schemaComponent, element);
    }

    public Attribute createAttribute() {
        ++this.attributeCount;
        return new AttributeImpl(this.model);
    }

    public Attribute createAttribute(SchemaComponent schemaComponent) {
        ++this.attributeCount;
        return new AttributeImpl(this.model, schemaComponent);
    }

    public Attribute createAttributeReference(Attribute attribute) {
        ++this.attributeCount;
        return new AttributeRef(this.model, attribute);
    }

    public Attribute createAttributeReference(SchemaComponent schemaComponent, Attribute attribute) {
        ++this.attributeCount;
        return new AttributeRef(this.model, schemaComponent, attribute);
    }

    public Compositor createCompositor(Compositor.CompositorType compositorType) {
        ++this.compositorCount;
        Compositor compositor = new Compositor(this.model, compositorType);
        return compositor;
    }

    public Compositor createSequence() {
        ++this.compositorCount;
        return new Compositor(this.model, Compositor.CompositorType.SEQUENCE);
    }

    public Compositor createSequence(SchemaComponent schemaComponent) {
        ++this.compositorCount;
        Compositor compositor = new Compositor(this.model, schemaComponent);
        return compositor;
    }

    public Compositor createChoice() {
        ++this.compositorCount;
        return new Compositor(this.model, Compositor.CompositorType.CHOICE);
    }

    public Compositor createChoice(SchemaComponent schemaComponent) {
        ++this.compositorCount;
        Compositor compositor = new Compositor(this.model, schemaComponent);
        return compositor;
    }

    public Compositor createAll() {
        ++this.compositorCount;
        return new Compositor(this.model, Compositor.CompositorType.ALL);
    }

    public Compositor createAll(SchemaComponent schemaComponent) {
        ++this.compositorCount;
        Compositor compositor = new Compositor(this.model, schemaComponent);
        return compositor;
    }

    public AnyElement createAnyElement() {
        ++this.compositorCount;
        return new AnyElement(this.model);
    }

    public AnyElement createAnyElement(SchemaComponent schemaComponent) {
        ++this.compositorCount;
        return new AnyElement(this.model, schemaComponent);
    }

    public AnyAttribute createAnyAttribute() {
        ++this.compositorCount;
        return new AnyAttribute(this.model);
    }

    public AnyAttribute createAnyAttribute(SchemaComponent schemaComponent) {
        ++this.compositorCount;
        return new AnyAttribute(this.model, schemaComponent);
    }

    public ContentModel createComplexType() {
        ++this.contentModelCount;
        return new ContentModel(this.model, ContentModel.ContentModelType.COMPLEX_TYPE);
    }

    public ContentModel createGroup() {
        ++this.contentModelCount;
        return new ContentModel(this.model, ContentModel.ContentModelType.GROUP);
    }

    public ContentModel createAttributeGroup() {
        ++this.contentModelCount;
        return new ContentModel(this.model, ContentModel.ContentModelType.ATTRIBUTE_GROUP);
    }

    public ContentModel createContentModel(ContentModel.ContentModelType contentModelType) {
        ++this.contentModelCount;
        return new ContentModel(this.model, contentModelType);
    }

    public ContentModel createContentModel(SchemaComponent schemaComponent) {
        ++this.contentModelCount;
        return new ContentModel(this.model, schemaComponent);
    }

    public AXIComponent createProxy(AXIComponent aXIComponent) {
        ++this.proxyComponentCount;
        return new ProxyComponentFactory().createProxy(aXIComponent);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("elementCount: " + this.elementCount + "\n");
        stringBuffer.append("attributeCount: " + this.attributeCount + "\n");
        stringBuffer.append("compositorCount: " + this.compositorCount + "\n");
        stringBuffer.append("contentModelCount: " + this.contentModelCount + "\n");
        stringBuffer.append("proxyComponentCount: " + this.proxyComponentCount + "\n");
        return stringBuffer.toString();
    }

    private class AXICopier
    extends DefaultVisitor {
        private AXIComponent copiedComponent;
        private AXIModel model;

        public AXICopier(AXIModel aXIModel) {
            this.model = aXIModel;
        }

        public AXIComponent copy(AXIComponent aXIComponent) {
            if (aXIComponent.getComponentType() == AXIComponent.ComponentType.PROXY) {
                AXIComponentFactory aXIComponentFactory = this.model.getComponentFactory();
                this.copiedComponent = aXIComponentFactory.createProxy(aXIComponent.getSharedComponent());
                assert (this.copiedComponent != null);
                return this.copiedComponent;
            }
            aXIComponent.accept(this);
            assert (this.copiedComponent != null);
            return this.copiedComponent;
        }

        public void visit(Element element) {
            if (element instanceof ElementRef) {
                ElementRef elementRef = (ElementRef)element;
                this.copiedComponent = this.model.getComponentFactory().createElementReference(elementRef.getReferent());
                ((Element)this.copiedComponent).setMaxOccurs(element.getMaxOccurs());
                ((Element)this.copiedComponent).setMinOccurs(element.getMinOccurs());
                return;
            }
            this.copiedComponent = this.model.getComponentFactory().createElement();
            ((Element)this.copiedComponent).setAbstract(element.getAbstract());
            ((Element)this.copiedComponent).setBlock(element.getBlock());
            ((Element)this.copiedComponent).setDefault(element.getDefault());
            ((Element)this.copiedComponent).setFinal(element.getFinal());
            ((Element)this.copiedComponent).setForm(element.getForm());
            ((Element)this.copiedComponent).setFixed(element.getFixed());
            ((Element)this.copiedComponent).setMaxOccurs(element.getMaxOccurs());
            ((Element)this.copiedComponent).setMinOccurs(element.getMinOccurs());
            ((Element)this.copiedComponent).setName(element.getName());
            ((Element)this.copiedComponent).setNillable(element.getNillable());
        }

        public void visit(AnyElement anyElement) {
            this.copiedComponent = this.model.getComponentFactory().createAnyElement();
            ((AnyElement)this.copiedComponent).setProcessContents(anyElement.getProcessContents());
            ((AnyElement)this.copiedComponent).setTargetNamespace(anyElement.getTargetNamespace());
        }

        public void visit(Attribute attribute) {
            if (attribute instanceof AttributeRef) {
                AttributeRef attributeRef = (AttributeRef)attribute;
                this.copiedComponent = this.model.getComponentFactory().createAttributeReference(attributeRef.getReferent());
                ((Attribute)this.copiedComponent).setFixed(attribute.getFixed());
                ((Attribute)this.copiedComponent).setDefault(attribute.getDefault());
                ((Attribute)this.copiedComponent).setUse(attribute.getUse());
                return;
            }
            this.copiedComponent = this.model.getComponentFactory().createAttribute();
            ((Attribute)this.copiedComponent).setDefault(attribute.getDefault());
            ((Attribute)this.copiedComponent).setFixed(attribute.getFixed());
            ((Attribute)this.copiedComponent).setForm(attribute.getForm());
            ((Attribute)this.copiedComponent).setUse(attribute.getUse());
            ((Attribute)this.copiedComponent).setName(attribute.getName());
        }

        public void visit(AnyAttribute anyAttribute) {
            this.copiedComponent = this.model.getComponentFactory().createAnyAttribute();
            ((AnyAttribute)this.copiedComponent).setProcessContents(anyAttribute.getProcessContents());
            ((AnyAttribute)this.copiedComponent).setTargetNamespace(anyAttribute.getTargetNamespace());
        }

        public void visit(Compositor compositor) {
            this.copiedComponent = this.model.getComponentFactory().createCompositor(compositor.getType());
            ((Compositor)this.copiedComponent).setMaxOccurs(compositor.getMaxOccurs());
            ((Compositor)this.copiedComponent).setMinOccurs(compositor.getMinOccurs());
        }

        public void visit(ContentModel contentModel) {
            this.copiedComponent = this.model.getComponentFactory().createContentModel(contentModel.getType());
        }
    }

    private class ProxyComponentFactory
    extends DefaultVisitor {
        private AXIComponent proxyComponent;

        ProxyComponentFactory() {
        }

        AXIComponent createProxy(AXIComponent aXIComponent) {
            aXIComponent.accept(this);
            return this.proxyComponent;
        }

        public void visit(Element element) {
            this.proxyComponent = new ElementProxy(AXIComponentFactory.this.model, element);
        }

        public void visit(AnyElement anyElement) {
            this.proxyComponent = new AnyElementProxy(AXIComponentFactory.this.model, anyElement);
        }

        public void visit(Attribute attribute) {
            this.proxyComponent = new AttributeProxy(AXIComponentFactory.this.model, attribute);
        }

        public void visit(AnyAttribute anyAttribute) {
            this.proxyComponent = new AnyAttributeProxy(AXIComponentFactory.this.model, anyAttribute);
        }

        public void visit(Compositor compositor) {
            this.proxyComponent = new CompositorProxy(AXIComponentFactory.this.model, compositor);
        }
    }
}

