/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.LinkedList;
import javax.swing.text.JTextComponent;

public class KeyEventBlocker
implements KeyListener {
    private LinkedList blockedEvents = new LinkedList();
    private JTextComponent component;
    private boolean discardKeyTyped = true;
    private static final boolean debugBlockEvent = Boolean.getBoolean("netbeans.debug.editor.blocker");

    public KeyEventBlocker(JTextComponent jTextComponent, boolean bl) {
        this.component = jTextComponent;
        this.discardKeyTyped = bl;
        if (debugBlockEvent) {
            System.out.println("");
            System.out.println("attaching listener" + this.component.getClass() + " - " + this.component.hashCode());
        }
        this.component.addKeyListener(this);
    }

    public void stopBlocking(boolean bl) {
        if (debugBlockEvent) {
            System.out.println("removing listener from " + this.component.getClass() + " - " + this.component.hashCode());
        }
        this.component.removeKeyListener(this);
        if (bl) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window window = keyboardFocusManager.getFocusedWindow();
            while (!this.blockedEvents.isEmpty()) {
                KeyEvent keyEvent = (KeyEvent)this.blockedEvents.removeFirst();
                Window window2 = window != null ? window : (Component)keyEvent.getSource();
                keyEvent = new KeyEvent(window2, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
                keyboardFocusManager.dispatchEvent(keyEvent);
            }
        }
    }

    public void stopBlocking() {
        this.stopBlocking(true);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (debugBlockEvent) {
            System.out.println("consuming keyPressed event:" + KeyEvent.getKeyModifiersText(keyEvent.getModifiers()) + " + " + KeyEvent.getKeyText(keyEvent.getKeyCode()));
        }
        keyEvent.consume();
        this.blockedEvents.add(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (debugBlockEvent) {
            System.out.println("consuming keyReleased event:" + KeyEvent.getKeyModifiersText(keyEvent.getModifiers()) + " + " + KeyEvent.getKeyText(keyEvent.getKeyCode()));
        }
        keyEvent.consume();
        this.blockedEvents.add(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (debugBlockEvent) {
            System.out.println("consuming keyTyped event:" + KeyEvent.getKeyModifiersText(keyEvent.getModifiers()) + " + " + KeyEvent.getKeyText(keyEvent.getKeyCode()));
        }
        keyEvent.consume();
        if (this.discardKeyTyped) {
            this.discardKeyTyped = false;
        } else {
            this.blockedEvents.add(keyEvent);
        }
    }
}

