/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PathElements {
    private static final String DELIMITER = "/";
    private String name;
    private StringTokenizer tokenizer;
    private List<String> tokens;

    public PathElements(String string) {
        this.name = string;
        this.tokenizer = new StringTokenizer(string, DELIMITER);
        this.tokens = new ArrayList<String>(10);
    }

    public String getOriginalName() {
        return this.name;
    }

    public Enumeration<String> getEnumeration() {
        return new EnumerationImpl(this);
    }

    boolean contains(int n) {
        if (this.tokens.size() <= n) {
            this.scanUpTo(n);
        }
        return this.tokens.size() > n;
    }

    String get(int n) throws NoSuchElementException {
        if (this.tokens.size() <= n) {
            this.scanUpTo(n);
        }
        if (this.tokens.size() <= n) {
            throw new NoSuchElementException();
        }
        return this.tokens.get(n);
    }

    private synchronized void scanUpTo(int n) {
        if (this.tokenizer == null) {
            return;
        }
        if (this.tokens.size() > n) {
            return;
        }
        for (int i = this.tokens.size() - 1; i < n && this.tokenizer.hasMoreTokens(); ++i) {
            this.tokens.add(this.tokenizer.nextToken());
        }
        if (!this.tokenizer.hasMoreTokens()) {
            this.tokenizer = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EnumerationImpl
    implements Enumeration<String> {
        private PathElements elements;
        private int pos;

        EnumerationImpl(PathElements pathElements) {
            this.elements = pathElements;
            this.pos = 0;
        }

        @Override
        public boolean hasMoreElements() {
            return this.elements.contains(this.pos);
        }

        @Override
        public String nextElement() throws NoSuchElementException {
            return this.elements.get(this.pos++);
        }
    }
}

