/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.plugins.FileDeletePlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PackageDeleteRefactoringPlugin
implements RefactoringPlugin {
    private final SafeDeleteRefactoring refactoring;
    static final String JAVA_EXTENSION = "java";

    public PackageDeleteRefactoringPlugin(SafeDeleteRefactoring safeDeleteRefactoring) {
        this.refactoring = safeDeleteRefactoring;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Lookup lookup = this.refactoring.getRefactoringSource();
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
        if (nonRecursiveFolder != null) {
            return this.preparePackageDelete(nonRecursiveFolder, refactoringElementsBag);
        }
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null && fileObject.isFolder()) {
            return this.prepareFolderDelete(fileObject, refactoringElementsBag);
        }
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    private Problem prepareFolderDelete(FileObject fileObject, RefactoringElementsBag refactoringElementsBag) {
        this.addDataFilesInFolder(fileObject, refactoringElementsBag);
        refactoringElementsBag.addFileChange(this.refactoring, new FolderDeleteElem(fileObject));
        return null;
    }

    private Problem preparePackageDelete(NonRecursiveFolder nonRecursiveFolder, RefactoringElementsBag refactoringElementsBag) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)nonRecursiveFolder.getFolder());
        DataObject[] dataObjectArray = dataFolder.getChildren();
        boolean bl = true;
        for (int i = 0; dataObjectArray != null && i < dataObjectArray.length; ++i) {
            FileObject fileObject = dataObjectArray[i].getPrimaryFile();
            if (!fileObject.isFolder()) {
                refactoringElementsBag.addFileChange(this.refactoring, new FileDeletePlugin.DeleteFile(fileObject, refactoringElementsBag));
                continue;
            }
            bl = false;
        }
        if (bl) {
            refactoringElementsBag.addFileChange(this.refactoring, new PackageDeleteElem(nonRecursiveFolder));
        }
        return null;
    }

    private void addDataFilesInFolder(FileObject fileObject, RefactoringElementsBag refactoringElementsBag) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!fileObject2.isFolder()) {
                refactoringElementsBag.addFileChange(this.refactoring, new FileDeletePlugin.DeleteFile(fileObject2, refactoringElementsBag));
                continue;
            }
            if (!fileObject2.isFolder()) continue;
            this.addDataFilesInFolder(fileObject2, refactoringElementsBag);
        }
    }

    private static void createNewFolder(File file) throws IOException {
        if (!file.exists()) {
            File file2 = file.getParentFile();
            if (file2 != null) {
                PackageDeleteRefactoringPlugin.createNewFolder(file2);
            }
            file.mkdir();
        }
    }

    private static class PackageDeleteElem
    extends SimpleRefactoringElementImplementation {
        private final URL res;
        private final NonRecursiveFolder folder;
        private File dir;
        private final SourceGroup srcGroup;

        private PackageDeleteElem(NonRecursiveFolder nonRecursiveFolder) {
            this.folder = nonRecursiveFolder;
            this.dir = FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder());
            try {
                this.res = nonRecursiveFolder.getFolder().getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                throw new IllegalStateException(fileStateInvalidException);
            }
            this.srcGroup = this.getJavaSourceGroup(nonRecursiveFolder.getFolder());
        }

        public void performChange() {
            FileObject fileObject = this.srcGroup.getRootFolder();
            FileObject fileObject2 = this.folder.getFolder().getParent();
            this.dir = FileUtil.toFile((FileObject)this.folder.getFolder());
            try {
                this.folder.getFolder().delete();
                while (!fileObject2.equals(fileObject) && fileObject2.getChildren().length == 0) {
                    FileObject fileObject3 = fileObject2.getParent();
                    fileObject2.delete();
                    fileObject2 = fileObject3;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        public void undoChange() {
            try {
                PackageDeleteRefactoringPlugin.createNewFolder(this.dir);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        public String getText() {
            return NbBundle.getMessage(FileDeletePlugin.class, (String)"TXT_DeletePackage", (Object)this.dir.getName());
        }

        public String getDisplayText() {
            return this.getText();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return URLMapper.findFileObject((URL)this.res);
        }

        public PositionBounds getPosition() {
            return null;
        }

        private SourceGroup getJavaSourceGroup(FileObject fileObject) {
            SourceGroup[] sourceGroupArray;
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return null;
            }
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups(PackageDeleteRefactoringPlugin.JAVA_EXTENSION)) {
                if (!sourceGroup.getRootFolder().equals(fileObject) && !FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject)) continue;
                return sourceGroup;
            }
            return null;
        }
    }

    private static class FolderDeleteElem
    extends SimpleRefactoringElementImplementation {
        private final FileObject dirFileObject;
        private File dir;

        private FolderDeleteElem(FileObject fileObject) {
            this.dirFileObject = fileObject;
            this.dir = FileUtil.toFile((FileObject)this.dirFileObject);
        }

        public void performChange() {
            try {
                this.dirFileObject.delete();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        public void undoChange() {
            try {
                PackageDeleteRefactoringPlugin.createNewFolder(this.dir);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }

        public String getText() {
            return NbBundle.getMessage(FileDeletePlugin.class, (String)"TXT_DeleteFolder", (Object)this.dirFileObject.getNameExt());
        }

        public String getDisplayText() {
            return this.getText();
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            try {
                return URLMapper.findFileObject((URL)this.dirFileObject.getURL());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                throw new IllegalStateException(fileStateInvalidException);
            }
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

