/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceDataObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.actions.SystemAction;

final class DataLdrActions
extends FolderInstance {
    private Reference<DataLoader> ref;
    private Task creation;
    private static RequestProcessor RP = new RequestProcessor("Loader Actions");

    public DataLdrActions(DataFolder dataFolder, DataLoader dataLoader) {
        super(dataFolder);
        this.ref = new WeakReference<DataLoader>(dataLoader);
    }

    public synchronized void setActions(final SystemAction[] systemActionArray) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class DoTheWork
        implements Runnable,
        FileSystem.AtomicAction {
            private int state;

            DoTheWork() {
            }

            /*
             * WARNING - void declaration
             */
            private void work() throws IOException {
                DataObject[] dataObjectArray = DataLdrActions.this.folder.getChildren();
                HashMap<Object, DataObject> hashMap = new HashMap<Object, DataObject>();
                LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    InstanceCookie instanceCookie = dataObjectArray[i].getCookie(InstanceCookie.class);
                    if (instanceCookie == null) continue;
                    try {
                        Object classNotFoundException = instanceCookie.instanceCreate();
                        if (classNotFoundException instanceof Action) {
                            hashMap.put(classNotFoundException, dataObjectArray[i]);
                            continue;
                        }
                        if (!(classNotFoundException instanceof JSeparator)) continue;
                        linkedList.add(dataObjectArray[i]);
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Exceptions.printStackTrace((Throwable)classNotFoundException);
                    }
                }
                ArrayList<void> arrayList = new ArrayList<void>();
                for (int i = 0; i < systemActionArray.length; ++i) {
                    void var6_17;
                    DataObject dataObject = (DataObject)hashMap.remove(systemActionArray[i]);
                    if (dataObject == null) {
                        if (systemActionArray[i] != null) {
                            InstanceDataObject instanceDataObject = InstanceDataObject.create(DataLdrActions.this.folder, null, systemActionArray[i].getClass());
                        } else if (!linkedList.isEmpty()) {
                            DataObject dataObject2 = (DataObject)linkedList.removeFirst();
                        } else {
                            InstanceDataObject instanceDataObject = InstanceDataObject.create(DataLdrActions.this.folder, "Separator" + arrayList.size(), JSeparator.class);
                        }
                    }
                    arrayList.add(var6_17);
                }
                for (DataObject dataObject : hashMap.values()) {
                    dataObject.delete();
                }
                for (DataObject dataObject : linkedList) {
                    dataObject.delete();
                }
                DataLdrActions.this.folder.setOrder(arrayList.toArray(new DataObject[0]));
            }

            @Override
            public void run() {
                try {
                    switch (this.state) {
                        case 0: {
                            this.state = 1;
                            DataLdrActions.this.folder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)this);
                            break;
                        }
                        case 1: {
                            this.work();
                        }
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        DoTheWork doTheWork = new DoTheWork();
        this.creation = RP.post((Runnable)doTheWork);
    }

    protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (int i = 0; i < instanceCookieArray.length; ++i) {
            Class clazz = instanceCookieArray[i].instanceClass();
            if (JSeparator.class.isAssignableFrom(clazz)) {
                arrayList.add(null);
                continue;
            }
            Object object = instanceCookieArray[i].instanceCreate();
            if (!(object instanceof Action)) continue;
            arrayList.add((Action)object);
        }
        DataLoader dataLoader = this.ref.get();
        if (dataLoader != null) {
            dataLoader.setSwingActions(arrayList);
        }
        return arrayList.toArray(new Action[0]);
    }

    protected InstanceCookie acceptFolder(DataFolder dataFolder) {
        return null;
    }

    protected Task postCreationTask(Runnable runnable) {
        return RP.post(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFinished() {
        Task task;
        DataLdrActions dataLdrActions = this;
        synchronized (dataLdrActions) {
            task = this.creation;
        }
        if (task != null) {
            task.waitFinished();
        }
        super.waitFinished();
    }
}

