/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.HeaderCellRenderer;

public class ListView
extends BorderLayoutPanel {
    public static final short SORT_ASCENDING = 0;
    public static final short SORT_DESCENDING = 1;
    private int lastIdxSorted = -1;
    private short lastSortType = 0;
    private static ClipboardOwner defaultClipboardOwner = new ClipboardObserver();
    private JTable table = new JTable();

    public ListView() {
        super(2, 2);
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.getViewport().setBackground(Color.white);
        this.setComponentCenter(scroll);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.getTableHeader().addMouseListener(new SortListener());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.reset();
        this.table.getActionMap().put("copy", new ActionCopyCell());
        this.table.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "copy");
    }

    protected JTable getJavaComponent() {
        return this.table;
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.table.getSelectionModel().addListSelectionListener(l);
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.table.addMouseListener(l);
    }

    public void addColumn(String text) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.addColumn(text);
    }

    public void setColumnWidth(String text, int size) {
        TableColumn tableColumn = this.table.getColumn(text);
        tableColumn.setPreferredWidth(size);
        tableColumn.setWidth(size);
    }

    public void setHeaderVisible(boolean aFlag) {
        this.table.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.table.getTableHeader().setVisible(aFlag);
    }

    public void addRow(Object[] rowdata) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.addRow(rowdata);
    }

    public boolean isSelectionEmpty() {
        return this.table.getSelectedRowCount() < 1;
    }

    public String getColumnName(int col) {
        return this.table.getColumnName(col);
    }

    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public Object getValueAt(int row, int col) {
        return this.table.getValueAt(row, col);
    }

    public void setValueAt(Object value, int row, int col) {
        this.table.setValueAt(value, row, col);
    }

    public void removeRow(int row) {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.removeRow(row);
    }

    public void removeSelectedRow() {
        this.removeRow(this.getSelectedRow());
    }

    public void removeAllRows() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        model.setRowCount(0);
    }

    public void copyAllRows() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                String cell;
                String string = cell = this.table.getValueAt(i, j) == null ? null : this.table.getValueAt(i, j).toString();
                if (j > 0) {
                    sb.append("\t");
                }
                sb.append(cell);
            }
            sb.append("\n");
        }
        Clipboard cb = this.getToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(sb.toString());
        cb.setContents(contents, defaultClipboardOwner);
    }

    public void reset() {
        this.lastSortType = 0;
        this.lastIdxSorted = -1;
        DefaultTableModel model = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table.setModel(model);
    }

    public void tableDataChanged() {
        this.table.tableChanged(new TableModelEvent(this.table.getModel()));
    }

    private int compare(int col, int row1, int row2, short type) {
        Object value1 = this.getValueAt(row1, col);
        Object value2 = this.getValueAt(row2, col);
        int cmp = 0;
        if (value1 != null && value2 != null) {
            if (value1 instanceof Number) {
                double d2;
                double d1 = ((Number)value1).doubleValue();
                if (d1 > (d2 = ((Number)value2).doubleValue())) {
                    cmp = 1;
                } else if (d1 < d2) {
                    cmp = -1;
                }
            } else {
                cmp = value1.toString().toLowerCase().compareTo(value2.toString().toLowerCase());
            }
        } else if (value1 != null) {
            cmp = 1;
        } else if (value2 != null) {
            cmp = -1;
        }
        return type == 0 ? cmp : cmp * -1;
    }

    private void swap(int i, int j) {
        Vector<Vector> data = ((DefaultTableModel)this.table.getModel()).getDataVector();
        Vector appo = data.elementAt(i);
        data.setElementAt(data.elementAt(j), i);
        data.setElementAt(appo, j);
    }

    private void sort(int col, int first, int last, short type) {
        int lower = first + 1;
        int upper = last;
        this.swap(first, (first + last) / 2);
        while (lower <= upper) {
            while (this.compare(col, lower, first, type) < 0) {
                ++lower;
            }
            while (this.compare(col, first, upper, type) < 0) {
                --upper;
            }
            if (lower < upper) {
                this.swap(lower++, upper--);
                continue;
            }
            ++lower;
        }
        this.swap(upper, first);
        if (first < upper - 1) {
            this.sort(col, first, upper - 1, type);
        }
        if (upper + 1 < last) {
            this.sort(col, upper + 1, last, type);
        }
    }

    private void sort(int col, short type) {
        int rows = this.getRowCount();
        if (rows < 2) {
            return;
        }
        int max = 0;
        for (int i = 1; i < rows; ++i) {
            if (this.compare(col, max, i, type) >= 0) continue;
            max = i;
        }
        this.swap(rows - 1, max);
        this.sort(col, 0, rows - 2, type);
        this.table.tableChanged(new TableModelEvent(this.table.getModel()));
    }

    static class ClipboardObserver
    implements ClipboardOwner {
        ClipboardObserver() {
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    private class ActionCopyCell
    extends AbstractAction {
        private ActionCopyCell() {
        }

        public void actionPerformed(ActionEvent ae) {
            int col = ListView.this.table.getSelectedColumn();
            int row = ListView.this.table.getSelectedRow();
            if (row != -1 && col != -1) {
                if (ListView.this.table.getValueAt(row, col) == null) {
                    return;
                }
                Clipboard cb = ListView.this.getToolkit().getSystemClipboard();
                String value = ListView.this.table.getValueAt(row, col).toString();
                StringSelection contents = new StringSelection(value);
                cb.setContents(contents, defaultClipboardOwner);
            }
        }
    }

    private class SortListener
    extends MouseAdapter {
        private SortListener() {
        }

        public void mouseClicked(MouseEvent me) {
            if (ListView.this.lastIdxSorted != -1) {
                TableColumn ltc = ListView.this.table.getColumnModel().getColumn(ListView.this.lastIdxSorted);
                HeaderCellRenderer lhcr = ltc.getHeaderRenderer() == null ? new HeaderCellRenderer() : (HeaderCellRenderer)ltc.getHeaderRenderer();
                lhcr.setSelected(false);
                ltc.setHeaderRenderer(lhcr);
            }
            int idx = ListView.this.table.getTableHeader().columnAtPoint(me.getPoint());
            TableColumn tc = ListView.this.table.getColumnModel().getColumn(idx);
            HeaderCellRenderer hcr = tc.getHeaderRenderer() == null ? new HeaderCellRenderer() : (HeaderCellRenderer)tc.getHeaderRenderer();
            hcr.setSelected(true);
            tc.setHeaderRenderer(hcr);
            ListView.this.table.getTableHeader().repaint();
            if (idx == ListView.this.lastIdxSorted) {
                ListView.this.lastSortType = ListView.this.lastSortType == 0 ? (short)1 : 0;
            } else {
                ListView.this.lastIdxSorted = idx;
            }
            ListView.this.sort(ListView.this.lastIdxSorted, ListView.this.lastSortType);
        }
    }
}

