/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public class JRTextElementFactory
extends JRBaseFactory {
    private static final Log log = LogFactory.getLog(JRTextElementFactory.class);

    public Object createObject(Attributes atts) {
        LineSpacingEnum lineSpacing;
        RotationEnum rotation;
        VerticalAlignEnum verticalAlignment;
        JRDesignTextElement textElement = (JRDesignTextElement)this.digester.peek();
        HorizontalAlignEnum horizontalAlignment = HorizontalAlignEnum.getByName(atts.getValue("textAlignment"));
        if (horizontalAlignment != null) {
            textElement.setHorizontalAlignment(horizontalAlignment);
        }
        if ((verticalAlignment = VerticalAlignEnum.getByName(atts.getValue("verticalAlignment"))) != null) {
            textElement.setVerticalAlignment(verticalAlignment);
        }
        if ((rotation = RotationEnum.getByName(atts.getValue("rotation"))) != null) {
            textElement.setRotation(rotation);
        }
        if ((lineSpacing = LineSpacingEnum.getByName(atts.getValue("lineSpacing"))) != null) {
            textElement.setLineSpacing(lineSpacing);
        }
        textElement.setMarkup(atts.getValue("markup"));
        String isStyledText = atts.getValue("isStyledText");
        if (isStyledText != null && isStyledText.length() > 0) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"The 'isStyledText' attribute is deprecated. Use the 'markup' attribute instead.");
            }
            textElement.setMarkup(Boolean.valueOf(isStyledText) != false ? "styled" : "none");
        }
        return textElement;
    }
}

