/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerUtilsConstants;

public final class TokenIdImpl
implements TokenId {
    private final String name;
    private final int ordinal;
    private final String primaryCategory;

    public TokenIdImpl(String string, int n, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("ordinal=" + n + " of token=" + string + " cannot be < 0");
        }
        this.name = string;
        this.ordinal = n;
        this.primaryCategory = string2;
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public String toString() {
        return LexerUtilsConstants.idToString(this);
    }

    public String toStringDetail() {
        return this.name() + "[" + this.ordinal() + (this.primaryCategory != null ? ", \"" + this.primaryCategory + "\"" : "") + "]";
    }
}

