/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.lib2.EditorImplementation;
import org.netbeans.spi.editor.EditorImplementationProvider;

public abstract class ImplementationProvider {
    private static final ImplementationProvider PROVIDER = new ProviderBridge();

    public static ImplementationProvider getDefault() {
        return PROVIDER;
    }

    public static void registerDefault(ImplementationProvider implementationProvider) {
        EditorImplementation.getDefault().setExternalProvider((EditorImplementationProvider)new Wrapper(implementationProvider));
    }

    public abstract ResourceBundle getResourceBundle(String var1);

    public abstract Action[] getGlyphGutterActions(JTextComponent var1);

    public boolean activateComponent(JTextComponent jTextComponent) {
        return false;
    }

    private static final class Wrapper
    implements EditorImplementationProvider {
        private ImplementationProvider origProvider;

        public Wrapper(ImplementationProvider implementationProvider) {
            this.origProvider = implementationProvider;
        }

        public ResourceBundle getResourceBundle(String string) {
            return this.origProvider.getResourceBundle(string);
        }

        public Action[] getGlyphGutterActions(JTextComponent jTextComponent) {
            return this.origProvider.getGlyphGutterActions(jTextComponent);
        }

        public boolean activateComponent(JTextComponent jTextComponent) {
            return this.origProvider.activateComponent(jTextComponent);
        }
    }

    private static final class ProviderBridge
    extends ImplementationProvider {
        private ProviderBridge() {
        }

        public ResourceBundle getResourceBundle(String string) {
            return EditorImplementation.getDefault().getResourceBundle(string);
        }

        public Action[] getGlyphGutterActions(JTextComponent jTextComponent) {
            return EditorImplementation.getDefault().getGlyphGutterActions(jTextComponent);
        }

        public boolean activateComponent(JTextComponent jTextComponent) {
            return EditorImplementation.getDefault().activateComponent(jTextComponent);
        }
    }
}

