/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.nodes.FolderNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitInputControlsNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitResourcesNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.ireport.jasperserver.ui.resources.DataSourceDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.DataTypeDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.InputControlDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.ListOfValuesDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.NewResourceDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.QueryDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.ResourceReferenceDialog;
import com.jaspersoft.ireport.jasperserver.ui.resources.XMLAConnectionDialog;
import com.jaspersoft.ireport.jasperserver.ui.wizards.ReportUnitWizardDescriptor;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AddResourceAction
extends NodeAction {
    JMenu jMenuAdd = null;
    JSeparator jSeparator1 = null;
    JSeparator jSeparator2 = null;
    JSeparator jSeparator3 = null;
    JSeparator jSeparator4 = null;
    JMenuItem jMenuItemReportUnit = null;
    JMenuItem jMenuItemFolder = null;
    JMenuItem jMenuItemReference = null;
    JMenuItem jMenuItemImage = null;
    JMenuItem jMenuItemBundle = null;
    JMenuItem jMenuItemJrxml = null;
    JMenuItem jMenuItemJar = null;
    JMenuItem jMenuItemFont = null;
    JMenuItem jMenuItemStyleTemplate = null;
    JMenuItem jMenuItemDatasource = null;
    JMenuItem jMenuItemXMLADatasource = null;
    JMenuItem jMenuItemDataType = null;
    JMenuItem jMenuItemListOfValues = null;
    JMenuItem jMenuItemQuery = null;
    JMenuItem jMenuItemInputControl = null;

    public String getName() {
        return NbBundle.getMessage(AddResourceAction.class, (String)"CTL_PropertiesAction");
    }

    public JMenuItem getPopupPresenter() {
        if (this.jMenuAdd == null) {
            this.initMenu();
        }
        this.jMenuItemReference.setEnabled(this.getActivatedNodes()[0] instanceof ReportUnitNode || this.getActivatedNodes()[0] instanceof ReportUnitInputControlsNode || this.getActivatedNodes()[0] instanceof ReportUnitResourcesNode);
        this.jMenuItemReportUnit.setEnabled(this.getActivatedNodes()[0] instanceof FolderNode);
        this.jMenuItemFolder.setEnabled(this.getActivatedNodes()[0] instanceof FolderNode);
        this.jMenuItemDatasource.setEnabled(this.getActivatedNodes()[0] instanceof FolderNode);
        this.jMenuItemXMLADatasource.setEnabled(this.getActivatedNodes()[0] instanceof FolderNode);
        this.jMenuItemDataType.setEnabled(this.getActivatedNodes()[0] instanceof FolderNode);
        this.jMenuItemListOfValues.setEnabled(this.getActivatedNodes()[0] instanceof FolderNode);
        return this.jMenuAdd;
    }

    public void initMenu() {
        this.jMenuAdd = new JMenu();
        this.jMenuAdd.setText(JasperServerManager.getString("menu.add", "Add"));
        this.jMenuItemReportUnit = new JMenuItem();
        this.jMenuItemReportUnit.setText(JasperServerManager.getString("menu.reportUnit", "Report Unit"));
        this.jMenuItemReportUnit.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/reportunit.png")));
        this.jMenuItemReportUnit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("reportUnit");
            }
        });
        this.jMenuAdd.add(this.jMenuItemReportUnit);
        this.jSeparator1 = new JSeparator();
        this.jMenuAdd.add(this.jSeparator1);
        this.jMenuItemFolder = new JMenuItem();
        this.jMenuItemFolder.setText(JasperServerManager.getString("menu.folder", "Folder"));
        this.jMenuItemFolder.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/folder.png")));
        this.jMenuItemFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("folder");
            }
        });
        this.jMenuAdd.add(this.jMenuItemFolder);
        this.jMenuItemReference = new JMenuItem();
        this.jMenuItemReference.setText(JasperServerManager.getString("menu.reference", "Reference"));
        this.jMenuItemReference.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/link.png")));
        this.jMenuItemReference.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("reference");
            }
        });
        this.jMenuAdd.add(this.jMenuItemReference);
        this.jSeparator2 = new JSeparator();
        this.jMenuAdd.add(this.jSeparator2);
        this.jMenuItemImage = new JMenuItem();
        this.jMenuItemImage.setText(JasperServerManager.getString("menu.image", "Image"));
        this.jMenuItemImage.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/picture.png")));
        this.jMenuItemImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("img");
            }
        });
        this.jMenuAdd.add(this.jMenuItemImage);
        this.jMenuItemBundle = new JMenuItem();
        this.jMenuItemBundle.setText(JasperServerManager.getString("menu.bundle", "Resource bundle"));
        this.jMenuItemBundle.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/bundle.png")));
        this.jMenuItemBundle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("prop");
            }
        });
        this.jMenuAdd.add(this.jMenuItemBundle);
        this.jMenuItemJrxml = new JMenuItem();
        this.jMenuItemJrxml.setText(JasperServerManager.getString("menu.Jrxml", "JRXML document"));
        this.jMenuItemJrxml.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/jrxml_file.png")));
        this.jMenuItemJrxml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("jrxml");
            }
        });
        this.jMenuAdd.add(this.jMenuItemJrxml);
        this.jMenuItemJar = new JMenuItem();
        this.jMenuItemJar.setText(JasperServerManager.getString("menu.jar", "Jar archive"));
        this.jMenuItemJar.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/jar.png")));
        this.jMenuItemJar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("jar");
            }
        });
        this.jMenuAdd.add(this.jMenuItemJar);
        this.jMenuItemFont = new JMenuItem();
        this.jMenuItemFont.setText(JasperServerManager.getString("menu.font", "Font file"));
        this.jMenuItemFont.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/font.png")));
        this.jMenuItemFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("font");
            }
        });
        this.jMenuAdd.add(this.jMenuItemFont);
        this.jMenuItemStyleTemplate = new JMenuItem();
        this.jMenuItemStyleTemplate.setText(JasperServerManager.getString("menu.styleTemplate", "Style Template"));
        this.jMenuItemStyleTemplate.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/style-16.png")));
        this.jMenuItemStyleTemplate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("jrtx");
            }
        });
        this.jMenuAdd.add(this.jMenuItemStyleTemplate);
        this.jSeparator3 = new JSeparator();
        this.jMenuAdd.add(this.jSeparator3);
        this.jMenuItemDatasource = new JMenuItem();
        this.jMenuItemDatasource.setText(JasperServerManager.getString("menu.datasource", "Datasource"));
        this.jMenuItemDatasource.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource.png")));
        this.jMenuItemDatasource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("datasource");
            }
        });
        this.jMenuAdd.add(this.jMenuItemDatasource);
        this.jMenuItemXMLADatasource = new JMenuItem();
        this.jMenuItemXMLADatasource.setText(JasperServerManager.getString("menu.xmlaConnection", "XMLA Connection"));
        this.jMenuItemXMLADatasource.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datasource.png")));
        this.jMenuItemXMLADatasource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("olapXmlaCon");
            }
        });
        this.jMenuAdd.add(this.jMenuItemXMLADatasource);
        this.jSeparator4 = new JSeparator();
        this.jMenuAdd.add(this.jSeparator4);
        this.jMenuItemDataType = new JMenuItem();
        this.jMenuItemDataType.setText(JasperServerManager.getString("menu.dataType", "Datatype"));
        this.jMenuItemDataType.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/datatype.png")));
        this.jMenuItemDataType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("dataType");
            }
        });
        this.jMenuAdd.add(this.jMenuItemDataType);
        this.jMenuItemListOfValues = new JMenuItem();
        this.jMenuItemListOfValues.setText(JasperServerManager.getString("menu.listOfValues", "List of values"));
        this.jMenuItemListOfValues.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/lov.png")));
        this.jMenuItemListOfValues.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("lov");
            }
        });
        this.jMenuAdd.add(this.jMenuItemListOfValues);
        this.jMenuItemQuery = new JMenuItem();
        this.jMenuItemQuery.setText(JasperServerManager.getString("menu.query", "Query"));
        this.jMenuItemQuery.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/query.png")));
        this.jMenuItemQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("query");
            }
        });
        this.jMenuAdd.add(this.jMenuItemQuery);
        this.jMenuItemInputControl = new JMenuItem();
        this.jMenuItemInputControl.setText(JasperServerManager.getString("menu.inputControl", "Input control"));
        this.jMenuItemInputControl.setIcon(new ImageIcon(AddResourceAction.class.getResource("/com/jaspersoft/ireport/jasperserver/res/inputcontrol.png")));
        this.jMenuItemInputControl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddResourceAction.this.addResource("inputControl");
            }
        });
        this.jMenuAdd.add(this.jMenuItemInputControl);
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof ResourceNode;
    }

    protected void addChild(ResourceNode parentNode, JServer server, ResourceDescriptor newResourceDescriptor) {
        RepositoryFolder obj = RepositoryFolder.createRepositoryObject(server, newResourceDescriptor);
        if (parentNode.getRepositoryObject().isLoaded()) {
            parentNode.getResourceDescriptor().getChildren().add(newResourceDescriptor);
            parentNode.getRepositoryObject().getChildren().add(obj);
            parentNode.refreshChildrens(false);
        }
    }

    protected void addResource(String resourceType) {
        Node[] activatedNodes = this.getActivatedNodes();
        if (activatedNodes == null || activatedNodes.length != 1 || !(activatedNodes[0] instanceof ResourceNode)) {
            return;
        }
        ResourceNode selectedNode = (ResourceNode)activatedNodes[0];
        this.addResource(selectedNode, resourceType);
    }

    public void addResource(ResourceNode selectedNode, String resourceType) {
        JServer server = null;
        String currentUri = "/";
        String reportUnitUri = null;
        boolean parentLoaded = false;
        RepositoryFolder rf = selectedNode.getRepositoryObject();
        server = rf.getServer();
        currentUri = rf.getDescriptor().getUriString();
        if (rf instanceof RepositoryReportUnit) {
            reportUnitUri = currentUri;
        }
        parentLoaded = rf.isLoaded();
        if (resourceType.equals("reportUnit")) {
            ResourceDescriptor rd;
            ArrayList datasources = null;
            if (JasperServerManager.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                try {
                    datasources = server.getWSClient().listDatasources();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (datasources == null) {
                datasources = new ArrayList();
            }
            ReportUnitWizardDescriptor wizardDescriptor = new ReportUnitWizardDescriptor();
            wizardDescriptor.setParentFolder(currentUri);
            wizardDescriptor.setDatasources(datasources);
            wizardDescriptor.setServer(server);
            if (wizardDescriptor.runWizard() && (rd = wizardDescriptor.getNewResourceDescriptor()) != null) {
                this.addChild(selectedNode, server, rd);
            }
        } else if (resourceType.equals("datasource")) {
            DataSourceDialog nrd = new DataSourceDialog(Misc.getMainFrame(), true);
            nrd.setParentFolder(currentUri);
            nrd.setServer(server);
            nrd.setVisible(true);
            if (nrd.getDialogResult() == 0) {
                this.addChild(selectedNode, server, nrd.getNewResourceDescriptor());
            }
        } else if (resourceType.equals("olapXmlaCon")) {
            XMLAConnectionDialog nrd = new XMLAConnectionDialog(Misc.getMainFrame(), true);
            nrd.setParentFolder(currentUri);
            nrd.setServer(server);
            nrd.setVisible(true);
            if (nrd.getDialogResult() == 0) {
                this.addChild(selectedNode, server, nrd.getNewResourceDescriptor());
            }
        } else if (resourceType.equals("reference")) {
            ResourceReferenceDialog rrd = new ResourceReferenceDialog(Misc.getMainFrame(), true);
            rrd.setServer(server);
            rrd.setParentFolder(currentUri);
            rrd.setVisible(true);
            if (rrd.getDialogResult() == 0) {
                this.addChild(selectedNode, server, rrd.getNewResourceDescriptor());
            }
        } else if (resourceType.equals("dataType")) {
            DataTypeDialog nrd = new DataTypeDialog(Misc.getMainFrame(), true);
            nrd.setParentFolder(currentUri);
            nrd.setServer(server);
            nrd.setVisible(true);
            if (nrd.getDialogResult() == 0) {
                this.addChild(selectedNode, server, nrd.getNewResourceDescriptor());
            }
        } else if (resourceType.equals("lov")) {
            ListOfValuesDialog nrd = new ListOfValuesDialog(Misc.getMainFrame(), true);
            nrd.setParentFolder(currentUri);
            nrd.setServer(server);
            nrd.setVisible(true);
            if (nrd.getDialogResult() == 0) {
                this.addChild(selectedNode, server, nrd.getNewResourceDescriptor());
            }
        } else if (resourceType.equals("query")) {
            QueryDialog nrd = new QueryDialog(Misc.getMainFrame(), true);
            nrd.setParentFolder(currentUri);
            nrd.setServer(server);
            if (JasperServerManager.getMainInstance().getBrandingProperties().getProperty("ireport.manage.datasources.enabled", "true").equals("true")) {
                List datasources = null;
                try {
                    datasources = server.getWSClient().listDatasources();
                    nrd.setDatasources(datasources);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("repositoryExplorer.message.errorListingDatasources", "Error getting the list of available datasources:\n{0}", new Object[]{ex.getMessage()}));
                    ex.printStackTrace();
                }
            }
            nrd.setVisible(true);
            if (nrd.getDialogResult() == 0) {
                this.addChild(selectedNode, server, nrd.getNewResourceDescriptor());
            }
        } else if (resourceType.equals("inputControl")) {
            InputControlDialog nrd = new InputControlDialog(Misc.getMainFrame(), true);
            nrd.setParentFolder(currentUri);
            nrd.setServer(server);
            nrd.setReportUnitUri(reportUnitUri);
            nrd.setVisible(true);
            if (nrd.getDialogResult() == 0) {
                this.addChild(selectedNode, server, nrd.getNewResourceDescriptor());
            }
        } else {
            NewResourceDialog nrd = new NewResourceDialog(Misc.getMainFrame(), true);
            nrd.setParentUri(currentUri);
            nrd.setServer(server);
            nrd.setReportUnitUri(reportUnitUri);
            nrd.setResourceType(resourceType);
            nrd.setVisible(true);
            if (nrd.getDialogResult() == 0) {
                this.addChild(selectedNode, server, nrd.getNewResourceDescriptor());
            }
        }
    }
}

