/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.nodes;

import com.jaspersoft.ireport.components.table.TableElementNode;
import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnEndAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnGroupAction;
import com.jaspersoft.ireport.components.table.actions.AddTableColumnStartAction;
import com.jaspersoft.ireport.components.table.actions.DeleteTableColumnAction;
import com.jaspersoft.ireport.components.table.nodes.TableColumnGroupChildren;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TableColumnGroupNode
extends IRAbstractNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRDesignComponentElement tableElement = null;
    private StandardColumnGroup columnGroup = null;
    private Object parent = null;
    private byte section = 0;
    private JRDesignGroup group = null;

    public TableColumnGroupNode(JasperDesign jd, JRDesignComponentElement tableElement, StandardColumnGroup columnGroup, Object parent, byte section, JRDesignGroup group, Lookup doLkp) {
        super((Children)new TableColumnGroupChildren(jd, tableElement, columnGroup, section, group, doLkp), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, tableElement, columnGroup, parent})}));
        this.jd = jd;
        this.columnGroup = columnGroup;
        this.tableElement = tableElement;
        this.parent = parent;
        this.section = section;
        this.group = group;
        this.setIconBaseWithExtension("com/jaspersoft/ireport/components/table/columngroup.png");
        this.setName("columnGroup");
        columnGroup.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        int index = TableModelUtils.getColumnIndex(this.getTable(), (BaseColumn)this.getColumnGroup());
        return NbBundle.getMessage(TableElementNode.class, (String)"table.columnGroup.name", (Object)(index + 1), (Object)(index + TableModelUtils.getColSpan(this.columnGroup)));
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public void destroy() throws IOException {
        if (this.parent instanceof StandardTable) {
            ((StandardTable)this.parent).removeColumn((BaseColumn)this.getColumnGroup());
        }
        if (this.parent instanceof StandardColumnGroup) {
            ((StandardColumnGroup)this.parent).removeColumn((BaseColumn)this.getColumnGroup());
        }
        super.destroy();
    }

    public boolean canDestroy() {
        if (this.parent instanceof StandardTable) {
            return ((StandardTable)this.parent).getColumns().size() > 1;
        }
        if (this.parent instanceof StandardColumnGroup) {
            return ((StandardColumnGroup)this.parent).getColumns().size() > 1;
        }
        return false;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(AddTableColumnStartAction.class), SystemAction.get(AddTableColumnEndAction.class), SystemAction.get(AddTableColumnGroupAction.class), SystemAction.get(DeleteTableColumnAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (ModelUtils.containsProperty((Node.PropertySet[])this.getPropertySets(), (String)evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public JRDesignComponentElement getComponentElement() {
        return this.tableElement;
    }

    public StandardTable getTable() {
        return (StandardTable)this.getComponentElement().getComponent();
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public StandardColumnGroup getColumnGroup() {
        return this.columnGroup;
    }

    public PasteType getDropType(Transferable t, int action, final int index) {
        BaseColumn column;
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction((Transferable)t);
        if (null != dropNode && index >= 0 && null != (column = (BaseColumn)dropNode.getLookup().lookup(BaseColumn.class))) {
            final TableMatrix matrix = new TableMatrix(this.getJasperDesign(), this.getTable());
            if (matrix.getColumnIndex(column) < 0) {
                return null;
            }
            return new PasteType(){

                public Transferable paste() throws IOException {
                    matrix.moveColumn(column, TableColumnGroupNode.this.getTable(), index);
                    return null;
                }
            };
        }
        return null;
    }
}

