/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.components.table.nodes.TableCellNode;
import com.jaspersoft.ireport.components.table.undo.DeleteTableCellUndoableEdit;
import com.jaspersoft.ireport.components.table.undo.DeleteTableColumnUndoableEdit;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Image;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class DeleteTableCellAction
extends NodeAction {
    private static DeleteTableCellAction instance = null;

    public static synchronized DeleteTableCellAction getInstance() {
        if (instance == null) {
            instance = new DeleteTableCellAction();
        }
        return instance;
    }

    private DeleteTableCellAction() {
    }

    public String getName() {
        return NbBundle.getMessage(DeleteTableCellAction.class, (String)"DeleteTableCellAction.Name.CTL_DeleteTableCellAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (!(activatedNodes[i] instanceof TableCellNode)) continue;
            TableCellNode cellNode = (TableCellNode)activatedNodes[i];
            StandardTable table = cellNode.getTable();
            JasperDesign jd = cellNode.getJasperDesign();
            BaseColumn column = cellNode.getColumn();
            TableMatrix matrix = TableModelUtils.createTableMatrix(cellNode.getTable(), cellNode.getJasperDesign());
            Object parentGroup = matrix.getColumnParent(column);
            DesignCell cell = cellNode.getCell();
            if (column instanceof StandardColumn) {
                int cells = 0;
                if (((StandardColumn)column).getTableHeader() != null) {
                    ++cells;
                }
                if (((StandardColumn)column).getTableFooter() != null) {
                    ++cells;
                }
                if (((StandardColumn)column).getColumnHeader() != null) {
                    ++cells;
                }
                if (((StandardColumn)column).getColumnFooter() != null) {
                    ++cells;
                }
                if (((StandardColumn)column).getDetailCell() != null) {
                    ++cells;
                }
                for (GroupCell groupCell : ((StandardColumn)column).getGroupHeaders()) {
                    if (groupCell.getCell() == null) continue;
                    ++cells;
                }
                for (GroupCell groupCell : ((StandardColumn)column).getGroupFooters()) {
                    if (groupCell.getCell() == null) continue;
                    ++cells;
                }
                if (cells == 1) {
                    if (matrix.getStandardColumns().size() == 1) {
                        JOptionPane.showMessageDialog(Misc.getMainFrame(), "This is the only cell of a detail column in the table, and it cannot be removed.", "Cannot delete cell", 2);
                        return;
                    }
                    if (TableModelUtils.getColumns(parentGroup).size() == 1 && JOptionPane.showConfirmDialog(Misc.getMainFrame(), "You are deleting the only cell available in this column and the column will be removed.\nAll the headers of the groups having only this detail column as child will be removed as well.\n\n\nContinue anyway?", "Deleting Column Group", 1, 2, ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"com/jaspersoft/ireport/components/table/deleting_group.png"))) != 0) {
                        return;
                    }
                    int position = TableModelUtils.getColumns(parentGroup).indexOf(column);
                    TableModelUtils.removeColumn(parentGroup, column, position);
                    DeleteTableColumnUndoableEdit edit = new DeleteTableColumnUndoableEdit(table, jd, column, parentGroup, position);
                    List oldColumns = TableModelUtils.getColumns(parentGroup);
                    while (oldColumns.size() == 0 && parentGroup instanceof StandardColumnGroup) {
                        Object oldParentParent = matrix.getColumnParent((BaseColumn)((StandardColumnGroup)parentGroup));
                        if (oldParentParent == null) continue;
                        if (oldParentParent instanceof StandardTable) {
                            position = ((StandardTable)oldParentParent).getColumns().indexOf((StandardColumnGroup)parentGroup);
                            ((StandardTable)oldParentParent).removeColumn((BaseColumn)((StandardColumnGroup)parentGroup));
                            edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(table, jd, (BaseColumn)((StandardColumnGroup)parentGroup), oldParentParent, position)));
                            oldColumns = ((StandardTable)oldParentParent).getColumns();
                            parentGroup = oldParentParent;
                            continue;
                        }
                        position = ((StandardColumnGroup)oldParentParent).getColumns().indexOf((StandardColumnGroup)parentGroup);
                        ((StandardColumnGroup)oldParentParent).removeColumn((BaseColumn)((StandardColumnGroup)parentGroup));
                        edit.concatenate((UndoableEdit)((Object)new DeleteTableColumnUndoableEdit(table, jd, (BaseColumn)((StandardColumnGroup)parentGroup), oldParentParent, position)));
                        oldColumns = ((StandardColumnGroup)oldParentParent).getColumns();
                        parentGroup = oldParentParent;
                    }
                    edit.setPresentationName("Remove Cell");
                    IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)edit));
                    TableModelUtils.fixTableLayout(table, jd);
                    return;
                }
            }
            TableModelUtils.removeCell(cellNode.getColumn(), cellNode.getSection(), cellNode.getGroup() != null ? cellNode.getGroup().getName() : null);
            DeleteTableCellUndoableEdit edit = new DeleteTableCellUndoableEdit(table, jd, cell, cellNode.getColumn(), cellNode.getSection(), cellNode.getGroup());
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)((Object)edit));
            TableModelUtils.fixTableLayout(table, jd);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof TableCellNode) continue;
            return false;
        }
        return true;
    }
}

