/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.barcode.barcode4j;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.FourStateBarcodeComponent;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import org.openide.nodes.PropertySupport;

public final class Barcode4JChecksumModeProperty
extends PropertySupport {
    private BarcodeComponent component;
    private ComboBoxPropertyEditor editor;

    public Barcode4JChecksumModeProperty(BarcodeComponent component) {
        super("checksumMode", String.class, I18n.getString((String)"barcode4j.property.checksumMode.name"), I18n.getString((String)"barcode4j.property.checksumMode.description"), true, true);
        this.component = component;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new ComboBoxPropertyEditor(false, (List)this.getListOfTags());
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.getChecksumMode();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof String) {
            String oldValue = this.getChecksumMode();
            String newValue = (String)val;
            this.setChecksumMode(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit((Object)this.component, "ChecksumMode", String.class, (Object)oldValue, (Object)newValue);
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)urob);
        }
    }

    private ArrayList getListOfTags() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag(null, "<default>"));
        tags.add(new Tag((Object)"auto", "Auto"));
        tags.add(new Tag((Object)"ignore", "Ignore"));
        tags.add(new Tag((Object)"add", "Add"));
        tags.add(new Tag((Object)"check", "Check"));
        return tags;
    }

    private String getChecksumMode() {
        if (this.component instanceof EAN128Component) {
            return ((EAN128Component)this.component).getChecksumMode();
        }
        if (this.component instanceof FourStateBarcodeComponent) {
            return ((FourStateBarcodeComponent)this.component).getChecksumMode();
        }
        if (this.component instanceof Code39Component) {
            return ((Code39Component)this.component).getChecksumMode();
        }
        if (this.component instanceof Interleaved2Of5Component) {
            return ((Interleaved2Of5Component)this.component).getChecksumMode();
        }
        if (this.component instanceof UPCAComponent) {
            return ((UPCAComponent)this.component).getChecksumMode();
        }
        if (this.component instanceof UPCEComponent) {
            return ((UPCEComponent)this.component).getChecksumMode();
        }
        if (this.component instanceof EAN13Component) {
            return ((EAN13Component)this.component).getChecksumMode();
        }
        if (this.component instanceof EAN8Component) {
            return ((EAN8Component)this.component).getChecksumMode();
        }
        if (this.component instanceof POSTNETComponent) {
            return ((POSTNETComponent)this.component).getChecksumMode();
        }
        return null;
    }

    private void setChecksumMode(String s) {
        if (this.component instanceof EAN128Component) {
            ((EAN128Component)this.component).setChecksumMode(s);
        } else if (this.component instanceof FourStateBarcodeComponent) {
            ((FourStateBarcodeComponent)this.component).setChecksumMode(s);
        } else if (this.component instanceof Code39Component) {
            ((Code39Component)this.component).setChecksumMode(s);
        } else if (this.component instanceof Interleaved2Of5Component) {
            ((Interleaved2Of5Component)this.component).setChecksumMode(s);
        } else if (this.component instanceof UPCAComponent) {
            ((UPCAComponent)this.component).setChecksumMode(s);
        } else if (this.component instanceof UPCEComponent) {
            ((UPCEComponent)this.component).setChecksumMode(s);
        } else if (this.component instanceof EAN13Component) {
            ((EAN13Component)this.component).setChecksumMode(s);
        } else if (this.component instanceof EAN8Component) {
            ((EAN8Component)this.component).setChecksumMode(s);
        } else if (this.component instanceof POSTNETComponent) {
            ((POSTNETComponent)this.component).setChecksumMode(s);
        }
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.getChecksumMode() == null;
    }
}

