/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.addons.layers;

import com.jaspersoft.ireport.addons.layers.Layer;
import com.jaspersoft.ireport.addons.layers.LayersListPanel;
import com.jaspersoft.ireport.addons.layers.LayersSupport;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.util.NbBundle;

public class LayerItemPanel
extends JPanel {
    public static final String PROPERTY_SELECTED = "PROPERTY_SELECTED";
    private boolean editing = false;
    private boolean selected = false;
    private boolean updatingUI = false;
    private Layer layer = null;
    private JCheckBox jCheckBox1;
    private JMenuItem jMenuDeleteLayer;
    private JMenuItem jMenuItemMergeDown;
    private JMenuItem jMenuItemPrintWhenExpression;
    private JMenuItem jMenuItemSelectLayerElements;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenu1;
    private JSeparator jSeparator1;
    private JTextField jTextField1;

    public LayerItemPanel() {
        this.initComponents();
    }

    public Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        d.height = this.getPreferredSize().width;
        return d;
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItemPrintWhenExpression = new JMenuItem();
        this.jMenuItemSelectLayerElements = new JMenuItem();
        this.jMenuItemMergeDown = new JMenuItem();
        this.jMenuDeleteLayer = new JMenuItem();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemPrintWhenExpression.setText(NbBundle.getMessage(LayerItemPanel.class, (String)"LayerItemPanel.jMenuItemPrintWhenExpression.text"));
        this.jMenuItemPrintWhenExpression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerItemPanel.this.jMenuItemPrintWhenExpressionActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemPrintWhenExpression);
        this.jMenuItemSelectLayerElements.setText(NbBundle.getMessage(LayerItemPanel.class, (String)"LayerItemPanel.jMenuItemSelectLayerElements.text"));
        this.jMenuItemSelectLayerElements.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerItemPanel.this.jMenuItemSelectLayerElementsActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemSelectLayerElements);
        this.jMenuItemMergeDown.setText(NbBundle.getMessage(LayerItemPanel.class, (String)"LayerItemPanel.jMenuItemMergeDown.text"));
        this.jMenuItemMergeDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerItemPanel.this.jMenuItemMergeDownActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItemMergeDown);
        this.jMenuDeleteLayer.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/addons/layers/delete.gif")));
        this.jMenuDeleteLayer.setText(NbBundle.getMessage(LayerItemPanel.class, (String)"LayerItemPanel.jMenuDeleteLayer.text"));
        this.jMenuDeleteLayer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerItemPanel.this.jMenuDeleteLayerActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuDeleteLayer);
        this.setLayout(new GridBagLayout());
        this.jCheckBox1.setText(NbBundle.getMessage(LayerItemPanel.class, (String)"LayerItemPanel.jCheckBox1.text"));
        this.jCheckBox1.setDisabledIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/addons/layers/always_visible.png")));
        this.jCheckBox1.setDisabledSelectedIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/addons/layers/always_visible.png")));
        this.jCheckBox1.setFocusPainted(false);
        this.jCheckBox1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/addons/layers/not_visible.png")));
        this.jCheckBox1.setPreferredSize(new Dimension(22, 22));
        this.jCheckBox1.setSelectedIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/addons/layers/visible.png")));
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerItemPanel.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.add((Component)this.jCheckBox1, new GridBagConstraints());
        this.jPanel1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LayerItemPanel.this.jPanel1MouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                LayerItemPanel.this.jPanel1MousePressed(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jTextField1.setEditable(false);
        this.jTextField1.setText(NbBundle.getMessage(LayerItemPanel.class, (String)"LayerItemPanel.jTextField1.text"));
        this.jTextField1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jTextField1.setOpaque(false);
        this.jTextField1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LayerItemPanel.this.jTextField1MouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                LayerItemPanel.this.jTextField1MousePressed(evt);
            }
        });
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LayerItemPanel.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jTextField1.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                LayerItemPanel.this.jTextField1FocusLost(evt);
            }
        });
        this.jTextField1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                LayerItemPanel.this.jTextField1KeyPressed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.jPanel1.add((Component)this.jTextField1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jSeparator1.setPreferredSize(new Dimension(1, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jSeparator1, gridBagConstraints);
    }

    private void jTextField1MouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2) {
            this.setEditing(true);
        }
    }

    private void jTextField1FocusLost(FocusEvent evt) {
        this.setEditing(false);
    }

    private void jTextField1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.setEditing(false);
        }
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    private void jPanel1MouseClicked(MouseEvent evt) {
    }

    private void jPanel1MousePressed(MouseEvent evt) {
        this.jTextField1MousePressed(evt);
    }

    private void jTextField1MousePressed(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt)) {
            if (this.getParent() instanceof LayersListPanel) {
                evt.setSource(this);
                ((LayersListPanel)this.getParent()).itemMousePressed(evt);
            }
        } else if (SwingUtilities.isRightMouseButton(evt) && !this.editing) {
            Object source = evt.getSource();
            evt.setSource(this);
            ((LayersListPanel)this.getParent()).itemMousePressed(evt);
            evt.setSource(source);
            this.jMenuDeleteLayer.setEnabled(!this.getLayer().isBackgroundLayer());
            this.jMenuItemMergeDown.setEnabled(!this.getLayer().isBackgroundLayer());
            this.jMenuItemPrintWhenExpression.setEnabled(!this.getLayer().isBackgroundLayer());
            this.jPopupMenu1.show((JComponent)evt.getSource(), evt.getPoint().x, evt.getPoint().y);
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.getLayer() != null) {
            this.getLayer().setVisible(this.jCheckBox1.isSelected());
        }
    }

    private void jMenuDeleteLayerActionPerformed(ActionEvent evt) {
        LayersSupport.getInstance().removeLayer(this.getLayer());
    }

    private void jMenuItemSelectLayerElementsActionPerformed(ActionEvent evt) {
        List<JRDesignElement> elements = LayersSupport.getInstance().getLayerElements(this.getLayer());
        ReportObjectScene scene = LayersSupport.getInstance().getScene();
        HashSet<JRDesignElement> set = new HashSet<JRDesignElement>();
        set.addAll(elements);
        scene.setSelectedObjects(set);
        scene.revalidate();
        scene.validate();
    }

    private void jMenuItemMergeDownActionPerformed(ActionEvent evt) {
        int index = LayersSupport.getInstance().getLayers().indexOf(this.getLayer());
        if (index > 0) {
            Layer newLayer = LayersSupport.getInstance().getLayers().get(index - 1);
            List<JRDesignElement> elements = LayersSupport.getInstance().getLayerElements(this.getLayer());
            for (JRDesignElement element : elements) {
                LayersSupport.getInstance().addElementToLayer(element, newLayer);
            }
            LayersSupport.getInstance().updateAllLayers();
            LayersSupport.getInstance().removeLayer(this.getLayer());
        }
    }

    private void jMenuItemPrintWhenExpressionActionPerformed(ActionEvent evt) {
        ExpressionEditor editor = new ExpressionEditor();
        List<JRDesignElement> elements = LayersSupport.getInstance().getLayerElements(this.getLayer());
        JRDesignDataset dataset = null;
        for (JRDesignElement element : elements) {
            JRDesignDataset ds = ModelUtils.getElementDataset((JRDesignElement)element, (JasperDesign)LayersSupport.getInstance().getJasperDesign());
            if (dataset == null) {
                dataset = ds;
                continue;
            }
            if (dataset == ds) continue;
            dataset = null;
            break;
        }
        if (dataset != null) {
            editor.setExpressionContext(new ExpressionContext(dataset));
        }
        editor.setExpression(Misc.nvl((Object)this.getLayer().getPrintWhenExpression(), (String)""));
        if (editor.showDialog((Component)Misc.getMainFrame()) == 0) {
            this.layer.setPrintWhenExpression(editor.getExpression());
            JRDesignExpression newExp = Misc.createExpression((String)"java.lang.Boolean", (String)editor.getExpression());
            for (JRDesignElement element : elements) {
                element.setPrintWhenExpression((JRExpression)newExp);
            }
            IReportManager.getInstance().notifyReportChange();
        }
    }

    public void setEditing(boolean b) {
        if (this.editing == b || this.getLayer().isBackgroundLayer()) {
            return;
        }
        this.editing = b;
        if (this.editing) {
            this.jTextField1.setBorder(new LineBorder(Color.BLACK));
            this.jTextField1.setOpaque(true);
            this.jTextField1.setEditable(true);
            this.jTextField1.selectAll();
            this.jTextField1.requestFocusInWindow();
            this.jTextField1.setForeground(UIManager.getColor("List.foreground"));
        } else {
            String s = this.jTextField1.getText();
            if (s.trim().length() > 0 && this.getLayer() != null) {
                this.updatingUI = true;
                this.getLayer().setName(s);
                this.updatingUI = false;
            }
            this.jTextField1.setEditable(false);
            this.jTextField1.setOpaque(false);
            this.jTextField1.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
            this.jTextField1.setForeground(UIManager.getColor("List.selectionForeground"));
        }
    }

    public void setSelected(boolean b) {
        if (this.selected == b) {
            return;
        }
        this.selected = b;
        if (!this.selected) {
            this.setEditing(false);
            this.jPanel1.setBackground(UIManager.getColor("Label.background"));
            this.jTextField1.setForeground(UIManager.getColor("List.foreground"));
            this.jTextField1.setSelectionStart(0);
            this.jTextField1.setSelectionEnd(0);
        } else {
            this.jPanel1.setBackground(UIManager.getColor("List.selectionBackground"));
            this.jTextField1.setForeground(UIManager.getColor("List.selectionForeground"));
        }
        this.firePropertyChange(PROPERTY_SELECTED, !this.selected, this.selected);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        this.jTextField1.setText(layer.getName());
        this.jCheckBox1.setSelected(layer.isVisible());
        if (layer.isBackgroundLayer()) {
            this.jCheckBox1.setEnabled(false);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }
}

