/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFontInfo;

public class XlsxFontHelper
extends BaseHelper {
    private Map fontCache = new HashMap();

    public XlsxFontHelper(Writer writer) {
        super(writer);
    }

    public int getFont(JRExporterGridCell gridCell) {
        return this.getFont(gridCell, false);
    }

    public int getFont(JRExporterGridCell gridCell, boolean isFontSizeFixEnabled) {
        JRFont font;
        JRFont jRFont = font = gridCell.getElement() instanceof JRFont ? (JRFont)((Object)gridCell.getElement()) : null;
        if (font == null) {
            return -1;
        }
        XlsxFontInfo fontInfo = new XlsxFontInfo(gridCell, isFontSizeFixEnabled);
        Integer fontIndex = (Integer)this.fontCache.get(fontInfo.getId());
        if (fontIndex == null) {
            fontIndex = this.fontCache.size();
            this.export(fontInfo, isFontSizeFixEnabled);
            this.fontCache.put(fontInfo.getId(), fontIndex);
        }
        return fontIndex;
    }

    private void export(XlsxFontInfo fontInfo, boolean isFontSizeFixEnabled) {
        this.write("<font><sz val=\"" + (isFontSizeFixEnabled ? fontInfo.fontSize - 1 : fontInfo.fontSize) + "\"/>" + "<color rgb=\"" + fontInfo.color + "\"/>" + "<name val=\"" + fontInfo.fontName + "\"/>" + "<b val=\"" + fontInfo.isBold + "\"/>" + "<i val=\"" + fontInfo.isItalic + "\"/>" + "<u val=\"" + (fontInfo.isUnderline ? "single" : "none") + "\"/>" + "<strike val=\"" + fontInfo.isStrikeThrough + "\"/>" + "<family val=\"2\"/></font>\n");
    }
}

