/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributesUtilities {
    private static final String ATTR_DISMANTLED_STRUCTURE = "dismantled-structure";

    public static AttributeSet createImmutable(Object ... objectArray) {
        assert (objectArray.length % 2 == 0) : "There must be even number of prameters. They are key-value pairs of attributes that will be inserted into the set.";
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = objectArray.length / 2 - 1; i >= 0; --i) {
            Object object = objectArray[2 * i];
            Object object2 = objectArray[2 * i + 1];
            hashMap.put(object, object2);
        }
        return new Immutable(hashMap);
    }

    public static AttributeSet createImmutable(AttributeSet ... attributeSetArray) {
        HashMap hashMap = new HashMap();
        for (int i = attributeSetArray.length - 1; i >= 0; --i) {
            AttributeSet attributeSet = attributeSetArray[i];
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                Object object = attributeSet.getAttribute(obj);
                hashMap.put(obj, object);
            }
        }
        return new Immutable(hashMap);
    }

    public static AttributeSet createComposite(AttributeSet ... attributeSetArray) {
        if (attributeSetArray.length == 0) {
            return SimpleAttributeSet.EMPTY;
        }
        if (attributeSetArray.length == 1) {
            return attributeSetArray[0];
        }
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        for (AttributeSet attributeSet : attributeSetArray) {
            if (attributeSet instanceof Composite) {
                arrayList.addAll(((Composite)attributeSet).getDelegates());
                continue;
            }
            if (attributeSet instanceof Proxy) {
                arrayList.add(((Proxy)attributeSet).getDelegate());
                continue;
            }
            if (attributeSet == null || attributeSet == SimpleAttributeSet.EMPTY) continue;
            arrayList.add(attributeSet);
        }
        if (arrayList.size() == 0) {
            return SimpleAttributeSet.EMPTY;
        }
        if (arrayList.size() == 1) {
            return (AttributeSet)arrayList.get(0);
        }
        return new Composite(arrayList.toArray(new AttributeSet[arrayList.size()]));
    }

    private static List<AttributeSet> dismantle(AttributeSet attributeSet) {
        ArrayList<AttributeSet> arrayList = new ArrayList<AttributeSet>();
        if (attributeSet instanceof Proxy) {
            arrayList.addAll(AttributesUtilities.dismantle(((Proxy)attributeSet).getDelegate()));
        } else if (attributeSet instanceof Composite) {
            List<AttributeSet> list = ((Composite)attributeSet).getDelegates();
            for (AttributeSet attributeSet2 : list) {
                arrayList.addAll(AttributesUtilities.dismantle(attributeSet2));
            }
        } else {
            arrayList.add(attributeSet);
        }
        return arrayList;
    }

    private AttributesUtilities() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Composite
    implements AttributeSet {
        private final AttributeSet[] delegates;

        public Composite(AttributeSet ... attributeSetArray) {
            this.delegates = attributeSetArray;
        }

        public List<AttributeSet> getDelegates() {
            return Arrays.asList(this.delegates);
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return this.containsAttributes(attributeSet) && attributeSet.containsAttributes(this);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object obj = enumeration.nextElement();
                if (this.containsAttribute(obj, object = attributeSet.getAttribute(obj))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isDefined(Object object) {
            for (AttributeSet attributeSet : this.delegates) {
                if (!attributeSet.isDefined(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getAttribute(Object object) {
            if (object instanceof String && object.equals(AttributesUtilities.ATTR_DISMANTLED_STRUCTURE)) {
                return AttributesUtilities.dismantle(this);
            }
            AttributeSet[] attributeSetArray = this.delegates;
            int n = attributeSetArray.length;
            for (int i = 0; i < n; ++i) {
                AttributeSet attributeSet;
                for (AttributeSet attributeSet2 = attributeSet = attributeSetArray[i]; attributeSet2 != null; attributeSet2 = attributeSet2.getResolveParent()) {
                    if (!attributeSet2.isDefined(object)) continue;
                    return attributeSet2.getAttribute(object);
                }
            }
            return null;
        }

        @Override
        public AttributeSet getResolveParent() {
            return null;
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return Collections.enumeration(this.getAllKeys());
        }

        @Override
        public int getAttributeCount() {
            return this.getAllKeys().size();
        }

        @Override
        public AttributeSet copyAttributes() {
            return AttributesUtilities.createImmutable(this.delegates);
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            for (AttributeSet attributeSet : this.delegates) {
                if (!attributeSet.containsAttribute(object, object2)) continue;
                return true;
            }
            return false;
        }

        private Collection<?> getAllKeys() {
            HashSet hashSet = new HashSet();
            for (AttributeSet attributeSet : this.delegates) {
                Enumeration<?> enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    hashSet.add(obj);
                }
            }
            return hashSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Proxy
    implements AttributeSet {
        private AttributeSet original;

        public Proxy(AttributeSet attributeSet) {
            this.original = attributeSet;
        }

        public AttributeSet getDelegate() {
            return this.original;
        }

        @Override
        public boolean isEqual(AttributeSet attributeSet) {
            return this.original.isEqual(attributeSet);
        }

        @Override
        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.original.containsAttributes(attributeSet);
        }

        @Override
        public boolean isDefined(Object object) {
            return this.original.isDefined(object);
        }

        @Override
        public Object getAttribute(Object object) {
            if (object instanceof String && object.equals(AttributesUtilities.ATTR_DISMANTLED_STRUCTURE)) {
                return AttributesUtilities.dismantle(this);
            }
            return this.original.getAttribute(object);
        }

        @Override
        public AttributeSet getResolveParent() {
            return this.original.getResolveParent();
        }

        @Override
        public Enumeration<?> getAttributeNames() {
            return this.original.getAttributeNames();
        }

        @Override
        public int getAttributeCount() {
            return this.original.getAttributeCount();
        }

        @Override
        public AttributeSet copyAttributes() {
            return this.original.copyAttributes();
        }

        @Override
        public boolean containsAttribute(Object object, Object object2) {
            return this.original.containsAttribute(object, object2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Immutable
    implements AttributeSet {
        private final HashMap<Object, Object> attribs;
        private AttributeSet parent = null;

        private Immutable(HashMap<Object, Object> hashMap) {
            this.attribs = hashMap == null ? new HashMap() : hashMap;
            Object object = this.attribs.get(AttributeSet.ResolveAttribute);
            if (object instanceof AttributeSet) {
                this.setResolveParent((AttributeSet)object);
            }
        }

        public synchronized void setResolveParent(AttributeSet attributeSet) {
            this.parent = attributeSet;
        }

        @Override
        public synchronized boolean containsAttributes(AttributeSet attributeSet) {
            Enumeration<?> enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object obj = enumeration.nextElement();
                if (this.containsAttribute(obj, object = attributeSet.getAttribute(obj))) continue;
                return false;
            }
            return true;
        }

        @Override
        public synchronized boolean isEqual(AttributeSet attributeSet) {
            return this.containsAttributes(attributeSet) && attributeSet.containsAttributes(this);
        }

        @Override
        public synchronized Object getAttribute(Object object) {
            if (AttributeSet.ResolveAttribute == object) {
                return this.parent;
            }
            if (this.attribs.containsKey(object)) {
                return this.attribs.get(object);
            }
            if (this.parent != null) {
                return this.parent.getAttribute(object);
            }
            return null;
        }

        @Override
        public synchronized boolean isDefined(Object object) {
            return this.attribs.containsKey(object);
        }

        @Override
        public synchronized boolean containsAttribute(Object object, Object object2) {
            if (this.attribs.containsKey(object)) {
                Object object3 = this.attribs.get(object);
                if (object2 == null && object3 == null || object2 != null && object3 != null && object2.equals(object3)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public AttributeSet copyAttributes() {
            return new Proxy(this);
        }

        @Override
        public synchronized int getAttributeCount() {
            return this.attribs.size();
        }

        @Override
        public synchronized Enumeration<?> getAttributeNames() {
            return Collections.enumeration(this.attribs.keySet());
        }

        @Override
        public synchronized AttributeSet getResolveParent() {
            return this.parent;
        }
    }
}

