/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2;

import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.spi.editor.EditorImplementationProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class EditorImplementation {
    private static final Logger LOG = Logger.getLogger(EditorImplementation.class.getName());
    private static final EditorImplementationProvider DEFAULT = new DefaultImplementationProvider();
    private static EditorImplementation instance = null;
    private static EditorImplementationProvider externalProvider = null;
    private Lookup.Result<EditorImplementationProvider> result = Lookup.getDefault().lookup(new Lookup.Template(EditorImplementationProvider.class));

    public static synchronized EditorImplementation getDefault() {
        if (instance == null) {
            instance = new EditorImplementation();
        }
        return instance;
    }

    public void setExternalProvider(EditorImplementationProvider editorImplementationProvider) {
        externalProvider = editorImplementationProvider;
    }

    public ResourceBundle getResourceBundle(String string) {
        return this.getProvider().getResourceBundle(string);
    }

    public Action[] getGlyphGutterActions(JTextComponent jTextComponent) {
        return this.getProvider().getGlyphGutterActions(jTextComponent);
    }

    public boolean activateComponent(JTextComponent jTextComponent) {
        return this.getProvider().activateComponent(jTextComponent);
    }

    private EditorImplementation() {
    }

    private EditorImplementationProvider getProvider() {
        if (externalProvider != null) {
            return externalProvider;
        }
        Collection collection = this.result.allInstances();
        if (collection.isEmpty()) {
            LOG.warning("Can't find any EditorImplementationProvider; using default.");
            return DEFAULT;
        }
        return (EditorImplementationProvider)collection.iterator().next();
    }

    private static final class DefaultImplementationProvider
    implements EditorImplementationProvider {
        private static final Action[] NOACTIONS = new Action[0];

        private DefaultImplementationProvider() {
        }

        public ResourceBundle getResourceBundle(String string) {
            return NbBundle.getBundle((String)string);
        }

        public Action[] getGlyphGutterActions(JTextComponent jTextComponent) {
            return NOACTIONS;
        }

        public boolean activateComponent(JTextComponent jTextComponent) {
            return false;
        }
    }
}

