/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.ChildByNameConstraint;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.DefaultTupleConstraint;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConstraintFactory {
    static boolean enabled;
    private static final SqlConstraintFactory instance;

    private SqlConstraintFactory() {
    }

    public static SqlConstraintFactory instance() {
        SqlConstraintFactory.setNativeNonEmptyValue();
        return instance;
    }

    public static void setNativeNonEmptyValue() {
        enabled = MondrianProperties.instance().EnableNativeNonEmpty.get();
    }

    public MemberChildrenConstraint getMemberChildrenConstraint(Evaluator context) {
        if (!enabled || !SqlContextConstraint.isValidContext(context, false)) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new SqlContextConstraint((RolapEvaluator)context, false);
    }

    public TupleConstraint getLevelMembersConstraint(Evaluator context) {
        return this.getLevelMembersConstraint(context, null);
    }

    public TupleConstraint getLevelMembersConstraint(Evaluator context, Level[] levels) {
        if (context == null) {
            return DefaultTupleConstraint.instance();
        }
        if (!enabled) {
            return DefaultTupleConstraint.instance();
        }
        if (!SqlContextConstraint.isValidContext(context, false, levels, false)) {
            return DefaultTupleConstraint.instance();
        }
        return new SqlContextConstraint((RolapEvaluator)context, false);
    }

    public MemberChildrenConstraint getChildByNameConstraint(RolapMember parent, Id.Segment childName) {
        if (!enabled || parent.getHierarchy().isRagged()) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new ChildByNameConstraint(childName);
    }

    public TupleConstraint getDescendantsConstraint(List<RolapMember> parentMembers, MemberChildrenConstraint mcc) {
        return new DescendantsConstraint(parentMembers, mcc);
    }

    static {
        instance = new SqlConstraintFactory();
    }
}

