/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.Connection;
import java.sql.SQLException;
import javax.swing.JSplitPane;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.querybuilder.DiagramEntity;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.DiagramLoader;
import nickyb.sqleonardo.querybuilder.DiagramRelation;
import nickyb.sqleonardo.querybuilder.QueryActions;
import nickyb.sqleonardo.querybuilder.QueryModel;
import nickyb.sqleonardo.querybuilder.ViewBrowser;
import nickyb.sqleonardo.querybuilder.ViewDiagram;
import nickyb.sqleonardo.querybuilder.ViewObjects;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class QueryBuilder
extends BorderLayoutPanel {
    public static boolean autoJoin = true;
    public static boolean autoAlias = true;
    public static boolean useAlwaysQuote = true;
    public static boolean loadObjectsAtOnce = true;
    public static String identifierQuoteString = "\"";
    public static int maxColumnNameLength = 0;
    private Connection connection;
    private QueryModel model = new QueryModel();
    ViewBrowser browser;
    ViewDiagram diagram;
    ViewObjects objects;

    public QueryBuilder() {
        this((Connection)null);
    }

    public QueryBuilder(Connection connection) {
        super(2, 2);
        QueryActions.init(this);
        this.initComponents();
        this.setConnection(connection);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                JSplitPane split = (JSplitPane)QueryBuilder.this.getComponent(0);
                JSplitPane split2 = (JSplitPane)split.getLeftComponent();
                split2.setDividerLocation(0.5);
                split2.validate();
            }
        });
        this.transferFocus();
    }

    private void initComponents() {
        this.browser = new ViewBrowser(this);
        this.diagram = new ViewDiagram(this);
        this.objects = new ViewObjects(this);
        JSplitPane split2 = new JSplitPane(0);
        split2.setOneTouchExpandable(true);
        split2.setDividerLocation(250);
        split2.setLeftComponent(this.browser);
        split2.setRightComponent(this.objects);
        JSplitPane split = new JSplitPane(1);
        split.setTopComponent(split2);
        split.setBottomComponent(this.diagram);
        split.setOneTouchExpandable(true);
        this.setComponentCenter(split);
    }

    public boolean isDragAndDropEnabled() {
        return this.diagram.isDragAndDropEnabled();
    }

    public void setDragAndDropEnabled(boolean b) {
        this.diagram.setDragAndDropEnabled(b);
    }

    public QueryModel getModel() {
        return this.model;
    }

    public void setModel(QueryModel qm) {
        this.model = qm;
        this.diagram.onModelChanged();
        this.browser.onModelChanged();
        this.objects.onModelChanged();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        try {
            this.connection = connection;
            if (connection != null) {
                identifierQuoteString = connection.getMetaData().getIdentifierQuoteString();
                maxColumnNameLength = connection.getMetaData().getMaxColumnNameLength();
            }
            this.objects.onConnectionChanged();
        }
        catch (SQLException sqle) {
            System.out.println("[ QueryBuilder::setConnection ]\n" + sqle);
        }
    }

    void onLoad() {
        this.load(this.browser.getQuerySpecification().getFromClause());
        this.load(this.browser.getQuerySpecification().getSelectList());
    }

    private void load(QueryTokens._Expression[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            DiagramField field;
            QueryTokens.Column token;
            DiagramEntity entity;
            if (!(tokens[i] instanceof QueryTokens.Column) || (entity = this.diagram.getEntity((token = (QueryTokens.Column)tokens[i]).getTable())) == null || (field = entity.getField(token.getName())) == null) continue;
            field.setQueryToken(token);
        }
    }

    private void load(QueryTokens._TableReference[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            DiagramEntity entityF;
            if (tokens[i] instanceof QueryTokens.Table) {
                DiagramLoader.run(0, this, (QueryTokens.Table)tokens[i], false);
                continue;
            }
            QueryTokens.Join token = (QueryTokens.Join)tokens[i];
            DiagramEntity entityP = this.diagram.getEntity(token.getPrimary().getTable());
            if (entityP == null) {
                DiagramLoader.run(0, this, token.getPrimary().getTable(), false);
                entityP = this.diagram.getEntity(token.getPrimary().getTable());
            }
            if ((entityF = this.diagram.getEntity(token.getForeign().getTable())) == null) {
                DiagramLoader.run(0, this, token.getForeign().getTable(), false);
                entityF = this.diagram.getEntity(token.getForeign().getTable());
            }
            DiagramField fieldP = entityP.getField(token.getPrimary().getName());
            DiagramField fieldF = entityF.getField(token.getForeign().getName());
            if (fieldP == null || fieldF == null) continue;
            this.diagram.join(entityP, fieldP);
            this.diagram.join(entityF, fieldF);
            DiagramRelation relation = this.diagram.getRelation(token);
            if (relation == null) continue;
            relation.setQueryToken(token);
        }
    }
}

