/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders;

import com.jaspersoft.ireport.designer.FieldsProviderEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.ParameterTextTransferHandler;
import com.jaspersoft.ireport.designer.data.fieldsproviders.SQLParameterCellRenderer;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.tools.JRParameterDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class SQLFieldsProviderEditor
extends JPanel
implements FieldsProviderEditor,
PropertyChangeListener {
    private boolean sort = true;
    private boolean filter = true;
    private ReportQueryDialog reportQueryDialog = null;
    private JRDesignDataset dataset = null;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabelHelp;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToggleButton jToggleButtonFilter;
    private JToggleButton jToggleButtonSort;
    private JToolBar jToolBar1;

    public SQLFieldsProviderEditor() {
        this.initComponents();
        this.jList1.setModel(new DefaultListModel());
        this.jList1.setCellRenderer(new SQLParameterCellRenderer(this.jList1));
        this.jList1.setTransferHandler(new ParameterTextTransferHandler());
        boolean b = IReportManager.getPreferences().getBoolean("sqlFieldProvider.filter", true);
        this.jToggleButtonFilter.setSelected(b);
        this.setFilter(b);
        b = IReportManager.getPreferences().getBoolean("sqlFieldProvider.sort", true);
        this.jToggleButtonSort.setSelected(b);
        this.setSort(b);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton1 = new JButton();
        this.jToolBar1 = new JToolBar();
        this.jToggleButtonFilter = new JToggleButton();
        this.jToggleButtonSort = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.jLabelHelp = new JLabel();
        this.jLabel1.setText(NbBundle.getMessage(SQLFieldsProviderEditor.class, (String)"SQLFieldsProviderEditor.jLabel1.text"));
        this.jList1.setDragEnabled(true);
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SQLFieldsProviderEditor.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton1.setText(NbBundle.getMessage(SQLFieldsProviderEditor.class, (String)"SQLFieldsProviderEditor.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(SQLFieldsProviderEditor.class, (String)"SQLFieldsProviderEditor.jButton1.toolTipText"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SQLFieldsProviderEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToggleButtonFilter.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/filter-parameters.png")));
        this.jToggleButtonFilter.setSelected(true);
        this.jToggleButtonFilter.setToolTipText(NbBundle.getMessage(SQLFieldsProviderEditor.class, (String)"SQLFieldsProviderEditor.jToggleButtonFilter.toolTipText"));
        this.jToggleButtonFilter.setBorderPainted(false);
        this.jToggleButtonFilter.setFocusPainted(false);
        this.jToggleButtonFilter.setFocusable(false);
        this.jToggleButtonFilter.setMargin(new Insets(2, 6, 2, 6));
        this.jToggleButtonFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SQLFieldsProviderEditor.this.jToggleButtonFilterActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonFilter);
        this.jToggleButtonSort.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/parameters-sort-16.png")));
        this.jToggleButtonSort.setSelected(true);
        this.jToggleButtonSort.setToolTipText(NbBundle.getMessage(SQLFieldsProviderEditor.class, (String)"SQLFieldsProviderEditor.jToggleButtonSort.toolTipText"));
        this.jToggleButtonSort.setBorderPainted(false);
        this.jToggleButtonSort.setFocusPainted(false);
        this.jToggleButtonSort.setFocusable(false);
        this.jToggleButtonSort.setMargin(new Insets(2, 6, 2, 6));
        this.jToggleButtonSort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SQLFieldsProviderEditor.this.jToggleButtonSortActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonSort);
        this.jPanel1.setBackground(new Color(255, 255, 204));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelHelp.setBackground(new Color(255, 255, 204));
        this.jLabelHelp.setText(NbBundle.getMessage(SQLFieldsProviderEditor.class, (String)"SQLFieldsProviderEditor.jLabelHelp.text"));
        this.jLabelHelp.setVerticalTextPosition(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelHelp, gridBagConstraints);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 227, Short.MAX_VALUE).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButton1).addPreferredGap(0).add((Component)this.jToolBar1, -1, 114, Short.MAX_VALUE))).addContainerGap()).add(2, (Component)this.jPanel1, -1, 247, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 167, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jButton1).add((Component)this.jToolBar1, -2, -1, -2)).addContainerGap()));
    }

    private void jToggleButtonFilterActionPerformed(ActionEvent evt) {
        this.setFilter(this.jToggleButtonFilter.isSelected());
        IReportManager.getPreferences().putBoolean("sqlFieldProvider.filter", this.isFilter());
    }

    private void jToggleButtonSortActionPerformed(ActionEvent evt) {
        this.setSort(this.jToggleButtonSort.isSelected());
        IReportManager.getPreferences().putBoolean("sqlFieldProvider.sort", this.isSort());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.createNewParameter();
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2 && this.jList1.getSelectedValue() != null) {
            JRDesignParameter p = (JRDesignParameter)this.jList1.getSelectedValue();
            JRParameterDialog pd = new JRParameterDialog((Dialog)this.getReportQueryDialog(), this.getDataset().getParametersMap());
            pd.setExpressionContext(new ExpressionContext(this.getDataset()));
            pd.setParameter(p);
            pd.setVisible(true);
            if (pd.getDialogResult() == 0) {
                JRDesignParameter pNew = pd.getParameter();
                p.setName(pNew.getName());
                p.setValueClassName(pNew.getValueClassName());
                p.setDefaultValueExpression(pNew.getDefaultValueExpression());
                this.jList1.updateUI();
            }
        }
    }

    private void createNewParameter() {
        if (this.getDataset() == null) {
            return;
        }
        JRParameterDialog dialog = new JRParameterDialog((Dialog)this.getReportQueryDialog(), this.getDataset().getParametersMap());
        dialog.setExpressionContext(new ExpressionContext(this.getDataset()));
        dialog.setVisible(true);
        if (dialog.getDialogResult() == 0) {
            JRDesignParameter p = dialog.getParameter();
            try {
                this.getDataset().addParameter((JRParameter)p);
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void queryChanged(String newQuery) {
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        if (this.dataset != null) {
            this.dataset.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.dataset = dataset;
        if (this.dataset != null) {
            this.dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.updateParameters();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("parameters")) {
            this.updateParameters();
        }
    }

    private void updateParameters() {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.removeAllElements();
        if (this.getDataset() == null) {
            this.jList1.updateUI();
            return;
        }
        ArrayList<Object> parameters = new ArrayList<Object>(this.getDataset().getParametersList());
        if (this.isSort()) {
            Object[] params = parameters.toArray();
            Arrays.sort(params, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((JRDesignParameter)o1).getName().compareToIgnoreCase(((JRDesignParameter)o2).getName());
                }
            });
            parameters.clear();
            parameters.addAll(Arrays.asList(params));
        }
        for (int i = 0; i < parameters.size(); ++i) {
            JRDesignParameter p = (JRDesignParameter)parameters.get(i);
            if (this.isFilter() && p.isSystemDefined()) continue;
            dlm.addElement(parameters.get(i));
        }
        this.jList1.updateUI();
    }

    public boolean isSort() {
        return this.sort;
    }

    public void setSort(boolean sort) {
        this.sort = sort;
        this.updateParameters();
    }

    public boolean isFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
        this.updateParameters();
    }

    public ReportQueryDialog getReportQueryDialog() {
        return this.reportQueryDialog;
    }

    public void setReportQueryDialog(ReportQueryDialog reportQueryDialog) {
        this.reportQueryDialog = reportQueryDialog;
        this.setDataset(reportQueryDialog.getDataset());
    }
}

