/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.nodes;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.api.db.explorer.DatabaseMetaDataTransfer;
import org.netbeans.lib.ddl.impl.AddColumn;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseMetaDataTransferAccessor;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableListNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.nodes.DatabaseNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

public class TableNode
extends DatabaseNode {
    public TableNode(DatabaseNodeInfo databaseNodeInfo) {
        super(databaseNodeInfo);
    }

    public void setInfo(DatabaseNodeInfo databaseNodeInfo) {
        super.setInfo(databaseNodeInfo);
        this.getCookieSet().add((Node.Cookie)this);
    }

    public Transferable clipboardCopy() throws IOException {
        ExTransferable exTransferable = ExTransferable.create((Transferable)super.clipboardCopy());
        ConnectionNodeInfo connectionNodeInfo = (ConnectionNodeInfo)this.getInfo().getParent("connection");
        final DatabaseConnection databaseConnection = ConnectionList.getDefault().getConnection(connectionNodeInfo.getDatabaseConnection());
        exTransferable.put(new ExTransferable.Single(DatabaseMetaDataTransfer.TABLE_FLAVOR){

            protected Object getData() {
                return DatabaseMetaDataTransferAccessor.DEFAULT.createTableData(databaseConnection.getDatabaseConnection(), databaseConnection.findJDBCDriver(), TableNode.this.getInfo().getName());
            }
        });
        return exTransferable;
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        super.createPasteTypes(transferable, list);
        Node node = NodeTransfer.node((Transferable)transferable, (int)6);
        if (node != null && node.canDestroy()) {
            ColumnNodeInfo columnNodeInfo = (ColumnNodeInfo)node.getCookie(ColumnNodeInfo.class);
            if (columnNodeInfo != null) {
                list.add(new ColumnPasteType(columnNodeInfo, node));
                return;
            }
        } else {
            DatabaseNodeInfo databaseNodeInfo = (DatabaseNodeInfo)NodeTransfer.cookie((Transferable)transferable, (int)6, ColumnNodeInfo.class);
            if (databaseNodeInfo != null) {
                list.add(new ColumnPasteType((ColumnNodeInfo)databaseNodeInfo, null));
                return;
            }
        }
    }

    private class ColumnPasteType
    extends PasteType {
        final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        private DatabaseNodeInfo info;
        private Node node;

        public ColumnPasteType(ColumnNodeInfo columnNodeInfo, Node node) {
            this.info = columnNodeInfo;
            this.node = node;
        }

        public String getName() {
            return this.bundle.getString("PasteColumnName");
        }

        public Transferable paste() throws IOException {
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            TableNodeInfo tableNodeInfo = (TableNodeInfo)TableNode.this.getInfo();
            if (this.info != null) {
                try {
                    String string = this.info.getName();
                    ColumnNodeInfo columnNodeInfo = (ColumnNodeInfo)this.info;
                    TableColumn tableColumn = columnNodeInfo.getColumnSpecification();
                    Specification specification = (Specification)tableNodeInfo.getSpecification();
                    AddColumn addColumn = specification.createCommandAddColumn(tableNodeInfo.getTable());
                    addColumn.getColumns().add(tableColumn);
                    addColumn.setObjectOwner((String)this.info.get("schema"));
                    addColumn.execute();
                    tableNodeInfo.addColumn(string);
                    if (this.node != null) {
                        this.node.destroy();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                throw new IOException(resourceBundle.getString("EXC_CannotFindColumnOwnerInformation"));
            }
            return null;
        }
    }

    private class TablePasteType
    extends PasteType {
        private DatabaseNodeInfo info;
        private Node node;

        public TablePasteType(TableNodeInfo tableNodeInfo, Node node) {
            this.info = tableNodeInfo;
            this.node = node;
        }

        public String getName() {
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
            return resourceBundle.getString("PasteTableName");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Transferable paste() throws IOException {
            TableNodeInfo tableNodeInfo = (TableNodeInfo)TableNode.this.getInfo();
            ResourceBundle resourceBundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle_noi18n");
            TableListNodeInfo tableListNodeInfo = (TableListNodeInfo)TableNode.this.getInfo().getParent("tablelist");
            if (tableNodeInfo == null) throw new IOException(resourceBundle.getString("EXC_CannotFindTableOwnerInformation"));
            TableNodeInfo tableNodeInfo2 = tableListNodeInfo.getChildrenTableInfo(tableNodeInfo);
            String string = tableNodeInfo.getName();
            if (tableNodeInfo2 != null) {
                String string2 = resourceBundle.getString("PasteTableNameFormat");
                string = MessageFormat.format(string2, string);
            }
            try {
                tableListNodeInfo.addTable(string);
                if (this.node == null) return null;
                this.node.destroy();
                return null;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }
}

