/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.ContextASTEvaluator;
import org.netbeans.modules.languages.features.SemanticHighlightsLayer;
import org.netbeans.modules.languages.parser.SyntaxError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UsagesASTEvaluator
extends ASTEvaluator {
    private static Map<Document, WeakReference<UsagesASTEvaluator>> cache = new WeakHashMap<Document, WeakReference<UsagesASTEvaluator>>();
    private Document document;
    private ParserManagerImpl parserManager;
    private Set<DatabaseDefinition> definitions;
    private List<DatabaseItem> unresolvedUsages;
    private List<Boolean> unresolvedUsages_declaration_precedes_ussage;
    private static AttributeSet unusedParameterAttributeSet;
    private static AttributeSet syntaxErrorAttributeSet;
    private static AttributeSet parameterAttributeSet;
    private static AttributeSet unusedLocalVariableAttributeSet;
    private static AttributeSet unresolvedUssageAttributeSet;
    private static AttributeSet localVariableAttributeSet;
    private static AttributeSet unusedFieldAttributeSet;
    private static AttributeSet fieldAttributeSet;

    static void register(Document document) {
        if (UsagesASTEvaluator.get(document) != null) {
            return;
        }
        cache.put(document, new WeakReference<UsagesASTEvaluator>(new UsagesASTEvaluator(document)));
    }

    static void unregister(Document document) {
        UsagesASTEvaluator usagesASTEvaluator = UsagesASTEvaluator.get(document);
        if (usagesASTEvaluator != null) {
            ParserManager.get(document).removeASTEvaluator(usagesASTEvaluator);
        }
        cache.remove(document);
    }

    static UsagesASTEvaluator get(Document document) {
        WeakReference<UsagesASTEvaluator> weakReference = cache.get(document);
        if (weakReference == null) {
            return null;
        }
        return (UsagesASTEvaluator)weakReference.get();
    }

    static void addDatabaseDefinition(Document document, DatabaseDefinition databaseDefinition) {
        UsagesASTEvaluator usagesASTEvaluator = UsagesASTEvaluator.get(document);
        usagesASTEvaluator.definitions.add(databaseDefinition);
    }

    UsagesASTEvaluator(Document document) {
        this.document = document;
        this.parserManager = (ParserManagerImpl)ParserManager.get(document);
        this.parserManager.addASTEvaluator(this);
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode aSTNode) {
        this.unresolvedUsages = null;
        this.definitions = new HashSet<DatabaseDefinition>();
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode aSTNode) {
        Iterator<DatabaseItem> iterator;
        if (this.unresolvedUsages != null) {
            iterator = this.unresolvedUsages.iterator();
            Iterator<Object> iterator2 = this.unresolvedUsages_declaration_precedes_ussage.iterator();
            while (iterator.hasNext()) {
                if (this.parserManager != null && this.parserManager.getState() == ParserManager.State.PARSING) {
                    return;
                }
                DatabaseUsage object = (DatabaseUsage)iterator.next();
                DatabaseContext databaseContext = (DatabaseContext)iterator.next();
                boolean bl = (Boolean)iterator2.next();
                DatabaseDefinition databaseDefinition = databaseContext.getDefinition(object.getName(), object.getOffset());
                if (databaseDefinition != null) {
                    if (bl && databaseDefinition.getOffset() > object.getOffset()) continue;
                    databaseDefinition.addUsage(object);
                    databaseContext.addUsage(object);
                    object.setDatabaseDefinition(databaseDefinition);
                    this.highlightUssage(object, databaseDefinition);
                    if (!this.definitions.contains(databaseDefinition)) continue;
                    this.highlightDefinition(databaseDefinition);
                    this.definitions.remove(databaseDefinition);
                    continue;
                }
                this.highlightUnresolvedUssage(object);
            }
            this.unresolvedUsages = null;
        }
        iterator = this.definitions.iterator();
        while (iterator.hasNext()) {
            this.highlightUnusedDefinition((DatabaseDefinition)iterator.next());
        }
        for (SyntaxError syntaxError : this.parserManager.getSyntaxErrors()) {
            this.highlightSyntaxError(syntaxError, aSTNode);
        }
        SemanticHighlightsLayer.update(this.document);
    }

    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> list, Feature feature) {
        SyntaxContext syntaxContext = SyntaxContext.create(this.document, ASTPath.create(list));
        if (!feature.getBoolean("condition", syntaxContext, true)) {
            return;
        }
        ASTItem aSTItem = list.get(list.size() - 1);
        DatabaseContext databaseContext = ContextASTEvaluator.getCurrentContext(this.document, aSTItem.getOffset());
        String string = ((String)feature.getValue("name", syntaxContext)).trim();
        boolean bl = feature.getBoolean("declaration_precedes_usage", true);
        DatabaseDefinition databaseDefinition = databaseContext.getDefinition(string, aSTItem.getOffset());
        if (databaseDefinition != null && databaseDefinition.getOffset() == aSTItem.getOffset()) {
            return;
        }
        if (databaseDefinition != null && bl && databaseDefinition.getOffset() > aSTItem.getOffset()) {
            return;
        }
        DatabaseUsage databaseUsage = new DatabaseUsage(string, aSTItem.getOffset(), aSTItem.getEndOffset());
        if (databaseDefinition != null) {
            databaseDefinition.addUsage(databaseUsage);
            databaseUsage.setDatabaseDefinition(databaseDefinition);
            databaseContext.addUsage(databaseUsage);
            this.highlightUssage(databaseUsage, databaseDefinition);
            if (this.definitions.contains(databaseDefinition)) {
                this.highlightDefinition(databaseDefinition);
                this.definitions.remove(databaseDefinition);
            }
        } else {
            if (this.unresolvedUsages == null) {
                this.unresolvedUsages = new ArrayList<DatabaseItem>();
                this.unresolvedUsages_declaration_precedes_ussage = new ArrayList<Boolean>();
            }
            this.unresolvedUsages.add(databaseUsage);
            this.unresolvedUsages.add(databaseContext);
            this.unresolvedUsages_declaration_precedes_ussage.add(bl);
        }
        ContextASTEvaluator.setEvaluated(this.document, true);
    }

    @Override
    public String getFeatureName() {
        return "SEMANTIC_USAGE";
    }

    private void highlightUssage(DatabaseUsage databaseUsage, DatabaseDefinition databaseDefinition) {
        if ("parameter".equals(databaseDefinition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, databaseUsage.getOffset(), databaseUsage.getEndOffset(), UsagesASTEvaluator.getParameterAttributes());
        } else if ("local".equals(databaseDefinition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, databaseUsage.getOffset(), databaseUsage.getEndOffset(), UsagesASTEvaluator.getLocalVariableAttributes());
        } else if ("field".equals(databaseDefinition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, databaseUsage.getOffset(), databaseUsage.getEndOffset(), UsagesASTEvaluator.getFieldAttributes());
        }
    }

    private void highlightUnresolvedUssage(DatabaseUsage databaseUsage) {
    }

    private void highlightSyntaxError(SyntaxError syntaxError, ASTNode aSTNode) {
        ASTItem aSTItem = syntaxError.getItem();
        if (aSTItem.getLength() == 0) {
            int n = aSTItem.getOffset();
            if (n >= aSTNode.getEndOffset()) {
                n = aSTNode.getEndOffset() - 1;
            }
            aSTItem = aSTNode.findPath(n).getLeaf();
        }
        SemanticHighlightsLayer.addHighlight(this.document, aSTItem.getOffset(), aSTItem.getEndOffset(), UsagesASTEvaluator.getSyntaxErrorAttributes());
    }

    private void highlightDefinition(DatabaseDefinition databaseDefinition) {
        if ("parameter".equals(databaseDefinition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, databaseDefinition.getOffset(), databaseDefinition.getEndOffset(), UsagesASTEvaluator.getParameterAttributes());
        } else if ("variable".equals(databaseDefinition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, databaseDefinition.getOffset(), databaseDefinition.getEndOffset(), UsagesASTEvaluator.getLocalVariableAttributes());
        } else if ("field".equals(databaseDefinition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, databaseDefinition.getOffset(), databaseDefinition.getEndOffset(), UsagesASTEvaluator.getFieldAttributes());
        }
    }

    private void highlightUnusedDefinition(DatabaseDefinition databaseDefinition) {
        if ("parameter".equals(databaseDefinition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, databaseDefinition.getOffset(), databaseDefinition.getEndOffset(), UsagesASTEvaluator.getUnusedParameterAttributes());
        } else if ("field".equals(databaseDefinition.getType())) {
            SemanticHighlightsLayer.addHighlight(this.document, databaseDefinition.getOffset(), databaseDefinition.getEndOffset(), UsagesASTEvaluator.getUnusedFieldAttributes());
        } else {
            SemanticHighlightsLayer.addHighlight(this.document, databaseDefinition.getOffset(), databaseDefinition.getEndOffset(), UsagesASTEvaluator.getUnusedLocalVariableAttributes());
        }
    }

    private static AttributeSet getUnusedParameterAttributes() {
        if (unusedParameterAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, new Color(153, 153, 153));
            unusedParameterAttributeSet = simpleAttributeSet;
        }
        return unusedParameterAttributeSet;
    }

    private static AttributeSet getSyntaxErrorAttributes() {
        if (syntaxErrorAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, Color.red);
            syntaxErrorAttributeSet = simpleAttributeSet;
        }
        return syntaxErrorAttributeSet;
    }

    private static AttributeSet getParameterAttributes() {
        if (parameterAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            parameterAttributeSet = simpleAttributeSet;
        }
        return parameterAttributeSet;
    }

    private static AttributeSet getUnusedLocalVariableAttributes() {
        if (unusedLocalVariableAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, new Color(153, 153, 153));
            unusedLocalVariableAttributeSet = simpleAttributeSet;
        }
        return unusedLocalVariableAttributeSet;
    }

    private static AttributeSet getUnresolvedUssageAttributes() {
        if (unresolvedUssageAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, Color.red);
            unresolvedUssageAttributeSet = simpleAttributeSet;
        }
        return unresolvedUssageAttributeSet;
    }

    private static AttributeSet getLocalVariableAttributes() {
        if (localVariableAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            localVariableAttributeSet = simpleAttributeSet;
        }
        return localVariableAttributeSet;
    }

    private static AttributeSet getUnusedFieldAttributes() {
        if (unusedFieldAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            simpleAttributeSet.addAttribute(EditorStyleConstants.WaveUnderlineColor, new Color(153, 153, 153));
            StyleConstants.setForeground(simpleAttributeSet, new Color(0, 153, 0));
            unusedFieldAttributeSet = simpleAttributeSet;
        }
        return unusedFieldAttributeSet;
    }

    private static AttributeSet getFieldAttributes() {
        if (fieldAttributeSet == null) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(simpleAttributeSet, new Color(0, 153, 0));
            fieldAttributeSet = simpleAttributeSet;
        }
        return fieldAttributeSet;
    }
}

