/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxBorderHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFontHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxStyleInfo;
import net.sf.jasperreports.engine.util.FileBufferedWriter;

public class XlsxStyleHelper
extends BaseHelper {
    private FileBufferedWriter fontsWriter = new FileBufferedWriter();
    private FileBufferedWriter fillsWriter = new FileBufferedWriter();
    private FileBufferedWriter bordersWriter = new FileBufferedWriter();
    private FileBufferedWriter cellXfsWriter = new FileBufferedWriter();
    private Map styleCache = new HashMap();
    private XlsxFontHelper fontHelper;
    private XlsxBorderHelper borderHelper;
    private boolean isWhitePageBackground;
    private boolean isIgnoreCellBackground;

    public XlsxStyleHelper(Writer writer, Map fontMap, String exporterKey, boolean isWhitePageBackground, boolean isIgnoreCellBorder, boolean isIgnoreCellBackground) {
        super(writer);
        this.isWhitePageBackground = isWhitePageBackground;
        this.isIgnoreCellBackground = isIgnoreCellBackground;
        this.fontHelper = new XlsxFontHelper(this.fontsWriter);
        this.borderHelper = new XlsxBorderHelper(this.bordersWriter, isIgnoreCellBorder);
    }

    public int getCellStyle(JRExporterGridCell gridCell, boolean isWrapText, boolean isFontSizeFixEnabled) {
        XlsxStyleInfo styleInfo = new XlsxStyleInfo(this.fontHelper.getFont(gridCell, isFontSizeFixEnabled), this.borderHelper.getBorder(gridCell) + 1, gridCell, isWrapText);
        Integer styleIndex = (Integer)this.styleCache.get(styleInfo.getId());
        if (styleIndex == null) {
            styleIndex = this.styleCache.size() + 1;
            this.exportCellStyle(gridCell, styleInfo, styleIndex);
            this.styleCache.put(styleInfo.getId(), styleIndex);
        }
        return styleIndex;
    }

    private void exportCellStyle(JRExporterGridCell gridCell, XlsxStyleInfo styleInfo, Integer styleIndex) {
        try {
            if (this.isIgnoreCellBackground || styleInfo.backcolor == null) {
                if (this.isWhitePageBackground) {
                    this.fillsWriter.write("<fill><patternFill patternType=\"solid\"><fgColor rgb=\"FFFFFF\"/></patternFill></fill>\n");
                } else {
                    this.fillsWriter.write("<fill><patternFill patternType=\"none\"/></fill>\n");
                }
            } else {
                this.fillsWriter.write("<fill><patternFill patternType=\"solid\"><fgColor rgb=\"" + styleInfo.backcolor + "\"/></patternFill></fill>\n");
            }
            this.cellXfsWriter.write("<xf numFmtId=\"" + styleIndex + "\" fontId=\"" + styleInfo.fontIndex + "\" fillId=\"" + (styleIndex + 1) + "\" borderId=\"" + styleInfo.borderIndex + "\" xfId=\"" + styleIndex + "\">" + "<alignment wrapText=\"" + styleInfo.isWrapText + "\"" + (styleInfo.horizontalAlign == null ? "" : " horizontal=\"" + styleInfo.horizontalAlign + "\"") + (styleInfo.verticalAlign == null ? "" : " vertical=\"" + styleInfo.verticalAlign + "\"") + "/></xf>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void export() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<styleSheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">\n");
        this.write("<fonts>\n");
        this.write("<font><sz val=\"11\"/><color theme=\"1\"/><name val=\"Calibri\"/><family val=\"2\"/><scheme val=\"minor\"/></font>\n");
        this.fontsWriter.writeData(this.writer);
        this.write("</fonts>\n");
        this.write("<fills>\n");
        this.write("<fill><patternFill patternType=\"none\"/></fill>\n");
        this.write("<fill><patternFill patternType=\"solid\"><fgColor rgb=\"FFFFFF\"/></patternFill></fill>\n");
        this.fillsWriter.writeData(this.writer);
        this.write("</fills>\n");
        this.write("<borders>\n");
        this.write("<border><left/><right/><top/><bottom/><diagonal/></border>\n");
        this.bordersWriter.writeData(this.writer);
        this.write("</borders>\n");
        this.write("<cellXfs>\n");
        this.write("<xf numFmtId=\"0\" fontId=\"0\" fillId=\"0\" borderId=\"0\" xfId=\"0\"/>\n");
        this.cellXfsWriter.writeData(this.writer);
        this.write("</cellXfs>\n");
        this.write("<dxfs count=\"0\"/><tableStyles count=\"0\" defaultTableStyle=\"TableStyleMedium9\" defaultPivotStyle=\"PivotStyleLight16\"/>\n");
        this.write("</styleSheet>\n");
    }
}

