/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.nodes.properties;

import com.jaspersoft.ireport.components.table.TableElementNode;
import com.jaspersoft.ireport.components.table.TableModelUtils;
import com.jaspersoft.ireport.designer.sheet.properties.IntegerProperty;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.util.NbBundle;

public final class ColumnWidthProperty
extends IntegerProperty {
    private final StandardBaseColumn column;
    private final StandardTable table;
    private final JasperDesign jd;

    public ColumnWidthProperty(StandardBaseColumn column, StandardTable table, JasperDesign jd) {
        super((Object)column);
        this.column = column;
        this.table = table;
        this.jd = jd;
    }

    public String getName() {
        return "width";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TableElementNode.class, (String)"column.width.property");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(TableElementNode.class, (String)"column.width.property.description");
    }

    public Integer getInteger() {
        return this.getOwnInteger();
    }

    public Integer getOwnInteger() {
        return this.column.getWidth();
    }

    public Integer getDefaultInteger() {
        return 0;
    }

    public void setInteger(Integer height) {
        this.column.setWidth(height);
        TableModelUtils.fixTableLayout(this.table, this.jd);
        this.column.getEventSupport().firePropertyChange("COLUMN_WIDTH", null, (Object)height);
    }

    public void validateInteger(Integer height) {
        if (height < 0) {
            throw this.annotateException(NbBundle.getMessage(TableElementNode.class, (String)"column.width.validationError"));
        }
    }

    public StandardBaseColumn getColumn() {
        return this.column;
    }
}

