/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.list;

import com.jaspersoft.ireport.components.list.EditDatasetRunAction;
import com.jaspersoft.ireport.components.list.ListContentsHeightProperty;
import com.jaspersoft.ireport.components.list.ListContentsWidthProperty;
import com.jaspersoft.ireport.components.list.PrintOrderProperty;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementPasteType;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.components.list.DesignListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public class ListElementNode
extends ElementNode {
    public ListElementNode(JasperDesign jd, JRDesignElement element, Children children, Index index, Lookup doLkp) {
        super(jd, element, children, index, doLkp);
        this.setIconBaseWithExtension("com/jaspersoft/ireport/components/list/list-16.png");
    }

    public String getDisplayName() {
        return I18n.getString((String)"ListElementNode.name");
    }

    public boolean canPaste() {
        return true;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignElement element;
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction((Transferable)t);
        if (null != dropNode && null != (element = (JRDesignElement)dropNode.getLookup().lookup(JRDesignElement.class))) {
            DesignListContents contents = (DesignListContents)((StandardListComponent)((JRDesignComponentElement)this.getElement()).getComponent()).getContents();
            return new ElementPasteType(element.getElementGroup(), (JRElementGroup)contents, (Object)element, dropAction, (Node)this);
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean popup) {
        ArrayList<Object> actions = new ArrayList<Object>();
        Action[] originalActions = super.getActions(popup);
        actions.add(SystemAction.get(EditDatasetRunAction.class));
        for (int i = 0; i < originalActions.length; ++i) {
            actions.add(originalActions[i]);
        }
        return actions.toArray(new Action[actions.size()]);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.setName("List");
        set.setDisplayName(I18n.getString((String)"List"));
        DesignListContents contents = (DesignListContents)((StandardListComponent)((JRDesignComponentElement)this.getElement()).getComponent()).getContents();
        set.put((Node.Property)new ListContentsHeightProperty(contents));
        set.put((Node.Property)new ListContentsWidthProperty(contents));
        set.put((Node.Property)new PrintOrderProperty((StandardListComponent)((JRDesignComponentElement)this.getElement()).getComponent()));
        sheet.put(set);
        return sheet;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null && "height".equals(evt.getPropertyName())) {
            this.firePropertyChange("LCheight", null, null);
        }
        if (evt != null && "width".equals(evt.getPropertyName())) {
            this.firePropertyChange("LCwidth", null, null);
        }
        super.propertyChange(evt);
    }
}

