/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.palette.DefaultModel;
import org.netbeans.modules.palette.ui.TextImporter;
import org.netbeans.spi.palette.PaletteController;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;

public abstract class DragAndDropHandler {
    private boolean isTextDnDEnabled;
    private static DragAndDropHandler defaultHandler;

    public DragAndDropHandler() {
        this(false);
    }

    protected DragAndDropHandler(boolean bl) {
        this.isTextDnDEnabled = bl;
    }

    static DragAndDropHandler getDefault() {
        if (null == defaultHandler) {
            defaultHandler = new DefaultDragAndDropHandler();
        }
        return defaultHandler;
    }

    public abstract void customize(ExTransferable var1, Lookup var2);

    public boolean canDrop(Lookup lookup, DataFlavor[] dataFlavorArray, int n) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!PaletteController.ITEM_DATA_FLAVOR.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return this.isTextDnDEnabled && DataFlavor.selectBestTextFlavor(dataFlavorArray) != null;
    }

    public boolean doDrop(Lookup lookup, Transferable transferable, int n, int n2) {
        Node node = (Node)lookup.lookup(Node.class);
        try {
            Node[] nodeArray;
            Node[] nodeArray2;
            Lookup lookup2;
            if (transferable.isDataFlavorSupported(PaletteController.ITEM_DATA_FLAVOR) && null != (lookup2 = (Lookup)transferable.getTransferData(PaletteController.ITEM_DATA_FLAVOR)) && null != (nodeArray2 = (Node[])lookup2.lookup(Node.class)) && null != (nodeArray = (Node[])node.getCookie(Index.class)) && nodeArray.indexOf((Node)nodeArray2) >= 0) {
                return this.moveItem(lookup, lookup2, n2);
            }
            lookup2 = node.getDropType(transferable, n, n2);
            if (null != lookup2) {
                nodeArray2 = node.getChildren().getNodes(DefaultModel.canBlock());
                lookup2.paste();
                nodeArray = node.getChildren().getNodes(DefaultModel.canBlock());
                if (nodeArray.length == nodeArray2.length + 1) {
                    int n3 = -1;
                    Node node2 = null;
                    for (int i = nodeArray.length - 1; i >= 0; --i) {
                        node2 = nodeArray[i];
                        n3 = i;
                        for (int j = 0; j < nodeArray2.length; ++j) {
                            if (!node2.equals((Object)nodeArray2[j])) continue;
                            node2 = null;
                            break;
                        }
                        if (null != node2) break;
                    }
                    if (null != node2 && n2 >= 0) {
                        if (n3 < n2) {
                            ++n2;
                        }
                        this.moveItem(lookup, node2.getLookup(), n2);
                    }
                }
                return true;
            }
            if (this.isTextDnDEnabled && null != DataFlavor.selectBestTextFlavor(transferable.getTransferDataFlavors())) {
                this.importTextIntoPalette(lookup, transferable, n2);
                return false;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(DragAndDropHandler.class.getName()).log(Level.INFO, null, iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Logger.getLogger(DragAndDropHandler.class.getName()).log(Level.INFO, null, unsupportedFlavorException);
        }
        return false;
    }

    private boolean moveItem(Lookup lookup, Lookup lookup2, int n) {
        Node node = (Node)lookup.lookup(Node.class);
        if (null == node) {
            return false;
        }
        Node node2 = (Node)lookup2.lookup(Node.class);
        if (null == node2) {
            return false;
        }
        Index index = (Index)node.getCookie(Index.class);
        if (null == index) {
            return false;
        }
        int n2 = index.indexOf(node2);
        if (n2 < n) {
            --n;
        }
        index.move(n2, n);
        return true;
    }

    public boolean canReorderCategories(Lookup lookup) {
        Node node = (Node)lookup.lookup(Node.class);
        if (null != node) {
            return null != node.getCookie(Index.class);
        }
        return false;
    }

    public boolean moveCategory(Lookup lookup, int n) {
        Node node = (Node)lookup.lookup(Node.class);
        if (null == node) {
            return false;
        }
        Node node2 = node.getParentNode();
        if (null == node2) {
            return false;
        }
        Index index = (Index)node2.getCookie(Index.class);
        if (null == index) {
            return false;
        }
        int n2 = index.indexOf(node);
        if (n2 < n) {
            --n;
        }
        index.move(n2, n);
        return true;
    }

    private boolean importTextIntoPalette(Lookup lookup, Transferable transferable, int n) throws IOException, UnsupportedFlavorException {
        DataFlavor dataFlavor = DataFlavor.selectBestTextFlavor(transferable.getTransferDataFlavors());
        if (null == dataFlavor) {
            return false;
        }
        String string = this.extractText(transferable, dataFlavor);
        SwingUtilities.invokeLater(new TextImporter(string, lookup, n));
        return true;
    }

    private String extractText(Transferable transferable, DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
        int n;
        Reader reader = dataFlavor.getReaderForText(transferable);
        if (null == reader) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    private static final class DefaultDragAndDropHandler
    extends DragAndDropHandler {
        private DefaultDragAndDropHandler() {
        }

        public void customize(ExTransferable exTransferable, Lookup lookup) {
        }
    }
}

