/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.xml.ChartEvaluationGroupReference;
import net.sf.jasperreports.engine.xml.ElementReprintGroupReference;
import net.sf.jasperreports.engine.xml.ImageEvaluationGroupReference;
import net.sf.jasperreports.engine.xml.JRXmlDigesterFactory;
import net.sf.jasperreports.engine.xml.TextFieldEvaluationGroupReference;
import net.sf.jasperreports.engine.xml.XmlGroupReference;
import net.sf.jasperreports.engine.xml.XmlLoaderReportContext;
import org.apache.commons.digester.Digester;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRXmlLoader {
    private JasperDesign jasperDesign = null;
    private LinkedList<XmlLoaderReportContext> contextStack = new LinkedList();
    private Map<XmlGroupReference, XmlLoaderReportContext> groupReferences = new HashMap<XmlGroupReference, XmlLoaderReportContext>();
    private Set groupBoundDatasets = new HashSet();
    private List errors = new ArrayList();
    private Digester digester = null;
    private boolean ignoreConsistencyProblems;

    public JRXmlLoader(Digester digester) {
        this.digester = digester;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public void addGroupReference(XmlGroupReference reference) {
        XmlLoaderReportContext reportContext = this.getReportContext();
        this.groupReferences.put(reference, reportContext);
    }

    public void addGroupReprintedElement(JRDesignElement element) {
        this.addGroupReference(new ElementReprintGroupReference(element));
    }

    public void addGroupEvaluatedImage(JRDesignImage image) {
        this.addGroupReference(new ImageEvaluationGroupReference(image));
    }

    public void addGroupEvaluatedTextField(JRDesignTextField textField) {
        this.addGroupReference(new TextFieldEvaluationGroupReference(textField));
    }

    public void addGroupEvaluatedChart(JRDesignChart chart) {
        this.addGroupReference(new ChartEvaluationGroupReference(chart));
    }

    public Set getGroupBoundDatasets() {
        return this.groupBoundDatasets;
    }

    public static JasperDesign load(String sourceFileName) throws JRException {
        return JRXmlLoader.load(new File(sourceFileName));
    }

    public static JasperDesign load(File file) throws JRException {
        JasperDesign jasperDesign = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            jasperDesign = JRXmlLoader.load(fis);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return jasperDesign;
    }

    public static JasperDesign load(InputStream is) throws JRException {
        JasperDesign jasperDesign = null;
        JRXmlLoader xmlLoader = null;
        try {
            xmlLoader = new JRXmlLoader(JRXmlDigesterFactory.createDigester());
        }
        catch (ParserConfigurationException e) {
            throw new JRException(e);
        }
        catch (SAXException e) {
            throw new JRException(e);
        }
        jasperDesign = xmlLoader.loadXML(is);
        return jasperDesign;
    }

    public JasperDesign loadXML(InputStream is) throws JRException {
        return this.loadXML(new InputSource(is));
    }

    public JasperDesign loadXML(InputSource is) throws JRException {
        try {
            this.digester.push((Object)this);
            this.digester.parse(is);
        }
        catch (SAXException e) {
            throw new JRException(e);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        finally {
            this.digester.clear();
        }
        if (this.errors.size() > 0) {
            Exception e = (Exception)this.errors.get(0);
            if (e instanceof JRException) {
                throw (JRException)e;
            }
            throw new JRException(e);
        }
        this.assignGroupsToVariables(this.jasperDesign.getMainDesignDataset());
        for (JRDesignDataset dataset : this.jasperDesign.getDatasetsList()) {
            this.assignGroupsToVariables(dataset);
        }
        this.assignGroupReferences();
        this.assignGroupsToDatasets();
        return this.jasperDesign;
    }

    private void assignGroupsToVariables(JRDesignDataset dataset) throws JRException {
        JRVariable[] variables = dataset.getVariables();
        if (variables != null && variables.length > 0) {
            Map groupsMap = dataset.getGroupsMap();
            for (int i = 0; i < variables.length; ++i) {
                JRGroup group;
                String groupName;
                JRDesignVariable variable = (JRDesignVariable)variables[i];
                if (variable.getResetTypeValue() == ResetTypeEnum.GROUP) {
                    groupName = null;
                    group = variable.getResetGroup();
                    if (group != null) {
                        groupName = group.getName();
                        group = (JRGroup)groupsMap.get(groupName);
                    }
                    if (!this.ignoreConsistencyProblems && group == null) {
                        throw new JRValidationException("Unknown reset group '" + groupName + "' for variable : " + variable.getName(), variable);
                    }
                    variable.setResetGroup(group);
                } else {
                    variable.setResetGroup(null);
                }
                if (variable.getIncrementTypeValue() == IncrementTypeEnum.GROUP) {
                    groupName = null;
                    group = variable.getIncrementGroup();
                    if (group != null) {
                        groupName = group.getName();
                        group = (JRGroup)groupsMap.get(groupName);
                    }
                    if (!this.ignoreConsistencyProblems && group == null) {
                        throw new JRValidationException("Unknown increment group '" + groupName + "' for variable : " + variable.getName(), variable);
                    }
                    variable.setIncrementGroup(group);
                    continue;
                }
                variable.setIncrementGroup(null);
            }
        }
    }

    private void assignGroupReferences() throws JRException {
        for (Map.Entry<XmlGroupReference, XmlLoaderReportContext> entry : this.groupReferences.entrySet()) {
            XmlGroupReference reference = entry.getKey();
            XmlLoaderReportContext context = entry.getValue();
            String groupName = null;
            JRGroup group = reference.getGroupReference();
            if (group != null) {
                groupName = group.getName();
                group = this.resolveGroup(groupName, context);
            }
            if (!this.ignoreConsistencyProblems && group == null) {
                reference.groupNotFound(groupName);
                continue;
            }
            reference.assignGroup(group);
        }
    }

    protected JRGroup resolveGroup(String groupName, XmlLoaderReportContext context) {
        JRGroup group;
        if (context == null) {
            Map groupsMap = this.jasperDesign.getGroupsMap();
            group = (JRGroup)groupsMap.get(groupName);
        } else {
            String datasetName = context.getSubdatesetName();
            JRDesignDataset dataset = (JRDesignDataset)this.jasperDesign.getDatasetMap().get(datasetName);
            if (dataset == null) {
                throw new JRRuntimeException("Could not find subdataset of name \"" + datasetName + "\"");
            }
            group = (JRGroup)dataset.getGroupsMap().get(groupName);
        }
        return group;
    }

    private void assignGroupsToDatasets() throws JRException {
        for (JRDesignElementDataset dataset : this.groupBoundDatasets) {
            JRGroup group;
            String groupName;
            Map groupsMap;
            JRDatasetRun datasetRun = dataset.getDatasetRun();
            if (datasetRun == null) {
                groupsMap = this.jasperDesign.getGroupsMap();
            } else {
                String datasetName;
                Map datasetMap = this.jasperDesign.getDatasetMap();
                JRDesignDataset subDataset = (JRDesignDataset)datasetMap.get(datasetName = datasetRun.getDatasetName());
                if (subDataset == null) {
                    throw new JRException("Unknown sub dataset '" + datasetName + "' for chart dataset.");
                }
                groupsMap = subDataset.getGroupsMap();
            }
            if (dataset.getIncrementTypeValue() == IncrementTypeEnum.GROUP) {
                groupName = null;
                group = dataset.getIncrementGroup();
                if (group != null) {
                    groupName = group.getName();
                    group = (JRGroup)groupsMap.get(group.getName());
                }
                if (!this.ignoreConsistencyProblems && group == null) {
                    throw new JRValidationException("Unknown increment group '" + groupName + "' for chart dataset.", dataset);
                }
                dataset.setIncrementGroup(group);
            } else {
                dataset.setIncrementGroup(null);
            }
            if (dataset.getResetTypeValue() == ResetTypeEnum.GROUP) {
                groupName = null;
                group = dataset.getResetGroup();
                if (group != null) {
                    groupName = group.getName();
                    group = (JRGroup)groupsMap.get(group.getName());
                }
                if (!this.ignoreConsistencyProblems && group == null) {
                    throw new JRValidationException("Unknown reset group '" + groupName + "' for chart dataset.", dataset);
                }
                dataset.setResetGroup(group);
                continue;
            }
            dataset.setResetGroup(null);
        }
    }

    public void addError(Exception e) {
        if (!this.ignoreConsistencyProblems) {
            this.errors.add(e);
        }
    }

    public boolean isIgnoreConsistencyProblems() {
        return this.ignoreConsistencyProblems;
    }

    public void setIgnoreConsistencyProblems(boolean ignoreConsistencyProblems) {
        this.ignoreConsistencyProblems = ignoreConsistencyProblems;
    }

    public void pushReportContext(XmlLoaderReportContext context) {
        this.contextStack.addFirst(context);
    }

    public XmlLoaderReportContext popReportContext() {
        return this.contextStack.removeFirst();
    }

    public XmlLoaderReportContext getReportContext() {
        return this.contextStack.isEmpty() ? null : this.contextStack.getFirst();
    }
}

