/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.oasis.ContentBuilder;
import net.sf.jasperreports.engine.export.oasis.FileBufferedOasisZip;
import net.sf.jasperreports.engine.export.oasis.JROpenDocumentExporterNature;
import net.sf.jasperreports.engine.export.oasis.StyleBuilder;
import net.sf.jasperreports.engine.export.oasis.StyleCache;
import net.sf.jasperreports.engine.export.oasis.TableBuilder;
import net.sf.jasperreports.engine.export.oasis.Utility;
import net.sf.jasperreports.engine.export.zip.FileBufferedZipEntry;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class JROpenDocumentExporter
extends JRAbstractExporter {
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    public static final String IMAGE_NAME_PREFIX = "img_";
    protected static final int IMAGE_NAME_PREFIX_LEGTH = "img_".length();
    protected Writer tempBodyWriter = null;
    protected Writer tempStyleWriter = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageMaps;
    protected List imagesToProcess = null;
    protected int reportIndex = 0;
    protected int pageIndex = 0;
    protected int tableIndex = 0;
    protected boolean startPage;
    protected String encoding = null;
    protected boolean isWrapBreakWord = false;
    protected Map fontMap = null;
    protected LinkedList backcolorStack = new LinkedList();
    protected Color backcolor = null;
    protected StyleCache styleCache = null;
    protected ExporterNature nature = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportReport() throws JRException {
        block21: {
            this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
            this.setOffset();
            try {
                this.setExportContext();
                this.setInput();
                if (!this.parameters.containsKey(JRExporterParameter.FILTER)) {
                    this.filter = this.createFilter(this.getExporterPropertiesPrefix());
                }
                if (!this.isModeBatch) {
                    this.setPageRange();
                }
                this.encoding = this.getStringParameterOrDefault(JRExporterParameter.CHARACTER_ENCODING, "net.sf.jasperreports.export.character.encoding");
                this.rendererToImagePathMap = new HashMap();
                this.imageMaps = new HashMap();
                this.imagesToProcess = new ArrayList();
                this.fontMap = (Map)this.parameters.get(JRExporterParameter.FONT_MAP);
                this.setHyperlinkProducerFactory();
                this.nature = this.getExporterNature(this.filter);
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.exportReportToOasisZip(os);
                        break block21;
                    }
                    catch (IOException e) {
                        throw new JRException("Error trying to export to output stream : " + this.jasperPrint.getName(), e);
                    }
                }
                File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                if (destFile == null) {
                    String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                    if (fileName != null) {
                        destFile = new File(fileName);
                    } else {
                        throw new JRException("No output specified for the exporter.");
                    }
                }
                try {
                    os = new FileOutputStream(destFile);
                    this.exportReportToOasisZip(os);
                }
                catch (IOException e) {
                    throw new JRException("Error trying to export to file : " + destFile, e);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            finally {
                this.resetExportContext();
            }
        }
    }

    public static JRPrintImage getImage(List jasperPrintList, String imageName) {
        return JROpenDocumentExporter.getImage(jasperPrintList, JROpenDocumentExporter.getPrintElementIndex(imageName));
    }

    public static JRPrintImage getImage(List jasperPrintList, JRPrintElementIndex imageIndex) {
        JasperPrint report = (JasperPrint)jasperPrintList.get(imageIndex.getReportIndex());
        JRPrintPage page = (JRPrintPage)report.getPages().get(imageIndex.getPageIndex());
        Integer[] elementIndexes = imageIndex.getAddressArray();
        Object element = page.getElements().get(elementIndexes[0]);
        for (int i = 1; i < elementIndexes.length; ++i) {
            JRPrintFrame frame = (JRPrintFrame)element;
            element = frame.getElements().get(elementIndexes[i]);
        }
        return (JRPrintImage)element;
    }

    protected void exportReportToOasisZip(OutputStream os) throws JRException, IOException {
        FileBufferedOasisZip oasisZip = new FileBufferedOasisZip(((JROpenDocumentExporterNature)this.nature).getOpenDocumentNature());
        FileBufferedZipEntry tempBodyEntry = new FileBufferedZipEntry(null);
        FileBufferedZipEntry tempStyleEntry = new FileBufferedZipEntry(null);
        this.tempBodyWriter = tempBodyEntry.getWriter();
        this.tempStyleWriter = tempStyleEntry.getWriter();
        this.styleCache = new StyleCache(this.tempStyleWriter, this.fontMap, this.getExporterKey());
        Writer stylesWriter = oasisZip.getStylesEntry().getWriter();
        StyleBuilder styleBuilder = new StyleBuilder(this.jasperPrintList, stylesWriter);
        styleBuilder.build();
        stylesWriter.close();
        this.reportIndex = 0;
        while (this.reportIndex < this.jasperPrintList.size()) {
            this.setJasperPrint((JasperPrint)this.jasperPrintList.get(this.reportIndex));
            List pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                if (this.isModeBatch) {
                    this.startPageIndex = 0;
                    this.endPageIndex = pages.size() - 1;
                }
                JRPrintPage page = null;
                this.pageIndex = this.startPageIndex;
                while (this.pageIndex <= this.endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = (JRPrintPage)pages.get(this.pageIndex);
                    this.exportPage(page);
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        this.tempBodyWriter.flush();
        this.tempStyleWriter.flush();
        this.tempBodyWriter.close();
        this.tempStyleWriter.close();
        ContentBuilder contentBuilder = new ContentBuilder(oasisZip.getContentEntry(), tempStyleEntry, tempBodyEntry, this.styleCache.getFontFaces(), ((JROpenDocumentExporterNature)this.nature).getOpenDocumentNature());
        contentBuilder.build();
        tempStyleEntry.dispose();
        tempBodyEntry.dispose();
        if (this.imagesToProcess != null && this.imagesToProcess.size() > 0) {
            for (JRPrintElementIndex imageIndex : this.imagesToProcess) {
                JRPrintImage image = JROpenDocumentExporter.getImage(this.jasperPrintList, imageIndex);
                JRRenderable renderer = image.getRenderer();
                if (renderer.getType() == 1) {
                    renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                }
                oasisZip.addEntry(new FileBufferedZipEntry("Pictures/" + JROpenDocumentExporter.getImageName(imageIndex), renderer.getImageData()));
            }
        }
        oasisZip.zipEntries(os);
        oasisZip.dispose();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.startPage = true;
        JRGridLayout layout = new JRGridLayout(this.nature, page.getElements(), this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight(), this.globalOffsetX, this.globalOffsetY, null);
        this.exportGrid(layout, null);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportGrid(JRGridLayout gridLayout, JRPrintElementIndex frameIndex) throws IOException, JRException {
        CutsInfo xCuts = gridLayout.getXCuts();
        JRExporterGridCell[][] grid = gridLayout.getGrid();
        TableBuilder tableBuilder = frameIndex == null ? new TableBuilder(this.reportIndex, this.pageIndex, this.tempBodyWriter, this.tempStyleWriter) : new TableBuilder(frameIndex.toString(), this.tempBodyWriter, this.tempStyleWriter);
        tableBuilder.buildTableStyle(gridLayout.getWidth());
        tableBuilder.buildTableHeader();
        for (int col = 1; col < xCuts.size(); ++col) {
            tableBuilder.buildColumnStyle(col - 1, xCuts.getCut(col) - xCuts.getCut(col - 1));
            tableBuilder.buildColumnHeader(col - 1);
            tableBuilder.buildColumnFooter();
        }
        JRPrintElement element = null;
        for (int row = 0; row < grid.length; ++row) {
            int emptyCellColSpan = 0;
            int emptyCellWidth = 0;
            int rowHeight = gridLayout.getRowHeight(row);
            tableBuilder.buildRowStyle(row, rowHeight);
            tableBuilder.buildRowHeader(row);
            for (int col = 0; col < grid[0].length; ++col) {
                JRExporterGridCell gridCell = grid[row][col];
                if (gridCell.getType() == 2) {
                    if (emptyCellColSpan > 0) {
                        emptyCellColSpan = 0;
                        emptyCellWidth = 0;
                    }
                    this.exportOccupiedCells(1);
                    continue;
                }
                if (gridCell.getWrapper() != null) {
                    if (emptyCellColSpan > 0) {
                        emptyCellColSpan = 0;
                        emptyCellWidth = 0;
                    }
                    if ((element = gridCell.getWrapper().getElement()) instanceof JRPrintLine) {
                        this.exportLine(tableBuilder, (JRPrintLine)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintRectangle) {
                        this.exportRectangle(tableBuilder, (JRPrintRectangle)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintEllipse) {
                        this.exportEllipse(tableBuilder, (JRPrintEllipse)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintImage) {
                        this.exportImage(tableBuilder, (JRPrintImage)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintText) {
                        this.exportText(tableBuilder, (JRPrintText)element, gridCell);
                        continue;
                    }
                    if (element instanceof JRPrintFrame) {
                        this.exportFrame(tableBuilder, (JRPrintFrame)element, gridCell);
                        continue;
                    }
                    if (!(element instanceof JRGenericPrintElement)) continue;
                    this.exportGenericElement(tableBuilder, (JRGenericPrintElement)element, gridCell);
                    continue;
                }
                ++emptyCellColSpan;
                emptyCellWidth += gridCell.getWidth();
                this.exportEmptyCell(gridCell, 1);
            }
            tableBuilder.buildRowFooter();
        }
        tableBuilder.buildTableFooter();
    }

    private void exportEmptyCell(JRExporterGridCell gridCell, int emptyCellColSpan) throws IOException {
        this.tempBodyWriter.write("<table:table-cell");
        this.tempBodyWriter.write(" table:style-name=\"" + this.styleCache.getCellStyle(gridCell) + "\"");
        if (emptyCellColSpan > 1) {
            this.tempBodyWriter.write(" table:number-columns-spanned=\"" + emptyCellColSpan + "\"");
        }
        this.tempBodyWriter.write("/>\n");
        this.exportOccupiedCells(emptyCellColSpan - 1);
    }

    private void exportOccupiedCells(int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            this.tempBodyWriter.write("<table:covered-table-cell/>\n");
        }
    }

    protected abstract void exportLine(TableBuilder var1, JRPrintLine var2, JRExporterGridCell var3) throws IOException;

    protected void exportRectangle(TableBuilder tableBuilder, JRPrintRectangle rectangle, JRExporterGridCell gridCell) throws IOException {
        JRBaseLineBox box = new JRBaseLineBox(null);
        JRBoxPen pen = box.getPen();
        pen.setLineColor(rectangle.getLinePen().getLineColor());
        pen.setLineStyle(rectangle.getLinePen().getLineStyleValue());
        pen.setLineWidth(rectangle.getLinePen().getLineWidth());
        gridCell.setBox(box);
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        tableBuilder.buildCellFooter();
    }

    protected abstract void exportEllipse(TableBuilder var1, JRPrintEllipse var2, JRExporterGridCell var3) throws IOException;

    public void exportText(TableBuilder tableBuilder, JRPrintText text, JRExporterGridCell gridCell) throws IOException {
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        this.tempBodyWriter.write("<text:p text:style-name=\"");
        this.tempBodyWriter.write(this.styleCache.getParagraphStyle(text));
        this.tempBodyWriter.write("\">");
        this.insertPageAnchor();
        if (text.getAnchorName() != null) {
            this.exportAnchor(JRStringUtil.xmlEncode(text.getAnchorName()));
        }
        boolean startedHyperlink = this.startHyperlink(text, true);
        if (textLength > 0) {
            this.exportStyledText(styledText, this.getTextLocale(text));
        }
        if (startedHyperlink) {
            this.endHyperlink(true);
        }
        this.tempBodyWriter.write("</text:p>\n");
        tableBuilder.buildCellFooter();
    }

    protected void exportStyledText(JRStyledText styledText, Locale locale) throws IOException {
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), locale);
            iterator.setIndex(runLimit);
        }
    }

    protected void exportStyledTextRun(Map attributes, String text, Locale locale) throws IOException {
        String textSpanStyleName = this.styleCache.getTextSpanStyle(attributes, text, locale);
        this.tempBodyWriter.write("<text:span");
        this.tempBodyWriter.write(" text:style-name=\"" + textSpanStyleName + "\"");
        this.tempBodyWriter.write(">");
        if (text != null) {
            this.tempBodyWriter.write(Utility.replaceNewLineWithLineBreak(JRStringUtil.xmlEncode(text)));
        }
        this.tempBodyWriter.write("</text:span>");
    }

    protected abstract void exportImage(TableBuilder var1, JRPrintImage var2, JRExporterGridCell var3) throws JRException, IOException;

    protected String getImagePath(JRRenderable renderer, boolean isLazy, JRExporterGridCell gridCell) {
        String imagePath = null;
        if (renderer != null) {
            if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                imagePath = (String)this.rendererToImagePathMap.get(renderer.getId());
            } else {
                if (isLazy) {
                    imagePath = ((JRImageRenderer)renderer).getImageLocation();
                } else {
                    JRPrintElementIndex imageIndex = this.getElementIndex(gridCell);
                    this.imagesToProcess.add(imageIndex);
                    String imageName = JROpenDocumentExporter.getImageName(imageIndex);
                    imagePath = "Pictures/" + imageName;
                }
                this.rendererToImagePathMap.put(renderer.getId(), imagePath);
            }
        }
        return imagePath;
    }

    protected JRPrintElementIndex getElementIndex(JRExporterGridCell gridCell) {
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
        return imageIndex;
    }

    public static String getImageName(JRPrintElementIndex printElementIndex) {
        return IMAGE_NAME_PREFIX + printElementIndex.toString();
    }

    public static JRPrintElementIndex getPrintElementIndex(String imageName) {
        if (!imageName.startsWith(IMAGE_NAME_PREFIX)) {
            throw new JRRuntimeException("Invalid image name: " + imageName);
        }
        return JRPrintElementIndex.parsePrintElementIndex(imageName.substring(IMAGE_NAME_PREFIX_LEGTH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportFrame(TableBuilder tableBuilder, JRPrintFrame frame, JRExporterGridCell gridCell) throws IOException, JRException {
        boolean appendBackcolor;
        tableBuilder.buildCellHeader(this.styleCache.getCellStyle(gridCell), gridCell.getColSpan(), gridCell.getRowSpan());
        boolean bl = appendBackcolor = frame.getModeValue() == ModeEnum.OPAQUE && (this.backcolor == null || frame.getBackcolor().getRGB() != this.backcolor.getRGB());
        if (appendBackcolor) {
            this.setBackcolor(frame.getBackcolor());
        }
        try {
            JRGridLayout layout = gridCell.getLayout();
            JRPrintElementIndex frameIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, gridCell.getWrapper().getAddress());
            this.exportGrid(layout, frameIndex);
        }
        finally {
            if (appendBackcolor) {
                this.restoreBackcolor();
            }
        }
        tableBuilder.buildCellFooter();
    }

    protected abstract void exportGenericElement(TableBuilder var1, JRGenericPrintElement var2, JRExporterGridCell var3) throws IOException, JRException;

    protected void setBackcolor(Color color) {
        this.backcolorStack.addLast(this.backcolor);
        this.backcolor = color;
    }

    protected void restoreBackcolor() {
        this.backcolor = (Color)this.backcolorStack.removeLast();
    }

    protected float getXAlignFactor(JRPrintImage image) {
        float xalignFactor = 0.0f;
        switch (image.getHorizontalAlignmentValue()) {
            case RIGHT: {
                xalignFactor = 1.0f;
                break;
            }
            case CENTER: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    protected float getYAlignFactor(JRPrintImage image) {
        float yalignFactor = 0.0f;
        switch (image.getVerticalAlignmentValue()) {
            case BOTTOM: {
                yalignFactor = 1.0f;
                break;
            }
            case MIDDLE: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    protected boolean startHyperlink(JRPrintHyperlink link, boolean isText) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            if (isText) {
                this.tempBodyWriter.write("<text:a xlink:href=\"");
            } else {
                this.tempBodyWriter.write("<draw:a xlink:type=\"simple\" xlink:href=\"");
            }
            this.tempBodyWriter.write(JRStringUtil.xmlEncode(href));
            this.tempBodyWriter.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.tempBodyWriter.write(" office:target-frame-name=\"");
                this.tempBodyWriter.write(target);
                this.tempBodyWriter.write("\"");
                if (target.equals("_blank")) {
                    this.tempBodyWriter.write(" xlink:show=\"new\"");
                }
            }
            this.tempBodyWriter.write(">");
        }
        return href != null;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target = null;
        switch (link.getHyperlinkTargetValue()) {
            case SELF: {
                target = "_self";
                break;
            }
            default: {
                target = "_blank";
            }
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block12: {
                href = null;
                customHandler = this.getCustomHandler(link);
                if (customHandler != null) break block12;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = link.getHyperlinkReference() + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = link.getHyperlinkReference() + "#" + JR_PAGE_ANCHOR_PREFIX + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink(boolean isText) throws IOException {
        if (isText) {
            this.tempBodyWriter.write("</text:a>");
        } else {
            this.tempBodyWriter.write("</draw:a>");
        }
    }

    protected void insertPageAnchor() throws IOException {
        if (this.startPage) {
            this.exportAnchor(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (this.pageIndex + 1));
            this.startPage = false;
        }
    }

    protected abstract void exportAnchor(String var1) throws IOException;

    protected abstract ExporterNature getExporterNature(ExporterFilter var1);

    protected abstract String getExporterPropertiesPrefix();
}

