/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.visitor;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.impl.SchemaGeneratorUtil;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;
import org.netbeans.modules.xml.schema.model.SchemaModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AXINonCyclicVisitor
extends DeepAXITreeVisitor {
    List<AXIComponent> path = null;
    private AXIModel am;
    private SchemaModel sm;

    public AXINonCyclicVisitor(AXIModel aXIModel) {
        this.am = aXIModel;
        this.sm = aXIModel.getSchemaModel();
        this.path = new ArrayList<AXIComponent>();
    }

    public void expand(AXIDocument aXIDocument) {
        this.path.clear();
        if (aXIDocument != null) {
            for (AXIComponent aXIComponent : aXIDocument.getChildren()) {
                aXIComponent.accept(this);
            }
        }
    }

    public void expand(List<Element> list) {
        this.path.clear();
        for (Element element : list) {
            element.accept(this);
        }
    }

    @Override
    public void visit(Element element) {
        if (!this.canVisit(element)) {
            return;
        }
        this.visitChildren(element);
    }

    public boolean canVisit(Element element) {
        Element element2 = this.getOriginalElement(element);
        return SchemaGeneratorUtil.fromSameSchemaModel(element2, this.sm) && (this.path.size() <= 0 || !this.path.contains(element2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitChildren(Element element) {
        Element element2 = this.getOriginalElement(element);
        this.path.add(element2);
        try {
            super.visit(element);
        }
        finally {
            this.path.remove(this.path.size() - 1);
        }
    }

    private Element getOriginalElement(Element element) {
        Element element2 = element;
        if (element2.isReference()) {
            element2 = SchemaGeneratorUtil.findOriginalElement(element);
        }
        return element2;
    }
}

