/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;

public class HierarchyCurrentMemberFunDef
extends FunDefBase {
    static final HierarchyCurrentMemberFunDef instance = new HierarchyCurrentMemberFunDef();

    private HierarchyCurrentMemberFunDef() {
        super("CurrentMember", "Returns the current member along a hierarchy during an iteration.", "pmh");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
        return new CalcImpl((Exp)call, hierarchyCalc);
    }

    public static class CalcImpl
    extends AbstractMemberCalc {
        private final HierarchyCalc hierarchyCalc;

        public CalcImpl(Exp exp, HierarchyCalc hierarchyCalc) {
            super(exp, new Calc[]{hierarchyCalc});
            this.hierarchyCalc = hierarchyCalc;
        }

        protected String getName() {
            return "CurrentMember";
        }

        public Member evaluateMember(Evaluator evaluator) {
            Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
            Member member = evaluator.getContext(hierarchy.getDimension());
            if (member.getHierarchy() != hierarchy) {
                member = hierarchy.getDefaultMember();
            }
            return member;
        }

        public boolean dependsOn(Dimension dimension) {
            return this.hierarchyCalc.getType().usesDimension(dimension, false);
        }
    }
}

