/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Cell;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunDef;
import mondrian.olap.Id;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapResult;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.RolapVirtualCubeMeasure;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RolapCell
implements Cell {
    private final RolapResult result;
    protected final int[] pos;
    protected RolapResult.CellInfo ci;

    RolapCell(RolapResult result, int[] pos, RolapResult.CellInfo ci) {
        this.result = result;
        this.pos = pos;
        this.ci = ci;
    }

    @Override
    public List<Integer> getCoordinateList() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return RolapCell.this.pos[index];
            }

            @Override
            public int size() {
                return RolapCell.this.pos.length;
            }
        };
    }

    @Override
    public Object getValue() {
        if (this.ci.value == Util.nullValue) {
            return null;
        }
        return this.ci.value;
    }

    @Override
    public String getCachedFormatString() {
        return this.ci.formatString;
    }

    @Override
    public String getFormattedValue() {
        return this.ci.getFormatValue();
    }

    @Override
    public boolean isNull() {
        return this.ci.value == Util.nullValue;
    }

    @Override
    public boolean isError() {
        return this.ci.value instanceof Throwable;
    }

    @Override
    public String getDrillThroughSQL(boolean extendedContext) {
        AggregationManager aggMan = AggregationManager.instance();
        Member[] currentMembers = this.getMembersForDrillThrough();
        CellRequest cellRequest = RolapAggregationManager.makeDrillThroughRequest(currentMembers, extendedContext, this.result.getCube());
        return cellRequest == null ? null : ((RolapAggregationManager)aggMan).getDrillThroughSql(cellRequest, false);
    }

    @Override
    public int getDrillThroughCount() {
        AggregationManager aggMan = AggregationManager.instance();
        Member[] currentMembers = this.getMembersForDrillThrough();
        CellRequest cellRequest = RolapAggregationManager.makeDrillThroughRequest(currentMembers, false, this.result.getCube());
        if (cellRequest == null) {
            return -1;
        }
        RolapConnection connection = (RolapConnection)this.result.getQuery().getConnection();
        String sql = ((RolapAggregationManager)aggMan).getDrillThroughSql(cellRequest, true);
        SqlStatement stmt = RolapUtil.executeQuery(connection.getDataSource(), sql, "RolapCell.getDrillThroughCount", "Error while counting drill-through");
        try {
            ResultSet rs = stmt.getResultSet();
            rs.next();
            ++stmt.rowCount;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw stmt.handle(e);
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public boolean canDrillThrough() {
        Member[] currentMembers = this.getMembersForDrillThrough();
        RolapCube x = RolapCell.chooseDrillThroughCube(currentMembers, this.result.getCube());
        return x != null;
    }

    public static RolapCube chooseDrillThroughCube(Member[] currentMembers, RolapCube defaultCube) {
        if (defaultCube != null && defaultCube.isVirtual()) {
            ArrayList<RolapCube> cubes = new ArrayList<RolapCube>();
            for (RolapMember member : defaultCube.getMeasuresMembers()) {
                if (!(member instanceof RolapVirtualCubeMeasure)) continue;
                RolapVirtualCubeMeasure measure = (RolapVirtualCubeMeasure)member;
                cubes.add(measure.getCube());
            }
            defaultCube = (RolapCube)cubes.get(0);
            assert (!defaultCube.isVirtual());
        }
        DrillThroughVisitor visitor = new DrillThroughVisitor();
        try {
            for (Member member : currentMembers) {
                visitor.handleMember(member);
            }
        }
        catch (RuntimeException e) {
            if (e == DrillThroughVisitor.bomb) {
                return null;
            }
            throw e;
        }
        return visitor.cube == null ? defaultCube : visitor.cube;
    }

    private RolapEvaluator getEvaluator() {
        return this.result.getCellEvaluator(this.pos);
    }

    private Member[] getMembersForDrillThrough() {
        RolapHierarchy.RolapCalculatedMeasure measure;
        Member[] currentMembers = this.result.getCellMembers(this.pos);
        if (currentMembers[0] instanceof RolapHierarchy.RolapCalculatedMeasure && (measure = (RolapHierarchy.RolapCalculatedMeasure)currentMembers[0]).getFormula().getExpression() instanceof MemberExpr) {
            currentMembers[0] = ((MemberExpr)measure.getFormula().getExpression()).getMember();
        }
        return currentMembers;
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        boolean matchCase = MondrianProperties.instance().CaseSensitive.get();
        Property property = Property.lookup(propertyName, matchCase);
        Integer defaultValue = null;
        if (property != null) {
            switch (property.ordinal) {
                case 32: {
                    return this.result.getCellOrdinal(this.pos);
                }
                case 41: {
                    return this.getValue();
                }
                case 38: {
                    if (this.ci.formatString == null) {
                        this.ci.formatString = this.getEvaluator().getFormatString();
                    }
                    return this.ci.formatString;
                }
                case 37: {
                    return this.getFormattedValue();
                }
                case 36: {
                    defaultValue = 0;
                    break;
                }
                case 40: {
                    defaultValue = 0;
                    break;
                }
            }
        }
        return this.getEvaluator().getProperty(propertyName, defaultValue);
    }

    @Override
    public Member getContextMember(Dimension dimension) {
        return this.result.getMember(this.pos, dimension);
    }

    private static class DrillThroughVisitor
    extends MdxVisitorImpl {
        static final RuntimeException bomb = new RuntimeException();
        RolapCube cube = null;

        DrillThroughVisitor() {
        }

        public Object visit(MemberExpr memberExpr) {
            this.handleMember(memberExpr.getMember());
            return null;
        }

        public Object visit(ResolvedFunCall call) {
            FunDef def = call.getFunDef();
            Exp[] args = call.getArgs();
            if (def.getName().equals("+") || def.getName().equals("-") || def.getName().equals("/") || def.getName().equals("*") || def.getName().equals("CoalesceEmpty") || def.getName().equals("()") && args.length == 1) {
                this.visitChildren(args);
                return null;
            }
            throw bomb;
        }

        private void visitChildren(Exp[] args) {
            for (Exp arg : args) {
                arg.accept(this);
            }
        }

        public void handleMember(Member member) {
            if (member instanceof RolapStoredMeasure) {
                RolapCube cube = ((RolapStoredMeasure)member).getCube();
                if (this.cube == null) {
                    this.cube = cube;
                } else if (this.cube != cube) {
                    throw bomb;
                }
            } else if (member instanceof RolapCubeMember) {
                this.handleMember(((RolapCubeMember)member).rolapMember);
            } else if (member instanceof RolapHierarchy.RolapCalculatedMeasure) {
                RolapHierarchy.RolapCalculatedMeasure measure = (RolapHierarchy.RolapCalculatedMeasure)member;
                measure.getFormula().getExpression().accept(this);
            } else if (!(member instanceof RolapMember)) {
                throw bomb;
            }
        }

        public Object visit(NamedSetExpr namedSetExpr) {
            throw Util.newInternal("not valid here: " + namedSetExpr);
        }

        public Object visit(Literal literal) {
            return null;
        }

        public Object visit(Query query) {
            throw Util.newInternal("not valid here: " + query);
        }

        public Object visit(QueryAxis queryAxis) {
            throw Util.newInternal("not valid here: " + queryAxis);
        }

        public Object visit(Formula formula) {
            throw Util.newInternal("not valid here: " + formula);
        }

        public Object visit(UnresolvedFunCall call) {
            throw Util.newInternal("expected resolved expression");
        }

        public Object visit(Id id) {
            throw Util.newInternal("expected resolved expression");
        }

        public Object visit(ParameterExpr parameterExpr) {
            throw bomb;
        }

        public Object visit(DimensionExpr dimensionExpr) {
            throw bomb;
        }

        public Object visit(HierarchyExpr hierarchyExpr) {
            throw bomb;
        }

        public Object visit(LevelExpr levelExpr) {
            throw bomb;
        }
    }
}

