/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetRelsHelper;
import net.sf.jasperreports.engine.util.FileBufferedWriter;

public class XlsxSheetHelper
extends BaseHelper {
    private int rowIndex = 0;
    private FileBufferedWriter colsWriter = new FileBufferedWriter();
    private FileBufferedWriter mergedCellsWriter = new FileBufferedWriter();
    private FileBufferedWriter hyperlinksWriter = new FileBufferedWriter();
    private XlsxSheetRelsHelper sheetRelsHelper = null;

    public XlsxSheetHelper(Writer writer, XlsxSheetRelsHelper sheetRelsHelper) {
        super(writer);
        this.sheetRelsHelper = sheetRelsHelper;
    }

    public void exportHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<worksheet\n");
        this.write(" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n");
        this.write("<dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"/></sheetViews>\n");
        this.write("<sheetFormatPr defaultRowHeight=\"15\"/>\n");
    }

    public void exportFooter(int index) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        this.write("</sheetData>\n");
        if (!this.mergedCellsWriter.isEmpty()) {
            this.write("<mergeCells>\n");
            this.mergedCellsWriter.writeData(this.writer);
            this.write("</mergeCells>\n");
        }
        if (!this.hyperlinksWriter.isEmpty()) {
            this.write("<hyperlinks>\n");
            this.hyperlinksWriter.writeData(this.writer);
            this.write("</hyperlinks>\n");
        }
        this.write("<pageMargins left=\"0.7\" right=\"0.7\" top=\"0.75\" bottom=\"0.75\" header=\"0.3\" footer=\"0.3\"/>\n");
        this.write("<drawing r:id=\"rIdDr" + index + "\"/></worksheet>");
    }

    public void exportColumn(int colIndex, int colWidth) {
        try {
            this.colsWriter.write("<col min=\"" + (colIndex + 1) + "\" max=\"" + (colIndex + 1) + "\" customWidth=\"1\" width=\"" + 3.0f * (float)colWidth / 18.0f + "\"/>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void exportRow(int rowHeight) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        ++this.rowIndex;
        this.write("<row r=\"" + this.rowIndex + "\" customHeight=\"1\" ht=\"" + rowHeight + "\">\n");
    }

    public void exportMergedCells(int row, int col, int rowSpan, int colSpan) {
        if (rowSpan > 1 || colSpan > 1) {
            String ref = XlsxCellHelper.getColumIndexLetter(col) + (row + 1) + ":" + XlsxCellHelper.getColumIndexLetter(col + colSpan - 1) + (row + rowSpan);
            try {
                this.mergedCellsWriter.write("<mergeCell ref=\"" + ref + "\"/>\n");
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public void exportHyperlink(int row, int col, String href) {
        String ref = XlsxCellHelper.getColumIndexLetter(col) + (row + 1);
        try {
            this.hyperlinksWriter.write("<hyperlink ref=\"" + ref + "\" r:id=\"rIdLnk" + this.sheetRelsHelper.getHyperlink(href) + "\"/>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }
}

